/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.directmap;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.directmap.DirectMapMappings;

public class DirectMapMappingHashMapTest
extends AutoVerifyTestCase {
    private NullPointerException m_exception;
    private DirectMapMappings queryResult;

    public DirectMapMappingHashMapTest() {
        this.setDescription("Tests that nulls are properly supported for DirectMapMappings that use a HashMap.");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
    }

    public void setup() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.beginTransaction();
    }

    public void test() throws Exception {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        DirectMapMappings maps = (DirectMapMappings)uow.registerObject((Object)new DirectMapMappings());
        maps.directHashMap.put(new Integer(1), "item1");
        maps.directHashMap.put(new Integer(2), "item2");
        maps.directHashMap.put(new Integer(3), null);
        try {
            uow.commit();
        }
        catch (NullPointerException e) {
            this.m_exception = e;
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.queryResult = (DirectMapMappings)this.getSession().executeQuery((DatabaseQuery)new ReadObjectQuery(DirectMapMappings.class));
    }

    public void verify() throws Exception {
        if (this.m_exception != null) {
            throw new TestErrorException("Null pointer exception was caught.");
        }
        if (this.queryResult.directHashMap.size() != 3) {
            throw new TestErrorException("Incorrect amount of items in the hashmap.");
        }
        if (this.queryResult.directHashMap.get(new Integer(3)) != null) {
            throw new TestErrorException("The null value was not read back in correctly.");
        }
    }
}

