/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.advanced;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Project;

public class ReportQueryMultipleReturnTestSuite
extends JUnitTestCase {
    protected boolean m_reset = false;

    public ReportQueryMultipleReturnTestSuite() {
    }

    public ReportQueryMultipleReturnTestSuite(String name) {
        super(name);
    }

    public void setUp() {
        this.m_reset = true;
        super.setUp();
        ReportQueryMultipleReturnTestSuite.clearCache((String)"fieldaccess");
    }

    public void tearDown() {
        if (this.m_reset) {
            this.m_reset = false;
        }
        super.tearDown();
    }

    public void testSimpleReturnDirectToField() {
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.returnWithoutReportQueryResult();
        reportQuery.setReferenceClass(Employee.class);
        ExpressionBuilder empbuilder = new ExpressionBuilder();
        reportQuery.addAttribute("salary", empbuilder.get("salary"));
        reportQuery.setSelectionCriteria(empbuilder.get("salary").greaterThan(1));
        List result = (List)ReportQueryMultipleReturnTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)reportQuery);
        Object resultItem = result.get(0);
        ReportQueryMultipleReturnTestSuite.assertTrue((String)"Failed to return Employees correctly, Not A Number", (boolean)Number.class.isAssignableFrom(resultItem.getClass()));
        ReportQueryMultipleReturnTestSuite.assertTrue((String)"Failed to return Employees correctly, Not Correct Result", (((Number)resultItem).intValue() > 1 ? 1 : 0) != 0);
    }

    public void testSimpleReturnObject() {
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.returnWithoutReportQueryResult();
        reportQuery.setReferenceClass(Employee.class);
        ExpressionBuilder empbuilder = new ExpressionBuilder();
        reportQuery.addAttribute("manager", empbuilder.get("manager"));
        reportQuery.setSelectionCriteria(empbuilder.get("salary").greaterThan(1));
        List result = (List)ReportQueryMultipleReturnTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)reportQuery);
        Object resultItem = result.get(0);
        ReportQueryMultipleReturnTestSuite.assertTrue((String)"Failed to return Employees correctly, Not An Employee", (boolean)Employee.class.isAssignableFrom(resultItem.getClass()));
    }

    public void testReturnObjectAndDirectToField() {
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.returnWithoutReportQueryResult();
        reportQuery.setReferenceClass(Employee.class);
        ExpressionBuilder empbuilder = new ExpressionBuilder();
        reportQuery.addAttribute("salary", empbuilder.get("salary"));
        reportQuery.addAttribute("manager", empbuilder.get("manager"));
        reportQuery.setSelectionCriteria(empbuilder.get("salary").greaterThan(1));
        List result = (List)ReportQueryMultipleReturnTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)reportQuery);
        Object innerResult = result.get(0);
        ReportQueryMultipleReturnTestSuite.assertTrue((String)"Failed to return Employees correctly, Not an Object Array", (boolean)Object[].class.isAssignableFrom(innerResult.getClass()));
        Object resultItem = ((Object[])innerResult)[0];
        ReportQueryMultipleReturnTestSuite.assertTrue((String)"Failed to return Employees correctly, Not A Number", (boolean)Number.class.isAssignableFrom(resultItem.getClass()));
        ReportQueryMultipleReturnTestSuite.assertTrue((String)"Failed to return Employees correctly, Not Correct Result", (((Number)resultItem).intValue() > 1 ? 1 : 0) != 0);
        resultItem = ((Object[])innerResult)[1];
        ReportQueryMultipleReturnTestSuite.assertTrue((String)"Failed to return Employees correctly, Not An Employee", (boolean)Employee.class.isAssignableFrom(resultItem.getClass()));
    }

    public void testReturnUnrelatedObjectAndDirectToField() {
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.returnWithoutReportQueryResult();
        reportQuery.setReferenceClass(Employee.class);
        ExpressionBuilder empbuilder = new ExpressionBuilder();
        ExpressionBuilder addBuilder = new ExpressionBuilder(Address.class);
        reportQuery.addAttribute("salary", empbuilder.get("salary"));
        reportQuery.addAttribute("manager", empbuilder.get("manager"));
        reportQuery.addAttribute("adress.city", addBuilder.get("city"));
        reportQuery.setSelectionCriteria(empbuilder.get("salary").greaterThan(1));
        List result = (List)ReportQueryMultipleReturnTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)reportQuery);
        Object innerResult = result.get(0);
        ReportQueryMultipleReturnTestSuite.assertTrue((String)"Failed to return Employees correctly, Not an Object Array", (boolean)Object[].class.isAssignableFrom(innerResult.getClass()));
        Object resultItem = ((Object[])innerResult)[0];
        ReportQueryMultipleReturnTestSuite.assertTrue((String)"Failed to return Employees correctly, Not A Number", (boolean)Number.class.isAssignableFrom(resultItem.getClass()));
        ReportQueryMultipleReturnTestSuite.assertTrue((String)"Failed to return Employees correctly, Not Correct Result", (((Number)resultItem).intValue() > 1 ? 1 : 0) != 0);
        resultItem = ((Object[])innerResult)[1];
        ReportQueryMultipleReturnTestSuite.assertTrue((String)"Failed to return Employees correctly, Not An Employee", (boolean)Employee.class.isAssignableFrom(resultItem.getClass()));
        resultItem = ((Object[])innerResult)[2];
        ReportQueryMultipleReturnTestSuite.assertTrue((String)"Failed to return Employees correctly, Not a City", (boolean)String.class.isAssignableFrom(resultItem.getClass()));
    }

    public void testInheritanceMultiTableException() {
        try {
            ReportQuery reportQuery = new ReportQuery();
            reportQuery.returnWithoutReportQueryResult();
            reportQuery.setReferenceClass(Project.class);
            ExpressionBuilder empbuilder = new ExpressionBuilder();
            reportQuery.addAttribute("project", (Expression)empbuilder);
            List result = (List)ReportQueryMultipleReturnTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)reportQuery);
            result.size();
        }
        catch (QueryException ex) {
            return;
        }
        ReportQueryMultipleReturnTestSuite.fail((String)"Failed to throw exception, ReportItems must not have multi-table inheritance.");
    }

    public void testReturnRootObject() {
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.returnWithoutReportQueryResult();
        reportQuery.setReferenceClass(LargeProject.class);
        ExpressionBuilder empbuilder = new ExpressionBuilder();
        reportQuery.addAttribute("project", (Expression)empbuilder);
        List result = (List)ReportQueryMultipleReturnTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)reportQuery);
        Object resultItem = result.get(0);
        ReportQueryMultipleReturnTestSuite.assertTrue((String)"Failed to return Project as expression root correctly, Not A Project", (boolean)LargeProject.class.isAssignableFrom(resultItem.getClass()));
    }

    public static Test suite() {
        return new TestSuite(ReportQueryMultipleReturnTestSuite.class);
    }
}

