/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.transparentindirection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.indirection.IndirectCollectionsFactory;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.tests.transparentindirection.TestSession;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndirectMapTest {
    private Hashtable<String, String> map;
    private IndirectMap<String, String> testMap;
    private Listener testMapLsn;
    private Class<? extends IndirectMap> cls;
    private boolean useListener;

    @Parameterized.Parameters(name="{0}, {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({IndirectMap.class, true}, {IndirectMap.class, false}, {M.class, true}, {M.class, false});
    }

    public IndirectMapTest(Class<? extends IndirectMap> cls, boolean useListener) {
        this.cls = cls;
        this.useListener = useListener;
    }

    protected void assertElementsEqual(String message, Map expected, Map actual) {
        if (expected == actual) {
            return;
        }
        if (expected.size() != actual.size()) {
            Assert.assertTrue((String)ZTestCase.notEqualsMessage(message, expected, actual), (boolean)false);
        }
        for (Object key : expected.keySet()) {
            if (expected.get(key).equals(actual.get(key))) continue;
            Assert.assertTrue((String)ZTestCase.notEqualsMessage(message, expected, actual), (boolean)false);
        }
    }

    protected void assertElementsEqual(Map expected, Map actual) {
        this.assertElementsEqual("", expected, actual);
    }

    @Before
    public void setUp() {
        this.map = this.setUpMap();
        Hashtable<String, String> temp = new Hashtable<String, String>(this.map);
        QueryBasedValueHolder vh = new QueryBasedValueHolder((ReadQuery)new ReadAllQuery(), (AbstractRecord)new DatabaseRecord(), (AbstractSession)new TestSession(temp));
        if (this.cls == null) {
            this.testMap = IndirectCollectionsFactory.createIndirectMap();
        } else {
            try {
                this.testMap = this.cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        this.testMap.setValueHolder((ValueHolderInterface)vh);
        if (this.useListener) {
            this.testMapLsn = new Listener();
            this.testMap._persistence_setPropertyChangeListener((PropertyChangeListener)this.testMapLsn);
        }
    }

    protected Hashtable<String, String> setUpMap() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put("zero", "000");
        result.put("one", "111");
        result.put("two", "222");
        result.put("three", "333");
        result.put("four", "444");
        result.put("five", "555");
        result.put("six", "666");
        result.put("seven", "777");
        result.put("eight", "888");
        result.put("nine", "999");
        return result;
    }

    @After
    public void tearDown() {
        if (this.useListener) {
            this.testMapLsn.events.clear();
        }
    }

    @Test
    public void testClear() {
        int originalSize = this.testMap.size();
        this.map.clear();
        this.testMap.clear();
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertTrue((boolean)this.testMap.isEmpty());
        this.assertRemoveEvents(originalSize);
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)this.testMap.contains((Object)this.map.elements().nextElement()));
        this.assertNoEvents();
    }

    @Test
    public void testContainsKey() {
        Assert.assertTrue((boolean)this.testMap.containsKey((Object)this.map.keys().nextElement()));
        this.assertNoEvents();
    }

    @Test
    public void testContainsValue() {
        Assert.assertTrue((boolean)this.testMap.containsValue((Object)this.map.elements().nextElement()));
        this.assertNoEvents();
    }

    @Test
    public void testElements() {
        Assert.assertTrue((String)"Map Does not contain elements from test", (boolean)this.map.contains(this.testMap.elements().nextElement()));
        this.assertNoEvents();
    }

    @Test
    public void testEntrySet() {
        Assert.assertEquals(this.map.entrySet(), (Object)this.testMap.entrySet());
        this.assertNoEvents();
    }

    @Test
    public void testEntrySetAdd() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        UnsupportedOperationException uoe = null;
        try {
            entrySet.add(new MapEntry<String, String>("sampleKey", "sampleValue"));
        }
        catch (UnsupportedOperationException ex) {
            uoe = ex;
        }
        Assert.assertNotNull((Object)uoe);
        try {
            testEntrySet.add(new MapEntry<String, String>("sampleKey", "sampleValue"));
            Assert.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException ex) {
            Assert.assertEquals(uoe.getClass(), ex.getClass());
            Assert.assertEquals((Object)uoe.getMessage(), (Object)ex.getMessage());
        }
        Assert.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
    }

    @Test
    public void testEntrySetAddAll() {
        HashSet<MapEntry<String, String>> collection = new HashSet<MapEntry<String, String>>();
        collection.add(new MapEntry<String, String>("sampleKey1", "sampleValue1"));
        collection.add(new MapEntry<String, String>("sampleKey2", "sampleValue2"));
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        UnsupportedOperationException uoe = null;
        try {
            entrySet.addAll(collection);
        }
        catch (UnsupportedOperationException ex) {
            uoe = ex;
        }
        Assert.assertNotNull((Object)uoe);
        try {
            testEntrySet.addAll(collection);
            Assert.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException ex) {
            Assert.assertEquals(uoe.getClass(), ex.getClass());
            Assert.assertEquals((Object)uoe.getMessage(), (Object)ex.getMessage());
        }
        Assert.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
    }

    @Test
    public void testEntrySetClear() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        entrySet.clear();
        testEntrySet.clear();
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(10);
    }

    @Test
    public void testEntrySetSize() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((long)entrySet.size(), (long)testEntrySet.size());
        this.assertNoEvents();
    }

    @Test
    public void testEntrySetRemove() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        Map.Entry<String, String> toRemove = null;
        for (Map.Entry<String, String> next : entrySet) {
            if (!"one".equals(next.getKey())) continue;
            toRemove = next;
            break;
        }
        boolean result1 = entrySet.remove(toRemove);
        boolean result2 = testEntrySet.remove(toRemove);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)result1, (Object)result2);
        Assert.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(1);
    }

    @Test
    public void testEntrySetRemoveAll() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        HashSet<Map.Entry<String, String>> toRemove = new HashSet<Map.Entry<String, String>>();
        for (Map.Entry<String, String> next : entrySet) {
            if ("one".equals(next.getKey()) || "two".equals(next.getKey())) {
                toRemove.add(next);
            }
            if (toRemove.size() != 2) continue;
            break;
        }
        boolean result1 = entrySet.removeAll(toRemove);
        boolean result2 = testEntrySet.removeAll(toRemove);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)result1, (Object)result2);
        Assert.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(2);
    }

    @Test
    public void testEntrySetRemoveIf() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        boolean result1 = entrySet.removeIf(entry -> "one".equals(entry.getKey()));
        boolean result2 = testEntrySet.removeIf(entry -> "one".equals(entry.getKey()));
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)result1, (Object)result2);
        Assert.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(1);
    }

    @Test
    public void testEntrySetRetainAll() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        HashSet<Map.Entry<String, String>> toRetain = new HashSet<Map.Entry<String, String>>();
        for (Map.Entry<String, String> next : entrySet) {
            if ("one".equals(next.getKey()) || "two".equals(next.getKey())) {
                toRetain.add(next);
            }
            if (toRetain.size() != 2) continue;
            break;
        }
        boolean result1 = entrySet.retainAll(toRetain);
        boolean result2 = testEntrySet.retainAll(toRetain);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertNotNull((Object)this.testMap.get((Object)"one"));
        Assert.assertEquals((Object)result1, (Object)result2);
        Assert.assertNull((Object)this.testMap.get((Object)"six"));
        this.assertRemoveEvents(8);
    }

    @Test
    public void testEquals() {
        Assert.assertFalse((this.testMap == this.map ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.testMap.equals(this.map));
        this.assertNoEvents();
    }

    @Test
    public void testGet() {
        Assert.assertEquals((Object)this.map.get("six"), (Object)this.testMap.get((Object)"six"));
        this.assertNoEvents();
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)this.map.hashCode(), (long)this.testMap.hashCode());
        this.assertNoEvents();
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((!this.testMap.isEmpty() ? 1 : 0) != 0);
        this.assertNoEvents();
    }

    @Test
    public void testKeys() {
        Assert.assertFalse((String)"Map Does not contain keys from test", (boolean)this.map.contains(this.testMap.keys().nextElement()));
        this.assertNoEvents();
    }

    @Test
    public void testKeySet() {
        Assert.assertEquals(this.map.entrySet(), (Object)this.testMap.entrySet());
        this.assertNoEvents();
    }

    @Test
    public void testKeySetAdd() {
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        UnsupportedOperationException uoe = null;
        try {
            keySet.add("newKey");
        }
        catch (UnsupportedOperationException ex) {
            uoe = ex;
        }
        Assert.assertNotNull((Object)uoe);
        try {
            testKeySet.add("newKey");
            Assert.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException ex) {
            Assert.assertEquals(uoe.getClass(), ex.getClass());
            Assert.assertEquals((Object)uoe.getMessage(), (Object)ex.getMessage());
        }
        Assert.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
    }

    @Test
    public void testKeySetAddAll() {
        HashSet<String> collection = new HashSet<String>();
        collection.add("sampleKey1");
        collection.add("sampleKey2");
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        UnsupportedOperationException uoe = null;
        try {
            keySet.addAll(collection);
        }
        catch (UnsupportedOperationException ex) {
            uoe = ex;
        }
        Assert.assertNotNull((Object)uoe);
        try {
            testKeySet.addAll(collection);
            Assert.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException ex) {
            Assert.assertEquals(uoe.getClass(), ex.getClass());
            Assert.assertEquals((Object)uoe.getMessage(), (Object)ex.getMessage());
        }
        Assert.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
    }

    @Test
    public void testKeySetClear() {
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        keySet.clear();
        testKeySet.clear();
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(10);
    }

    @Test
    public void testKeySetSize() {
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((long)keySet.size(), (long)testKeySet.size());
        this.assertNoEvents();
    }

    @Test
    public void testKeySetRemove() {
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        boolean result1 = keySet.remove("one");
        boolean result2 = testKeySet.remove("one");
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)result1, (Object)result2);
        Assert.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(1);
    }

    @Test
    public void testKeySetRemoveAll() {
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        HashSet<String> toRemove = new HashSet<String>();
        toRemove.add("one");
        toRemove.add("two");
        boolean result1 = keySet.removeAll(toRemove);
        boolean result2 = testKeySet.removeAll(toRemove);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)result1, (Object)result2);
        Assert.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(2);
    }

    @Test
    public void testKeySetRemoveIf() {
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        boolean result1 = keySet.removeIf(key -> key.startsWith("s"));
        boolean result2 = testKeySet.removeIf(key -> key.startsWith("s"));
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)result1, (Object)result2);
        Assert.assertNull((Object)this.testMap.get((Object)"six"));
        this.assertRemoveEvents(2);
    }

    @Test
    public void testKeySetRetainAll() {
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        HashSet<String> toRetain = new HashSet<String>();
        toRetain.add("one");
        toRetain.add("two");
        boolean result1 = keySet.retainAll(toRetain);
        boolean result2 = testKeySet.retainAll(toRetain);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertNotNull((Object)this.testMap.get((Object)"one"));
        Assert.assertEquals((Object)result1, (Object)result2);
        Assert.assertNull((Object)this.testMap.get((Object)"six"));
        this.assertRemoveEvents(8);
    }

    @Test
    public void testPut() {
        String key = "foo";
        String value = "bar";
        String result1 = this.map.put(key, value);
        String result2 = (String)this.testMap.put((Object)key, (Object)value);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertTrue((boolean)this.testMap.containsKey((Object)key));
        Assert.assertTrue((boolean)this.testMap.contains((Object)value));
        Assert.assertEquals((Object)result1, (Object)result2);
        this.assertAddEvents(1);
    }

    @Test
    public void testPutAll() {
        Hashtable<String, String> temp = new Hashtable<String, String>();
        temp.put("foo", "bar");
        temp.put("sna", "fu");
        this.map.putAll(temp);
        this.testMap.putAll(temp);
        Assert.assertEquals(this.map, this.testMap);
        Enumeration<Object> stream = temp.keys();
        while (stream.hasMoreElements()) {
            Assert.assertTrue((boolean)this.testMap.containsKey(stream.nextElement()));
        }
        stream = temp.elements();
        while (stream.hasMoreElements()) {
            Assert.assertTrue((boolean)this.testMap.contains(stream.nextElement()));
        }
        this.assertAddEvents(2);
    }

    @Test
    public void testRemove() {
        String temp = "one";
        String result1 = this.map.remove(temp);
        String result2 = (String)this.testMap.remove((Object)temp);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)result1, (Object)result2);
        Assert.assertNotNull((Object)result2);
        Assert.assertTrue((!this.testMap.containsKey((Object)temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(1);
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)this.map.size(), (long)this.testMap.size());
        this.assertNoEvents();
    }

    @Test
    public void testValues() {
        Assert.assertEquals((long)this.map.size(), (long)this.testMap.values().size());
        Iterator stream = this.testMap.values().iterator();
        while (stream.hasNext()) {
            Assert.assertTrue((boolean)this.map.contains(stream.next()));
        }
        this.map.values().removeAll(this.testMap.values());
        Assert.assertTrue((boolean)this.map.values().isEmpty());
        this.assertNoEvents();
    }

    @Test
    public void testValuesAdd() {
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        UnsupportedOperationException uoe = null;
        try {
            keySet.add("newValue");
        }
        catch (UnsupportedOperationException ex) {
            uoe = ex;
        }
        Assert.assertNotNull((Object)uoe);
        try {
            testKeySet.add("newValue");
            Assert.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException ex) {
            Assert.assertEquals(uoe.getClass(), ex.getClass());
            Assert.assertEquals((Object)uoe.getMessage(), (Object)ex.getMessage());
        }
        Assert.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
    }

    @Test
    public void testValuesAddAll() {
        HashSet<String> collection = new HashSet<String>();
        collection.add("newValue1");
        collection.add("newValue2");
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        UnsupportedOperationException uoe = null;
        try {
            keySet.addAll(collection);
        }
        catch (UnsupportedOperationException ex) {
            uoe = ex;
        }
        Assert.assertNotNull((Object)uoe);
        try {
            testKeySet.addAll(collection);
            Assert.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException ex) {
            Assert.assertEquals(uoe.getClass(), ex.getClass());
            Assert.assertEquals((Object)uoe.getMessage(), (Object)ex.getMessage());
        }
        Assert.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
    }

    @Test
    public void testValuesClear() {
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        keySet.clear();
        testKeySet.clear();
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(10);
    }

    @Test
    public void testValuesSize() {
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((long)keySet.size(), (long)testKeySet.size());
        this.assertNoEvents();
    }

    @Test
    public void testValuesRemove() {
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        boolean result1 = keySet.remove("111");
        boolean result2 = testKeySet.remove("111");
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)result1, (Object)result2);
        Assert.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(1);
    }

    @Test
    public void testValuesRemoveAll() {
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        HashSet<String> toRemove = new HashSet<String>();
        toRemove.add("111");
        toRemove.add("222");
        boolean result1 = keySet.removeAll(toRemove);
        boolean result2 = testKeySet.removeAll(toRemove);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)result1, (Object)result2);
        Assert.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(2);
    }

    @Test
    public void testValuesRemoveIf() {
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        boolean result1 = keySet.removeIf(key -> key.startsWith("2"));
        boolean result2 = testKeySet.removeIf(key -> key.startsWith("2"));
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)result1, (Object)result2);
        Assert.assertNull((Object)this.testMap.get((Object)"two"));
        this.assertRemoveEvents(1);
    }

    @Test
    public void testValueRetainAll() {
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        HashSet<String> toRetain = new HashSet<String>();
        toRetain.add("111");
        toRetain.add("222");
        boolean result1 = keySet.retainAll(toRetain);
        boolean result2 = testKeySet.retainAll(toRetain);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertNotNull((Object)this.testMap.get((Object)"one"));
        Assert.assertEquals((Object)result1, (Object)result2);
        Assert.assertNull((Object)this.testMap.get((Object)"six"));
        this.assertRemoveEvents(8);
    }

    @Test
    public void testReplace() {
        Assert.assertEquals(this.map, this.testMap);
        Object o = this.testMap.replace((Object)"one", (Object)"1");
        Assert.assertEquals((Object)this.map.replace("one", "1"), (Object)o);
        Assert.assertNotNull((String)"Should return value", (Object)o);
        Assert.assertEquals((Object)"111", (Object)o);
        Assert.assertEquals((Object)"1", (Object)this.testMap.get((Object)"one"));
        Assert.assertEquals(this.map, this.testMap);
        this.assertRemoveAddEvents(1);
        Assert.assertNull((Object)this.map.replace("blablablabla", "whatever"));
        Assert.assertNull((Object)this.testMap.replace((Object)"blablablabla", (Object)"whatever"));
        Assert.assertEquals(this.map, this.testMap);
        this.assertRemoveAddEvents(1);
    }

    @Test
    public void testReplaceWithDefault() {
        Assert.assertEquals((Object)"111", (Object)this.testMap.get((Object)"one"));
        Boolean o = this.testMap.replace((Object)"one", (Object)"1", (Object)"1234");
        Assert.assertEquals((Object)this.map.replace("one", "1", "1234"), (Object)o);
        Assert.assertFalse((String)"Should return false", (boolean)o);
        Assert.assertFalse((String)"Should not have '1234'", (boolean)this.testMap.containsValue((Object)"1234"));
        Assert.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
        Assert.assertEquals((Object)"111", (Object)this.testMap.get((Object)"one"));
        o = this.testMap.replace((Object)"one", (Object)"111", (Object)"1234");
        Assert.assertEquals((Object)this.map.replace("one", "111", "1234"), (Object)o);
        Assert.assertTrue((String)"Should return true", (boolean)o);
        Assert.assertEquals((Object)"1234", (Object)this.testMap.get((Object)"one"));
        Assert.assertEquals(this.map, this.testMap);
        this.assertRemoveAddEvents(1);
    }

    @Test
    public void testGetOrDefault() {
        Assert.assertFalse((boolean)this.testMap.containsKey((Object)"temp"));
        Object o = this.testMap.getOrDefault((Object)"temp", (Object)"1234");
        Assert.assertNotNull((String)"Should return value", (Object)o);
        Assert.assertEquals((Object)"1234", (Object)o);
        Assert.assertTrue((boolean)this.testMap.containsKey((Object)"one"));
        o = this.testMap.getOrDefault((Object)"one", (Object)"5678");
        Assert.assertNotNull((String)"Should return value", (Object)o);
        Assert.assertEquals((Object)"111", (Object)o);
        this.assertNoEvents();
    }

    @Test
    public void testPutIfAbsent() {
        Assert.assertFalse((boolean)this.testMap.containsKey((Object)"temp"));
        Object o = this.testMap.putIfAbsent((Object)"temp", (Object)"1234");
        Assert.assertNull((String)"Should return null", (Object)o);
        this.assertAddEvents(1);
        Assert.assertTrue((boolean)this.testMap.containsKey((Object)"temp"));
        o = this.testMap.putIfAbsent((Object)"temp", (Object)"5678");
        Assert.assertNotNull((String)"Should return value", (Object)o);
        Assert.assertEquals((Object)"1234", (Object)o);
        this.assertAddEvents(1);
    }

    @Test
    public void testRemoveTwoArgs() {
        Assert.assertEquals((Object)"111", (Object)this.testMap.get((Object)"one"));
        Boolean o = this.testMap.remove((Object)"one", (Object)"1234");
        Assert.assertFalse((String)"Should return false", (boolean)o);
        this.assertNoEvents();
        Assert.assertEquals((Object)"111", (Object)this.testMap.get((Object)"one"));
        o = this.testMap.remove((Object)"one", (Object)"111");
        Assert.assertTrue((String)"Should return true", (boolean)o);
        Assert.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(1);
    }

    @Test
    public void testForEach() {
        Vector v1 = new Vector();
        Vector v2 = new Vector();
        this.map.forEach((k, v) -> {
            v1.add(k);
            v1.add(v);
        });
        this.testMap.forEach((k, v) -> {
            v2.add(k);
            v2.add(v);
        });
        ZTestCase.assertUnorderedElementsEqual(v1, v2);
        Assert.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
    }

    @Test
    public void testReplaceAll() {
        Assert.assertEquals(this.map, this.testMap);
        this.map.replaceAll((k, v) -> {
            v = v + "sufix";
            return v;
        });
        this.testMap.replaceAll((k, v) -> {
            v = v + "sufix";
            return v;
        });
        Assert.assertEquals(this.map, this.testMap);
        this.assertRemoveAddEvents(this.testMap.size());
    }

    @Test
    public void testCompute() {
        Assert.assertEquals(this.map, this.testMap);
        String s1 = this.map.compute("one", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        String s2 = (String)this.testMap.compute((Object)"one", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)"111suffix", (Object)this.testMap.get((Object)"one"));
        this.assertRemoveAddEvents(1);
    }

    @Test
    public void testCompute2() {
        Assert.assertEquals(this.map, this.testMap);
        String s1 = this.map.compute("notExist", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        String s2 = (String)this.testMap.compute((Object)"notExist", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)"nullsuffix", (Object)this.testMap.get((Object)"notExist"));
        this.assertAddEvents(1);
    }

    @Test
    public void testComputeIfPresent() {
        Assert.assertEquals(this.map, this.testMap);
        String s1 = this.map.computeIfPresent("one", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        String s2 = (String)this.testMap.computeIfPresent((Object)"one", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)"111suffix", (Object)this.testMap.get((Object)"one"));
        this.assertRemoveAddEvents(1);
    }

    @Test
    public void testComputeIfPresent2() {
        Assert.assertEquals(this.map, this.testMap);
        String s1 = this.map.computeIfPresent("notExist", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        String s2 = (String)this.testMap.computeIfPresent((Object)"notExist", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertNull((Object)this.testMap.get((Object)"notExist"));
        this.assertNoEvents();
    }

    @Test
    public void testComputeIfAbsent() {
        Assert.assertEquals(this.map, this.testMap);
        String s1 = this.map.computeIfAbsent("one", k -> "newitem");
        String s2 = (String)this.testMap.computeIfAbsent((Object)"one", k -> "newitem");
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)"111", (Object)this.testMap.get((Object)"one"));
        this.assertNoEvents();
    }

    @Test
    public void testComputeIfAbsent2() {
        Assert.assertEquals(this.map, this.testMap);
        String s1 = this.map.computeIfAbsent("notExist", k -> "newitem");
        String s2 = (String)this.testMap.computeIfAbsent((Object)"notExist", k -> "newitem");
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals(this.map, this.testMap);
        this.assertAddEvents(1);
    }

    @Test
    public void testMerge() {
        Assert.assertEquals(this.map, this.testMap);
        String s1 = this.map.merge("one", "custom", String::concat);
        String s2 = (String)this.testMap.merge((Object)"one", (Object)"custom", String::concat);
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)"111custom", (Object)this.testMap.get((Object)"one"));
        this.assertRemoveAddEvents(1);
    }

    @Test
    public void testMerge2() {
        Assert.assertEquals(this.map, this.testMap);
        String s1 = this.map.merge("notExist", "custom", String::concat);
        String s2 = (String)this.testMap.merge((Object)"notExist", (Object)"custom", String::concat);
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals(this.map, this.testMap);
        Assert.assertEquals((Object)"111", (Object)this.testMap.get((Object)"one"));
        this.assertAddEvents(1);
    }

    private void assertNoEvents() {
        if (this.useListener) {
            Assert.assertTrue((boolean)this.testMapLsn.events.isEmpty());
        }
    }

    private void assertAddEvents(int count) {
        if (this.useListener) {
            Assert.assertEquals((String)"events do not match", (long)count, (long)this.testMapLsn.events.size());
            for (MapChangeEvent cce : this.testMapLsn.events) {
                Assert.assertEquals((String)"expected add event", (long)0L, (long)cce.getChangeType());
            }
        }
    }

    private void assertRemoveEvents(int count) {
        if (this.useListener) {
            Assert.assertEquals((String)"events do not match", (long)count, (long)this.testMapLsn.events.size());
            for (MapChangeEvent cce : this.testMapLsn.events) {
                Assert.assertEquals((String)"expected add event", (long)1L, (long)cce.getChangeType());
            }
        }
    }

    private void assertRemoveAddEvents(int count) {
        if (this.useListener) {
            int totalEvents = count * 2;
            Assert.assertEquals((String)"events do not match", (long)totalEvents, (long)this.testMapLsn.events.size());
            int i = 0;
            while (i < totalEvents) {
                MapChangeEvent removeEvent = (MapChangeEvent)this.testMapLsn.events.get(i++);
                MapChangeEvent addEvent = (MapChangeEvent)this.testMapLsn.events.get(i++);
                Assert.assertEquals((String)"expected remove event", (long)1L, (long)removeEvent.getChangeType());
                Assert.assertEquals((String)"expected add event", (long)0L, (long)addEvent.getChangeType());
                Assert.assertFalse((String)("removed: '" + removeEvent.getNewValue() + "', new: '" + addEvent.getNewValue() + "'"), (boolean)removeEvent.getNewValue().equals(addEvent.getNewValue()));
            }
        }
    }

    private static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return this.value;
        }
    }

    private static final class Listener
    implements PropertyChangeListener {
        private List<MapChangeEvent> events = new ArrayList<MapChangeEvent>();

        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.events.add((MapChangeEvent)evt);
        }
    }

    public static final class M<K, V>
    extends IndirectMap<K, V> {
    }
}

