/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.java;

import java.lang.reflect.Method;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;

public class MethodTest
extends PerformanceComparisonTestCase {
    protected int index = 0;

    public MethodTest() {
        this.setName("MethodExecution vs SynchronizedMethod PerformanceComparisonTest");
        this.setDescription("This test compares the performance for final, synchronized and normal method execution.");
        this.addSynchronizedTest();
        this.addSynchronizedBlockTest();
        this.addFinalTest();
        this.addReflectionTest();
        this.addInlinedTest();
        this.addNormalTest();
        this.addNormalTest2();
        this.addNormalTest3();
        this.addVolatileTest();
    }

    public void test() throws Throwable {
        for (int index = 0; index < 100; ++index) {
            this.doTest();
        }
    }

    public void doTest() {
        this.index += 10;
        if (this.index > 1000) {
            this.index = 0;
        }
    }

    public void addSynchronizedTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){
            protected int index2 = 0;

            public void test() {
                for (int index = 0; index < 100; ++index) {
                    this.doTest();
                }
            }

            public synchronized void doTest() {
                this.index2 += 10;
                if (this.index2 > 1000) {
                    this.index2 = 0;
                }
            }
        };
        test.setName("SynchronizedTest");
        test.setAllowableDecrease(-10.0);
        this.addTest((TestCase)test);
    }

    public void addSynchronizedBlockTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){
            protected int index2 = 0;

            public void test() {
                for (int index = 0; index < 100; ++index) {
                    this.doTest();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doTest() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    this.index2 += 10;
                    if (this.index2 > 1000) {
                        this.index2 = 0;
                    }
                }
            }
        };
        test.setName("SynchronizedBlockTest");
        this.addTest((TestCase)test);
    }

    public void addFinalTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){
            protected int index2 = 0;

            public final void test() {
                for (int index = 0; index < 100; ++index) {
                    this.doTest();
                }
            }

            public final void doTest() {
                this.index2 += 10;
                if (this.index2 > 1000) {
                    this.index2 = 0;
                }
            }
        };
        test.setName("FinalTest");
        this.addTest((TestCase)test);
    }

    public void addReflectionTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){
            protected int index2 = 0;
            public Method method;
            public Object[] args;

            public void startTest() {
                if (this.method == null) {
                    Class[] argTypes = new Class[]{};
                    try {
                        this.method = ((Object)((Object)this)).getClass().getMethod("doTest", argTypes);
                    }
                    catch (Exception ignore) {
                        throw new RuntimeException(ignore);
                    }
                    this.args = new Object[0];
                }
            }

            public final void test() {
                for (int index = 0; index < 100; ++index) {
                    try {
                        this.method.invoke((Object)this, this.args);
                        continue;
                    }
                    catch (Exception ignore) {
                        throw new RuntimeException(ignore);
                    }
                }
            }

            public void doTest() {
                this.index2 += 10;
                if (this.index2 > 1000) {
                    this.index2 = 0;
                }
            }
        };
        test.setName("ReflectionTest");
        this.addTest((TestCase)test);
    }

    public void addInlinedTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){
            protected int index2 = 0;

            public void test() {
                for (int index = 0; index < 100; ++index) {
                    this.index2 += 10;
                    if (this.index2 <= 1000) continue;
                    this.index2 = 0;
                }
            }
        };
        test.setName("InlinedTest");
        this.addTest((TestCase)test);
    }

    public void addNormalTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                for (int index = 0; index < 100; ++index) {
                    this.doTest();
                }
            }

            public void doTest() {
                MethodTest.this.index += 10;
                if (MethodTest.this.index > 1000) {
                    MethodTest.this.index = 0;
                }
            }
        };
        test.setName("NormalTest");
        this.addTest((TestCase)test);
    }

    public void addNormalTest2() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                for (int index = 0; index < 100; ++index) {
                    MethodTest.this.doTest();
                }
            }
        };
        test.setName("NormalTest2");
        this.addTest((TestCase)test);
    }

    public void addNormalTest3() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){
            protected int index2 = 0;

            public void test() {
                for (int index = 0; index < 100; ++index) {
                    this.doTest();
                }
            }

            public void doTest() {
                this.index2 += 10;
                if (this.index2 > 1000) {
                    this.index2 = 0;
                }
            }
        };
        test.setName("NormalTest3");
        this.addTest((TestCase)test);
    }

    public void addVolatileTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){
            protected volatile int index2 = 0;

            public void test() {
                for (int index = 0; index < 100; ++index) {
                    this.doTest();
                }
            }

            public void doTest() {
                this.index2 += 10;
                if (this.index2 > 1000) {
                    this.index2 = 0;
                }
            }
        };
        test.setName("VolatileTest");
        this.addTest((TestCase)test);
    }
}

