/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.changeflag;

import junit.framework.Test;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangeTrackingPolicy;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllCallTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectCallTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.collections.CollectionsSystem;
import org.eclipse.persistence.testing.models.collections.Restaurant;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.tests.employee.EmployeeBasicTestModel;
import org.eclipse.persistence.testing.tests.employee.EmployeeDeleteTest;
import org.eclipse.persistence.testing.tests.employee.ProjectDeleteTest;
import org.eclipse.persistence.testing.tests.unitofwork.DeepMergeCloneSerializedObjectReferenceChangesTest;
import org.eclipse.persistence.testing.tests.unitofwork.DeepMergeCloneSerializedTest;
import org.eclipse.persistence.testing.tests.unitofwork.DeepNestedUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.MultipleUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.NestedUnitOfWorkMultipleCommitTest;
import org.eclipse.persistence.testing.tests.unitofwork.NestedUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkCommitAndResume;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkCommitResumeOnFailureNoFailureTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkResumeOnFailureTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkResumeTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkRevertTest;
import org.eclipse.persistence.testing.tests.unitofwork.changeflag.ChangeEventTest;
import org.eclipse.persistence.testing.tests.unitofwork.changeflag.ChangeFlagTest;
import org.eclipse.persistence.testing.tests.writing.ComplexUpdateTest;
import org.eclipse.persistence.testing.tests.writing.UpdateChangeNothingTest;
import org.eclipse.persistence.testing.tests.writing.UpdateChangeObjectTest;
import org.eclipse.persistence.testing.tests.writing.UpdateChangeValueTest;
import org.eclipse.persistence.testing.tests.writing.UpdateToNullTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class EmployeeChangeFlagBasicTestModel
extends EmployeeBasicTestModel {
    protected ObjectChangePolicy employeeChangePolicy;
    protected ObjectChangePolicy addressChangePolicy;
    protected ObjectChangePolicy projectChangePolicy;
    protected ObjectChangePolicy smallProjectChangePolicy;
    protected ObjectChangePolicy largeProjectChangePolicy;
    protected ObjectChangePolicy employmentPeriodChangePolicy;
    protected ObjectChangePolicy phoneNumberChangePolicy;
    protected ObjectChangePolicy restaurantChangePolicy;

    public EmployeeChangeFlagBasicTestModel() {
        this.setDescription("This model tests reading/writing/deleting using the employee demo with ObjectChangeTrackingPolicy flag.");
    }

    @Override
    public void addRequiredSystems() {
        this.addRequiredSystem(new EmployeeSystem());
        this.addRequiredSystem(new CollectionsSystem());
    }

    @Override
    public void addTests() {
        this.addTest((Test)EmployeeChangeFlagBasicTestModel.getReadObjectTestSuite());
        this.addTest((Test)EmployeeChangeFlagBasicTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)EmployeeChangeFlagBasicTestModel.getInsertObjectTestSuite());
        this.addTest((Test)EmployeeChangeFlagBasicTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)EmployeeChangeFlagBasicTestModel.getReadAllTestSuite());
        this.addTest((Test)this.getUnitOfWorkTestSuite());
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the employee demo.");
        EmployeePopulator system = new EmployeePopulator();
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample3()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample4()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample5()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample3()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample3()));
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the employee demo.");
        suite.addTest((Test)new ReadAllTest(Employee.class, 12));
        suite.addTest((Test)new ReadAllTest(Project.class, 15));
        suite.addTest((Test)new ReadAllTest(LargeProject.class, 5));
        suite.addTest((Test)new ReadAllTest(SmallProject.class, 10));
        suite.addTest((Test)new ReadAllCallTest(Employee.class, 12, (Call)new SQLCall("SELECT  t0.VERSION, t1.EMP_ID, t0.L_NAME, t0.F_NAME, t1.SALARY, t0.EMP_ID, t0.GENDER, t0.END_DATE, t0.START_DATE, t0.MANAGER_ID, t0.END_TIME, t0.START_TIME, t0.ADDR_ID FROM EMPLOYEE t0, SALARY t1 WHERE t1.EMP_ID = t0.EMP_ID")));
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0005")));
        Employee employee = (Employee)manager.getObject(employeeClass, "0001");
        suite.addTest((Test)new ReadObjectCallTest(employeeClass, (Call)new SQLCall("SELECT t0.VERSION, t1.EMP_ID, t0.L_NAME, t0.F_NAME, t1.SALARY, t0.EMP_ID, t0.GENDER, t0.END_DATE, t0.START_DATE, t0.MANAGER_ID, t0.END_TIME, t0.START_TIME, t0.ADDR_ID FROM EMPLOYEE t0, SALARY t1 WHERE t1.EMP_ID = t0.EMP_ID AND t0.F_NAME = '" + employee.getFirstName() + "' AND t0.L_NAME = '" + employee.getLastName() + "'")));
        employee = (Employee)manager.getObject(employeeClass, "0002");
        suite.addTest((Test)new ReadObjectCallTest(employeeClass, (Call)new SQLCall("SELECT  t0.VERSION, t1.EMP_ID, t0.L_NAME, t0.F_NAME, t1.SALARY, t0.EMP_ID, t0.GENDER, t0.END_DATE, t0.START_DATE, t0.MANAGER_ID, t0.END_TIME, t0.START_TIME, t0.ADDR_ID FROM EMPLOYEE t0, SALARY t1 WHERE t1.EMP_ID = t0.EMP_ID AND t0.F_NAME = '" + employee.getFirstName() + "' AND t0.L_NAME = '" + employee.getLastName() + "'")));
        employee = (Employee)manager.getObject(employeeClass, "0003");
        suite.addTest((Test)new ReadObjectCallTest(employeeClass, (Call)new SQLCall("SELECT  t0.VERSION, t1.EMP_ID, t0.L_NAME, t0.F_NAME, t1.SALARY, t0.EMP_ID, t0.GENDER, t0.END_DATE, t0.START_DATE, t0.MANAGER_ID, t0.END_TIME, t0.START_TIME, t0.ADDR_ID FROM EMPLOYEE t0, SALARY t1 WHERE t1.EMP_ID = t0.EMP_ID AND t0.F_NAME = '" + employee.getFirstName() + "' AND t0.L_NAME = '" + employee.getLastName() + "'")));
        Project project = (Project)manager.getObject(largeProjectClass, "0001");
        ReadObjectTest test = new ReadObjectTest((Object)project);
        test.setQuery(new ReadObjectQuery(Project.class, new ExpressionBuilder().get("id").equal((Object)project.getId())));
        suite.addTest((Test)test);
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public TestSuite getUnitOfWorkTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Unit Of Work Update Test Suite");
        suite.setDescription("This suite tests change flags for updates using UnitOfWork");
        PopulationManager manager = PopulationManager.getDefaultManager();
        Employee employee = (Employee)manager.getObject(Employee.class, "0001");
        ComplexUpdateTest test = new UpdateToNullTest(employee);
        test.usesUnitOfWork = true;
        suite.addTest((Test)test);
        test = new UpdateChangeValueTest(employee);
        test.usesUnitOfWork = true;
        suite.addTest((Test)test);
        test = new UpdateChangeNothingTest(employee);
        test.usesUnitOfWork = true;
        suite.addTest((Test)test);
        test = new UpdateChangeObjectTest(employee);
        test.usesUnitOfWork = true;
        suite.addTest((Test)test);
        suite.addTest((Test)new NestedUnitOfWorkTest(employee));
        suite.addTest((Test)new NestedUnitOfWorkMultipleCommitTest(employee));
        suite.addTest((Test)new DeepNestedUnitOfWorkTest(employee));
        suite.addTest((Test)new MultipleUnitOfWorkTest(employee));
        suite.addTest((Test)new UnitOfWorkResumeTest(employee));
        suite.addTest((Test)new UnitOfWorkResumeOnFailureTest(employee));
        suite.addTest((Test)new UnitOfWorkCommitResumeOnFailureNoFailureTest(employee));
        suite.addTest((Test)new UnitOfWorkCommitAndResume(employee));
        suite.addTest((Test)new UnitOfWorkRevertTest(employee));
        suite.addTest((Test)new ChangeFlagTest());
        suite.addTest((Test)new ChangeEventTest());
        suite.addTest((Test)new DeepMergeCloneSerializedTest());
        suite.addTest((Test)new DeepMergeCloneSerializedObjectReferenceChangesTest());
        return suite;
    }

    public void setup() {
        this.employeeChangePolicy = this.getSession().getDescriptor(Employee.class).getObjectChangePolicy();
        this.getSession().getDescriptor(Employee.class).setObjectChangePolicy((ObjectChangePolicy)new ObjectChangeTrackingPolicy());
        this.addressChangePolicy = this.getSession().getDescriptor(Address.class).getObjectChangePolicy();
        this.getSession().getDescriptor(Address.class).setObjectChangePolicy((ObjectChangePolicy)new ObjectChangeTrackingPolicy());
        this.projectChangePolicy = this.getSession().getDescriptor(Project.class).getObjectChangePolicy();
        this.getSession().getDescriptor(Project.class).setObjectChangePolicy((ObjectChangePolicy)new ObjectChangeTrackingPolicy());
        this.smallProjectChangePolicy = this.getSession().getDescriptor(SmallProject.class).getObjectChangePolicy();
        this.getSession().getDescriptor(SmallProject.class).setObjectChangePolicy((ObjectChangePolicy)new ObjectChangeTrackingPolicy());
        this.largeProjectChangePolicy = this.getSession().getDescriptor(LargeProject.class).getObjectChangePolicy();
        this.getSession().getDescriptor(LargeProject.class).setObjectChangePolicy((ObjectChangePolicy)new ObjectChangeTrackingPolicy());
        this.employmentPeriodChangePolicy = this.getSession().getDescriptor(EmploymentPeriod.class).getObjectChangePolicy();
        this.getSession().getDescriptor(EmploymentPeriod.class).setObjectChangePolicy((ObjectChangePolicy)new ObjectChangeTrackingPolicy());
        this.getSession().getDescriptor(Employee.class).getMappingForAttributeName("period").getReferenceDescriptor().setObjectChangePolicy((ObjectChangePolicy)new ObjectChangeTrackingPolicy());
        this.phoneNumberChangePolicy = this.getSession().getDescriptor(PhoneNumber.class).getObjectChangePolicy();
        this.getSession().getDescriptor(PhoneNumber.class).setObjectChangePolicy((ObjectChangePolicy)new ObjectChangeTrackingPolicy());
    }

    public void reset() {
        this.getSession().getDescriptor(Employee.class).setObjectChangePolicy(this.employeeChangePolicy);
        this.getSession().getDescriptor(Address.class).setObjectChangePolicy(this.addressChangePolicy);
        this.getSession().getDescriptor(Project.class).setObjectChangePolicy(this.projectChangePolicy);
        this.getSession().getDescriptor(SmallProject.class).setObjectChangePolicy(this.smallProjectChangePolicy);
        this.getSession().getDescriptor(LargeProject.class).setObjectChangePolicy(this.largeProjectChangePolicy);
        this.getSession().getDescriptor(EmploymentPeriod.class).setObjectChangePolicy(this.employmentPeriodChangePolicy);
        this.getSession().getDescriptor(Employee.class).getMappingForAttributeName("period").getReferenceDescriptor().setObjectChangePolicy(this.employmentPeriodChangePolicy);
        this.getSession().getDescriptor(PhoneNumber.class).setObjectChangePolicy(this.phoneNumberChangePolicy);
        this.getSession().getDescriptor(Restaurant.class).setObjectChangePolicy(this.restaurantChangePolicy);
    }
}

