/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework.ui;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.TestCollection;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestExecutor;
import org.eclipse.persistence.testing.framework.ui.SynchronizedTester;

public class SynchronizedTestExecutor
extends Thread {
    protected Test test;
    protected TestExecutor executor;
    protected SynchronizedTester tester;
    protected boolean shouldRunSetupOnly;

    public SynchronizedTestExecutor(TestExecutor executor, Test test, SynchronizedTester tool) {
        this.executor = executor;
        this.test = test;
        this.tester = tool;
        this.shouldRunSetupOnly = false;
    }

    public TestExecutor getExecutor() {
        return this.executor;
    }

    public Test getTest() {
        return this.test;
    }

    public SynchronizedTester getTester() {
        return this.tester;
    }

    @Override
    public void run() {
        if (this.getTest() == null) {
            throw new TestErrorException("There is now test entity to run.");
        }
        try {
            if (this.shouldRunSetupOnly()) {
                ((TestCollection)this.getTest()).setupEntity();
            } else {
                this.getExecutor().runTest(this.getTest());
            }
        }
        catch (Throwable exception) {
            this.getTester().notifyException(exception);
        }
        finally {
            this.getTester().finishedTest();
        }
    }

    protected void setExecutor(TestExecutor executor) {
        this.executor = executor;
    }

    public void setShouldRunSetupOnly(boolean shouldRunSetupOnly) {
        this.shouldRunSetupOnly = shouldRunSetupOnly;
    }

    public void setTest(Test test) {
        this.test = test;
    }

    protected void setTester(SynchronizedTester tester) {
        this.tester = tester;
    }

    public boolean shouldRunSetupOnly() {
        return this.shouldRunSetupOnly;
    }

    public void stopExecution() {
        this.getExecutor().stopExecution();
    }
}

