/*******************************************************************************
 * Copyright (c) 1998, 2018 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 ******************************************************************************/
package org.eclipse.persistence.testing.tests.junit.security;

import org.junit.Assert;
import org.junit.Test;
import org.eclipse.persistence.internal.security.Securable;
import org.eclipse.persistence.internal.helper.ConversionManager;

/**
 * Test the actual JCE encryption and decryption. Main reason why this test case
 * would fail is because something changed with the secret key.
 *
 * A warning will be issued if JCE could not be found, that is, we couldn't
 * instantiate a JCE object through the conversion manager.
 *
 * @author Guy Pelletier
 */
public class JCEEncryptionTest {

    @Test
    public void test() {
        String toEncrypt = "testString";
        Securable encryptor = convertToEncryptionObject("org.eclipse.persistence.internal.security.JCEEncryptor");
        Assert.assertNotNull("JCE object could not be created.", encryptor);
        String decrypted = encryptor.decryptPassword(encryptor.encryptPassword(toEncrypt));
        Assert.assertEquals("The JCE encryption --> decryption failed", toEncrypt, decrypted);
    }

    /**
     * Convert a String into a Securable object
     * Class name must be fully qualified, eg. org.eclipse.persistence.internal.security.JCEEncryptor
     */
    private Securable convertToEncryptionObject(String encryptionClassName) {
        try {
            ConversionManager cm = ConversionManager.getDefaultManager();
            Class securableClass = (Class)cm.convertObject(encryptionClassName, Class.class);
            return (Securable)securableClass.newInstance();
        } catch (Throwable e) {
            return null;
        }
    }
}
