/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.listeners;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class EntityListener<T>
extends DescriptorEventAdapter {
    public static final String POST_BUILD = "postBuild";
    public static final String POST_CLONE = "postClone";
    public static final String POST_DELETE = "postDelete";
    public static final String POST_INSERT = "postInsert";
    public static final String POST_REFRESH = "postRefresh";
    public static final String POST_UPDATE = "postUpdate";
    public static final String PRE_PERSIST = "prePersist";
    public static final String PRE_REMOVE = "preRemove";
    public static final String PRE_UPDATE_WITH_CHANGES = "preUpdateWithChanges";
    private T m_listener;
    private Class<T> m_listenerClass;
    private Class m_entityClass;
    private Map<String, List<Method>> m_methods;
    private final Map<String, Map<Integer, Boolean>> m_overriddenEvents;
    private static final Map<Integer, String> m_eventStrings;
    private AbstractSession owningSession;

    static {
        HashMap<Integer, String> mappings = new HashMap<Integer, String>(9);
        mappings.put(8, POST_BUILD);
        mappings.put(10, POST_CLONE);
        mappings.put(3, POST_DELETE);
        mappings.put(5, POST_INSERT);
        mappings.put(9, POST_REFRESH);
        mappings.put(7, POST_UPDATE);
        mappings.put(15, PRE_PERSIST);
        mappings.put(16, PRE_REMOVE);
        mappings.put(17, PRE_UPDATE_WITH_CHANGES);
        m_eventStrings = Collections.unmodifiableMap(mappings);
    }

    protected EntityListener(Class entityClass) {
        this.m_entityClass = entityClass;
        this.m_methods = new ConcurrentHashMap<String, List<Method>>();
        this.m_overriddenEvents = new ConcurrentHashMap<String, Map<Integer, Boolean>>();
    }

    public EntityListener(Class<T> listenerClass, Class entityClass) {
        this(entityClass);
        this.m_listenerClass = listenerClass;
    }

    public void addEventMethod(String event, Method method) {
        if (this.m_methods.containsKey(event)) {
            Method lastEventMethod = this.getLastEventMethod(event);
            if (lastEventMethod.getDeclaringClass().equals(method.getDeclaringClass())) {
                throw ValidationException.multipleLifecycleCallbackMethodsForSameLifecycleEvent(this.getListenerClass(), method, lastEventMethod);
            }
            this.validateMethod(method);
            this.m_methods.get(event).add(method);
        } else {
            this.validateMethod(method);
            ArrayList<Method> methods = new ArrayList<Method>();
            methods.add(method);
            this.m_methods.put(event, methods);
        }
    }

    protected T createEntityListenerAndInjectDependencies(Class<T> entityListenerClass) {
        try {
            return this.owningSession.getInjectionManager().createManagedBeanAndInjectDependencies(entityListenerClass);
        }
        catch (Exception e) {
            this.owningSession.logThrowable(1, "jpa", e);
            return null;
        }
    }

    protected T constructListenerInstance() {
        T entityListenerClassInstance;
        block7: {
            entityListenerClassInstance = this.createEntityListenerAndInjectDependencies(this.m_listenerClass);
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        if (entityListenerClassInstance == null) {
                            entityListenerClassInstance = AccessController.doPrivileged(new PrivilegedNewInstanceFromClass<T>(this.m_listenerClass));
                        }
                        break block7;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.errorInstantiatingClass(this.m_listenerClass, exception.getException());
                    }
                }
                if (entityListenerClassInstance == null) {
                    entityListenerClassInstance = PrivilegedAccessHelper.newInstanceFromClass(this.m_listenerClass);
                }
            }
            catch (IllegalAccessException | InstantiationException exception) {
                throw ValidationException.errorInstantiatingClass(this.m_listenerClass, exception);
            }
        }
        return entityListenerClassInstance;
    }

    public Class getEntityClass() {
        return this.m_entityClass;
    }

    public Map<String, List<Method>> getAllEventMethods() {
        return this.m_methods;
    }

    public void setAllEventMethods(Map<String, List<Method>> methods) {
        this.m_methods = methods;
    }

    public void setOwningSession(AbstractSession owningSession) {
        this.owningSession = owningSession;
    }

    protected List<Method> getEventMethods(int eventCode) {
        String eventString = m_eventStrings.get(eventCode);
        return eventString != null ? this.getEventMethods(eventString) : null;
    }

    protected List<Method> getEventMethods(String event) {
        return this.m_methods.get(event);
    }

    protected Method getLastEventMethod(String event) {
        List<Method> methods = this.m_methods.get(event);
        return methods.get(methods.size() - 1);
    }

    public T getListener() {
        if (this.m_listener == null) {
            this.m_listener = this.constructListenerInstance();
        }
        return this.m_listener;
    }

    public Class getListenerClass() {
        return this.m_listenerClass;
    }

    public AbstractSession getOwningSession() {
        return this.owningSession;
    }

    public boolean hasCallbackMethods() {
        return this.m_methods.size() > 0;
    }

    protected boolean hasEventMethods(int eventCode) {
        return this.getEventMethods(eventCode) != null;
    }

    protected boolean hasEventMethods(String event) {
        return this.getEventMethods(event) != null;
    }

    protected boolean hasOverriddenEventMethod(List<Method> eventMethods, Method eventMethod) {
        if (eventMethods != null) {
            for (Method method : eventMethods) {
                if (!method.getName().equals(eventMethod.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasOverriddenEventMethod(Method eventMethod, int eventCode) {
        return this.hasOverriddenEventMethod(this.getEventMethods(eventCode), eventMethod);
    }

    protected boolean hasOverriddenEventMethod(Method eventMethod, String eventCode) {
        return this.hasOverriddenEventMethod(this.getEventMethods(eventCode), eventMethod);
    }

    void invokeMethod(Method method, Object onObject, Object[] objectList) {
        block10: {
            if (method != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(method, onObject, objectList));
                            break block10;
                        }
                        catch (PrivilegedActionException exception) {
                            Exception throwableException = exception.getException();
                            if (throwableException instanceof IllegalAccessException) {
                                throw ValidationException.invalidCallbackMethod(onObject.getClass(), method.toString());
                            }
                            Throwable cause = throwableException.getCause();
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            throw (Error)cause;
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod(method, onObject, objectList);
                }
                catch (IllegalAccessException exception) {
                    throw ValidationException.invalidCallbackMethod(onObject.getClass(), method.toString());
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw (Error)cause;
                }
            }
        }
    }

    void invokeMethod(String event, DescriptorEvent descriptorEvent) {
        List<Method> eventMethods = this.getEventMethods(event);
        if (eventMethods != null) {
            for (Method method : eventMethods) {
                Object[] objectList = new Object[]{descriptorEvent.getSource()};
                this.invokeMethod(method, this.getListener(), objectList);
            }
        }
    }

    @Override
    public boolean isOverriddenEvent(DescriptorEvent event, List<DescriptorEventManager> eventManagers) {
        int eventCode = event.getEventCode();
        String forSubclass = event.getDescriptor().getJavaClassName();
        Map<Integer, Boolean> subClassMap = this.m_overriddenEvents.get(forSubclass);
        if (subClassMap == null) {
            subClassMap = new ConcurrentHashMap<Integer, Boolean>();
        }
        if (!subClassMap.containsKey(eventCode)) {
            boolean hasOverrides = false;
            if (this.hasEventMethods(eventCode)) {
                List<Method> eventMethods = this.getEventMethods(eventCode);
                for (Method eventMethod : eventMethods) {
                    for (DescriptorEventManager eventManager : eventManagers) {
                        EntityListener childListener = (EntityListener)eventManager.getEntityEventListener();
                        if (childListener == this) break;
                        if (!childListener.hasOverriddenEventMethod(eventMethod, eventCode)) continue;
                        hasOverrides = true;
                        break;
                    }
                    if (hasOverrides) break;
                }
            }
            subClassMap.put(eventCode, hasOverrides);
            this.m_overriddenEvents.put(forSubclass, subClassMap);
        }
        return subClassMap.get(eventCode);
    }

    @Override
    public void postBuild(DescriptorEvent event) {
        this.invokeMethod(POST_BUILD, event);
    }

    @Override
    public void postClone(DescriptorEvent event) {
        this.invokeMethod(POST_CLONE, event);
    }

    @Override
    public void postDelete(DescriptorEvent event) {
        this.invokeMethod(POST_DELETE, event);
    }

    @Override
    public void postInsert(DescriptorEvent event) {
        this.invokeMethod(POST_INSERT, event);
    }

    @Override
    public void postRefresh(DescriptorEvent event) {
        this.invokeMethod(POST_REFRESH, event);
    }

    @Override
    public void postUpdate(DescriptorEvent event) {
        this.invokeMethod(POST_UPDATE, event);
    }

    @Override
    public void prePersist(DescriptorEvent event) {
        this.invokeMethod(PRE_PERSIST, event);
    }

    @Override
    public void preRemove(DescriptorEvent event) {
        this.invokeMethod(PRE_REMOVE, event);
    }

    @Override
    public void preUpdateWithChanges(DescriptorEvent event) {
        this.invokeMethod(PRE_UPDATE_WITH_CHANGES, event);
    }

    public void setPostBuildMethod(Method method) {
        this.addEventMethod(POST_BUILD, method);
    }

    public void setPostCloneMethod(Method method) {
        this.addEventMethod(POST_CLONE, method);
    }

    public void setPostDeleteMethod(Method method) {
        this.addEventMethod(POST_DELETE, method);
    }

    public void setPostInsertMethod(Method method) {
        this.addEventMethod(POST_INSERT, method);
    }

    public void setPostRefreshMethod(Method method) {
        this.addEventMethod(POST_REFRESH, method);
    }

    public void setPostUpdateMethod(Method method) {
        this.addEventMethod(POST_UPDATE, method);
    }

    public void setPrePersistMethod(Method method) {
        this.addEventMethod(PRE_PERSIST, method);
    }

    public void setPreRemoveMethod(Method method) {
        this.addEventMethod(PRE_REMOVE, method);
    }

    public void setPreUpdateWithChangesMethod(Method method) {
        this.addEventMethod(PRE_UPDATE_WITH_CHANGES, method);
    }

    public String toString() {
        return this.getEntityClass().getName();
    }

    protected void validateMethod(Method method) {
        int numberOfParameters = method.getParameterTypes().length;
        if (numberOfParameters != 1 || !method.getParameterTypes()[0].isAssignableFrom(this.m_entityClass)) {
            Class<?> parameterClass = numberOfParameters == 0 ? null : method.getParameterTypes()[0];
            throw ValidationException.invalidEntityListenerCallbackMethodArguments(this.m_entityClass, parameterClass, this.getListenerClass(), method.getName());
        }
        this.validateMethodModifiers(method);
    }

    protected void validateMethodModifiers(Method method) {
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
            throw ValidationException.invalidCallbackMethodModifier(this.getListenerClass(), method.getName());
        }
    }
}

