/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.Opcodes;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.tree.AbstractInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.IincInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.InsnList;
import org.eclipse.persistence.internal.libraries.asm.tree.JumpInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.LabelNode;
import org.eclipse.persistence.internal.libraries.asm.tree.LookupSwitchInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.MethodNode;
import org.eclipse.persistence.internal.libraries.asm.tree.TableSwitchInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.TryCatchBlockNode;
import org.eclipse.persistence.internal.libraries.asm.tree.VarInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.AnalyzerException;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Frame;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Interpreter;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Subroutine;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Value;

public class Analyzer<V extends Value>
implements Opcodes {
    private final Interpreter<V> interpreter;
    private InsnList insnList;
    private int insnListSize;
    private List<TryCatchBlockNode>[] handlers;
    private Frame<V>[] frames;
    private Subroutine[] subroutines;
    private boolean[] inInstructionsToProcess;
    private int[] instructionsToProcess;
    private int numInstructionsToProcess;

    public Analyzer(Interpreter<V> interpreter) {
        this.interpreter = interpreter;
    }

    public Frame<V>[] analyze(String string, MethodNode methodNode) throws AnalyzerException {
        List<TryCatchBlockNode> list;
        Object object;
        if ((methodNode.access & 0x500) != 0) {
            this.frames = new Frame[0];
            return this.frames;
        }
        this.insnList = methodNode.instructions;
        this.insnListSize = this.insnList.size();
        this.handlers = new List[this.insnListSize];
        this.frames = new Frame[this.insnListSize];
        this.subroutines = new Subroutine[this.insnListSize];
        this.inInstructionsToProcess = new boolean[this.insnListSize];
        this.instructionsToProcess = new int[this.insnListSize];
        this.numInstructionsToProcess = 0;
        for (int i = 0; i < methodNode.tryCatchBlocks.size(); ++i) {
            object = methodNode.tryCatchBlocks.get(i);
            int n = this.insnList.indexOf(((TryCatchBlockNode)object).start);
            int n2 = this.insnList.indexOf(((TryCatchBlockNode)object).end);
            for (int j = n; j < n2; ++j) {
                list = this.handlers[j];
                if (list == null) {
                    list = new ArrayList<TryCatchBlockNode>();
                    this.handlers[j] = list;
                }
                list.add((TryCatchBlockNode)object);
            }
        }
        Subroutine subroutine = new Subroutine(null, methodNode.maxLocals, null);
        object = new ArrayList();
        this.findSubroutine(0, subroutine, (List<AbstractInsnNode>)object);
        HashMap<LabelNode, Subroutine> hashMap = new HashMap<LabelNode, Subroutine>();
        while (!object.isEmpty()) {
            JumpInsnNode jumpInsnNode = (JumpInsnNode)object.remove(0);
            Subroutine subroutine2 = (Subroutine)hashMap.get(jumpInsnNode.label);
            if (subroutine2 == null) {
                subroutine2 = new Subroutine(jumpInsnNode.label, methodNode.maxLocals, jumpInsnNode);
                hashMap.put(jumpInsnNode.label, subroutine2);
                this.findSubroutine(this.insnList.indexOf(jumpInsnNode.label), subroutine2, (List<AbstractInsnNode>)object);
                continue;
            }
            subroutine2.callers.add(jumpInsnNode);
        }
        for (int i = 0; i < this.insnListSize; ++i) {
            if (this.subroutines[i] == null || this.subroutines[i].start != null) continue;
            this.subroutines[i] = null;
        }
        Frame<V> frame = this.computeInitialFrame(string, methodNode);
        this.merge(0, frame, null);
        this.init(string, methodNode);
        while (this.numInstructionsToProcess > 0) {
            int n = this.instructionsToProcess[--this.numInstructionsToProcess];
            list = this.frames[n];
            Subroutine subroutine3 = this.subroutines[n];
            this.inInstructionsToProcess[n] = false;
            AbstractInsnNode abstractInsnNode = null;
            try {
                int n3;
                Object object2;
                abstractInsnNode = methodNode.instructions.get(n);
                int n4 = abstractInsnNode.getOpcode();
                int n5 = abstractInsnNode.getType();
                if (n5 == 8 || n5 == 15 || n5 == 14) {
                    this.merge(n + 1, (Frame<V>)((Object)list), subroutine3);
                    this.newControlFlowEdge(n, n + 1);
                } else {
                    int n6;
                    frame.init((Frame<V>)((Object)list)).execute(abstractInsnNode, this.interpreter);
                    Subroutine subroutine4 = subroutine3 = subroutine3 == null ? null : new Subroutine(subroutine3);
                    if (abstractInsnNode instanceof JumpInsnNode) {
                        object2 = (JumpInsnNode)abstractInsnNode;
                        if (n4 != 167 && n4 != 168) {
                            this.merge(n + 1, frame, subroutine3);
                            this.newControlFlowEdge(n, n + 1);
                        }
                        n3 = this.insnList.indexOf(((JumpInsnNode)object2).label);
                        if (n4 == 168) {
                            this.merge(n3, frame, new Subroutine(((JumpInsnNode)object2).label, methodNode.maxLocals, (JumpInsnNode)object2));
                        } else {
                            this.merge(n3, frame, subroutine3);
                        }
                        this.newControlFlowEdge(n, n3);
                    } else if (abstractInsnNode instanceof LookupSwitchInsnNode) {
                        object2 = (LookupSwitchInsnNode)abstractInsnNode;
                        n3 = this.insnList.indexOf(((LookupSwitchInsnNode)object2).dflt);
                        this.merge(n3, frame, subroutine3);
                        this.newControlFlowEdge(n, n3);
                        for (n6 = 0; n6 < ((LookupSwitchInsnNode)object2).labels.size(); ++n6) {
                            n3 = this.insnList.indexOf(((LookupSwitchInsnNode)object2).labels.get(n6));
                            this.merge(n3, frame, subroutine3);
                            this.newControlFlowEdge(n, n3);
                        }
                    } else if (abstractInsnNode instanceof TableSwitchInsnNode) {
                        object2 = (TableSwitchInsnNode)abstractInsnNode;
                        n3 = this.insnList.indexOf(((TableSwitchInsnNode)object2).dflt);
                        this.merge(n3, frame, subroutine3);
                        this.newControlFlowEdge(n, n3);
                        for (n6 = 0; n6 < ((TableSwitchInsnNode)object2).labels.size(); ++n6) {
                            n3 = this.insnList.indexOf(((TableSwitchInsnNode)object2).labels.get(n6));
                            this.merge(n3, frame, subroutine3);
                            this.newControlFlowEdge(n, n3);
                        }
                    } else if (n4 == 169) {
                        if (subroutine3 == null) {
                            throw new AnalyzerException(abstractInsnNode, "RET instruction outside of a sub routine");
                        }
                        for (int i = 0; i < subroutine3.callers.size(); ++i) {
                            JumpInsnNode jumpInsnNode = subroutine3.callers.get(i);
                            n6 = this.insnList.indexOf(jumpInsnNode);
                            if (this.frames[n6] == null) continue;
                            this.merge(n6 + 1, this.frames[n6], frame, this.subroutines[n6], subroutine3.localsUsed);
                            this.newControlFlowEdge(n, n6 + 1);
                        }
                    } else if (n4 != 191 && (n4 < 172 || n4 > 177)) {
                        if (subroutine3 != null) {
                            if (abstractInsnNode instanceof VarInsnNode) {
                                int n7 = ((VarInsnNode)abstractInsnNode).var;
                                subroutine3.localsUsed[n7] = true;
                                if (n4 == 22 || n4 == 24 || n4 == 55 || n4 == 57) {
                                    subroutine3.localsUsed[n7 + 1] = true;
                                }
                            } else if (abstractInsnNode instanceof IincInsnNode) {
                                int n8 = ((IincInsnNode)abstractInsnNode).var;
                                subroutine3.localsUsed[n8] = true;
                            }
                        }
                        this.merge(n + 1, frame, subroutine3);
                        this.newControlFlowEdge(n, n + 1);
                    }
                }
                if ((object2 = this.handlers[n]) == null) continue;
                for (n3 = 0; n3 < object2.size(); ++n3) {
                    TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)object2.get(n3);
                    Type type = tryCatchBlockNode.type == null ? Type.getObjectType("java/lang/Throwable") : Type.getObjectType(tryCatchBlockNode.type);
                    if (!this.newControlFlowExceptionEdge(n, tryCatchBlockNode)) continue;
                    Frame<V> frame2 = new Frame<V>(list);
                    frame2.clearStack();
                    frame2.push(this.interpreter.newValue(type));
                    this.merge(this.insnList.indexOf(tryCatchBlockNode.handler), frame2, subroutine3);
                }
            }
            catch (AnalyzerException analyzerException) {
                throw new AnalyzerException(analyzerException.node, "Error at instruction " + n + ": " + analyzerException.getMessage(), analyzerException);
            }
            catch (Exception exception) {
                throw new AnalyzerException(abstractInsnNode, "Error at instruction " + n + ": " + exception.getMessage(), exception);
            }
        }
        return this.frames;
    }

    private void findSubroutine(int n, Subroutine subroutine, List<AbstractInsnNode> list) throws AnalyzerException {
        int n2 = n;
        while (true) {
            Object object;
            int n3;
            Object object2;
            if (n2 < 0 || n2 >= this.insnListSize) {
                throw new AnalyzerException(null, "Execution can fall off the end of the code");
            }
            if (this.subroutines[n2] != null) {
                return;
            }
            this.subroutines[n2] = new Subroutine(subroutine);
            AbstractInsnNode abstractInsnNode = this.insnList.get(n2);
            if (abstractInsnNode instanceof JumpInsnNode) {
                if (abstractInsnNode.getOpcode() == 168) {
                    list.add(abstractInsnNode);
                } else {
                    object2 = (JumpInsnNode)abstractInsnNode;
                    this.findSubroutine(this.insnList.indexOf(((JumpInsnNode)object2).label), subroutine, list);
                }
            } else if (abstractInsnNode instanceof TableSwitchInsnNode) {
                object2 = (TableSwitchInsnNode)abstractInsnNode;
                this.findSubroutine(this.insnList.indexOf(((TableSwitchInsnNode)object2).dflt), subroutine, list);
                for (n3 = ((TableSwitchInsnNode)object2).labels.size() - 1; n3 >= 0; --n3) {
                    object = ((TableSwitchInsnNode)object2).labels.get(n3);
                    this.findSubroutine(this.insnList.indexOf((AbstractInsnNode)object), subroutine, list);
                }
            } else if (abstractInsnNode instanceof LookupSwitchInsnNode) {
                object2 = (LookupSwitchInsnNode)abstractInsnNode;
                this.findSubroutine(this.insnList.indexOf(((LookupSwitchInsnNode)object2).dflt), subroutine, list);
                for (n3 = ((LookupSwitchInsnNode)object2).labels.size() - 1; n3 >= 0; --n3) {
                    object = ((LookupSwitchInsnNode)object2).labels.get(n3);
                    this.findSubroutine(this.insnList.indexOf((AbstractInsnNode)object), subroutine, list);
                }
            }
            object2 = this.handlers[n2];
            if (object2 != null) {
                for (n3 = 0; n3 < object2.size(); ++n3) {
                    object = (TryCatchBlockNode)object2.get(n3);
                    this.findSubroutine(this.insnList.indexOf(((TryCatchBlockNode)object).handler), subroutine, list);
                }
            }
            switch (abstractInsnNode.getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
            }
            ++n2;
        }
    }

    private Frame<V> computeInitialFrame(String string, MethodNode methodNode) {
        Type[] typeArray;
        Frame<V> frame = this.newFrame(methodNode.maxLocals, methodNode.maxStack);
        int n = 0;
        if ((methodNode.access & 8) == 0) {
            typeArray = Type.getObjectType(string);
            frame.setLocal(n++, this.interpreter.newValue((Type)typeArray));
        }
        typeArray = Type.getArgumentTypes(methodNode.desc);
        for (int i = 0; i < typeArray.length; ++i) {
            frame.setLocal(n++, this.interpreter.newValue(typeArray[i]));
            if (typeArray[i].getSize() != 2) continue;
            frame.setLocal(n++, this.interpreter.newValue(null));
        }
        while (n < methodNode.maxLocals) {
            frame.setLocal(n++, this.interpreter.newValue(null));
        }
        frame.setReturn(this.interpreter.newValue(Type.getReturnType(methodNode.desc)));
        return frame;
    }

    public Frame<V>[] getFrames() {
        return this.frames;
    }

    public List<TryCatchBlockNode> getHandlers(int n) {
        return this.handlers[n];
    }

    protected void init(String string, MethodNode methodNode) throws AnalyzerException {
    }

    protected Frame<V> newFrame(int n, int n2) {
        return new Frame(n, n2);
    }

    protected Frame<V> newFrame(Frame<? extends V> frame) {
        return new Frame<V>(frame);
    }

    protected void newControlFlowEdge(int n, int n2) {
    }

    protected boolean newControlFlowExceptionEdge(int n, int n2) {
        return true;
    }

    protected boolean newControlFlowExceptionEdge(int n, TryCatchBlockNode tryCatchBlockNode) {
        return this.newControlFlowExceptionEdge(n, this.insnList.indexOf(tryCatchBlockNode.handler));
    }

    private void merge(int n, Frame<V> frame, Subroutine subroutine) throws AnalyzerException {
        boolean bl;
        Frame<V> frame2 = this.frames[n];
        if (frame2 == null) {
            this.frames[n] = this.newFrame(frame);
            bl = true;
        } else {
            bl = frame2.merge(frame, this.interpreter);
        }
        Subroutine subroutine2 = this.subroutines[n];
        if (subroutine2 == null) {
            if (subroutine != null) {
                this.subroutines[n] = new Subroutine(subroutine);
                bl = true;
            }
        } else if (subroutine != null) {
            bl |= subroutine2.merge(subroutine);
        }
        if (bl && !this.inInstructionsToProcess[n]) {
            this.inInstructionsToProcess[n] = true;
            this.instructionsToProcess[this.numInstructionsToProcess++] = n;
        }
    }

    private void merge(int n, Frame<V> frame, Frame<V> frame2, Subroutine subroutine, boolean[] blArray) throws AnalyzerException {
        boolean bl;
        frame2.merge(frame, blArray);
        Frame<V> frame3 = this.frames[n];
        if (frame3 == null) {
            this.frames[n] = this.newFrame(frame2);
            bl = true;
        } else {
            bl = frame3.merge(frame2, this.interpreter);
        }
        Subroutine subroutine2 = this.subroutines[n];
        if (subroutine2 != null && subroutine != null) {
            bl |= subroutine2.merge(subroutine);
        }
        if (bl && !this.inInstructionsToProcess[n]) {
            this.inInstructionsToProcess[n] = true;
            this.instructionsToProcess[this.numInstructionsToProcess++] = n;
        }
    }
}

