/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime.debug;

import org.eclipse.persistence.internal.libraries.antlr.runtime.RecognitionException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.Token;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.debug.DebugEventListener;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeAdaptor;

public class DebugTreeAdaptor
implements TreeAdaptor {
    protected DebugEventListener dbg;
    protected TreeAdaptor adaptor;

    public DebugTreeAdaptor(DebugEventListener debugEventListener, TreeAdaptor treeAdaptor) {
        this.dbg = debugEventListener;
        this.adaptor = treeAdaptor;
    }

    @Override
    public Object create(Token token) {
        if (token.getTokenIndex() < 0) {
            return this.create(token.getType(), token.getText());
        }
        Object object = this.adaptor.create(token);
        this.dbg.createNode(object, token);
        return object;
    }

    @Override
    public Object errorNode(TokenStream tokenStream, Token token, Token token2, RecognitionException recognitionException) {
        Object object = this.adaptor.errorNode(tokenStream, token, token2, recognitionException);
        if (object != null) {
            this.dbg.errorNode(object);
        }
        return object;
    }

    @Override
    public Object dupTree(Object object) {
        Object object2 = this.adaptor.dupTree(object);
        this.simulateTreeConstruction(object2);
        return object2;
    }

    protected void simulateTreeConstruction(Object object) {
        this.dbg.createNode(object);
        int n = this.adaptor.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = this.adaptor.getChild(object, i);
            this.simulateTreeConstruction(object2);
            this.dbg.addChild(object, object2);
        }
    }

    @Override
    public Object dupNode(Object object) {
        Object object2 = this.adaptor.dupNode(object);
        this.dbg.createNode(object2);
        return object2;
    }

    @Override
    public Object nil() {
        Object object = this.adaptor.nil();
        this.dbg.nilNode(object);
        return object;
    }

    @Override
    public boolean isNil(Object object) {
        return this.adaptor.isNil(object);
    }

    @Override
    public void addChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            return;
        }
        this.adaptor.addChild(object, object2);
        this.dbg.addChild(object, object2);
    }

    @Override
    public Object becomeRoot(Object object, Object object2) {
        Object object3 = this.adaptor.becomeRoot(object, object2);
        this.dbg.becomeRoot(object, object2);
        return object3;
    }

    @Override
    public Object rulePostProcessing(Object object) {
        return this.adaptor.rulePostProcessing(object);
    }

    public void addChild(Object object, Token token) {
        Object object2 = this.create(token);
        this.addChild(object, object2);
    }

    @Override
    public Object becomeRoot(Token token, Object object) {
        Object object2 = this.create(token);
        this.adaptor.becomeRoot(object2, object);
        this.dbg.becomeRoot(token, object);
        return object2;
    }

    @Override
    public Object create(int n, Token token) {
        Object object = this.adaptor.create(n, token);
        this.dbg.createNode(object);
        return object;
    }

    @Override
    public Object create(int n, Token token, String string) {
        Object object = this.adaptor.create(n, token, string);
        this.dbg.createNode(object);
        return object;
    }

    @Override
    public Object create(int n, String string) {
        Object object = this.adaptor.create(n, string);
        this.dbg.createNode(object);
        return object;
    }

    @Override
    public int getType(Object object) {
        return this.adaptor.getType(object);
    }

    @Override
    public void setType(Object object, int n) {
        this.adaptor.setType(object, n);
    }

    @Override
    public String getText(Object object) {
        return this.adaptor.getText(object);
    }

    @Override
    public void setText(Object object, String string) {
        this.adaptor.setText(object, string);
    }

    @Override
    public Token getToken(Object object) {
        return this.adaptor.getToken(object);
    }

    @Override
    public void setTokenBoundaries(Object object, Token token, Token token2) {
        this.adaptor.setTokenBoundaries(object, token, token2);
        if (object != null && token != null && token2 != null) {
            this.dbg.setTokenBoundaries(object, token.getTokenIndex(), token2.getTokenIndex());
        }
    }

    @Override
    public int getTokenStartIndex(Object object) {
        return this.adaptor.getTokenStartIndex(object);
    }

    @Override
    public int getTokenStopIndex(Object object) {
        return this.adaptor.getTokenStopIndex(object);
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.adaptor.getChild(object, n);
    }

    @Override
    public void setChild(Object object, int n, Object object2) {
        this.adaptor.setChild(object, n, object2);
    }

    @Override
    public Object deleteChild(Object object, int n) {
        return this.deleteChild(object, n);
    }

    @Override
    public int getChildCount(Object object) {
        return this.adaptor.getChildCount(object);
    }

    @Override
    public int getUniqueID(Object object) {
        return this.adaptor.getUniqueID(object);
    }

    @Override
    public Object getParent(Object object) {
        return this.adaptor.getParent(object);
    }

    @Override
    public int getChildIndex(Object object) {
        return this.adaptor.getChildIndex(object);
    }

    @Override
    public void setParent(Object object, Object object2) {
        this.adaptor.setParent(object, object2);
    }

    @Override
    public void setChildIndex(Object object, int n) {
        this.adaptor.setChildIndex(object, n);
    }

    @Override
    public void replaceChildren(Object object, int n, int n2, Object object2) {
        this.adaptor.replaceChildren(object, n, n2, object2);
    }

    public DebugEventListener getDebugListener() {
        return this.dbg;
    }

    public void setDebugListener(DebugEventListener debugEventListener) {
        this.dbg = debugEventListener;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }
}

