/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.HashMap;
import java.util.Vector;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.UpdateAllQueryTestHelper;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;

public class UpdateAllQueryAdvancedJunitTest
extends JUnitTestCase {
    protected static Class[] classes = new Class[]{Employee.class, Address.class, PhoneNumber.class, Project.class};
    protected static Vector[] objectVectors = new Vector[]{null, null, null, null};
    protected static EmployeePopulator populator = new EmployeePopulator();

    public UpdateAllQueryAdvancedJunitTest() {
    }

    public UpdateAllQueryAdvancedJunitTest(String name) {
        super(name);
    }

    public void setUp() {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession().getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.warning((String)"UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        this.clearCache();
        super.setUp();
        if (!UpdateAllQueryAdvancedJunitTest.compare()) {
            this.clear();
            this.populate();
        }
    }

    protected static DatabaseSession getDbSession() {
        return UpdateAllQueryAdvancedJunitTest.getServerSession();
    }

    protected static UnitOfWork acquireUnitOfWork() {
        return UpdateAllQueryAdvancedJunitTest.getDbSession().acquireUnitOfWork();
    }

    protected void clear() {
        UnitOfWork uow = UpdateAllQueryAdvancedJunitTest.acquireUnitOfWork();
        UpdateAllQuery updateEmployees = new UpdateAllQuery(Employee.class);
        updateEmployees.addUpdate("manager", null);
        updateEmployees.addUpdate("address", null);
        uow.executeQuery((DatabaseQuery)updateEmployees);
        UpdateAllQuery updateProjects = new UpdateAllQuery(Project.class);
        updateProjects.addUpdate("teamLeader", null);
        uow.executeQuery((DatabaseQuery)updateProjects);
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(PhoneNumber.class));
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Address.class));
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Employee.class));
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(Project.class));
        uow.commit();
        this.clearCache();
    }

    protected void populate() {
        populator.buildExamples();
        populator.persistExample((Session)UpdateAllQueryAdvancedJunitTest.getDbSession());
        this.clearCache();
        for (int i = 0; i < classes.length; ++i) {
            UpdateAllQueryAdvancedJunitTest.objectVectors[i] = UpdateAllQueryAdvancedJunitTest.getDbSession().readAllObjects(classes[i]);
        }
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(UpdateAllQueryAdvancedJunitTest.class);
        return new TestSetup((Test)suite){

            protected void setUp() {
                new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
            }

            protected void tearDown() {
                new UpdateAllQueryAdvancedJunitTest().clearCache();
            }
        };
    }

    public static void testFirstNamePrefixBLAForAll() {
        ExpressionBuilder builder = new ExpressionBuilder();
        UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class);
        updateQuery.addUpdate("firstName", Expression.fromLiteral((String)"'BLA'", null).concat((Object)builder.get("firstName")));
        UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
    }

    public static void testFirstNamePrefixBLAForSalary() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression selectionExpression = builder.get("salary").lessThan(20000);
        UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class, selectionExpression);
        updateQuery.addUpdate("firstName", Expression.fromLiteral((String)"'BLA'", null).concat((Object)builder.get("firstName")));
        UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
    }

    public static void testDoubleSalaryForAll() {
        ExpressionBuilder builder = new ExpressionBuilder();
        UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class);
        updateQuery.addUpdate("salary", ExpressionMath.multiply((Expression)builder.get("salary"), (Object)new Integer(2)));
        UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
    }

    public static void testDoubleSalaryForSalary() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression selectionExpression = builder.get("salary").lessThan(20000);
        UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class, selectionExpression);
        updateQuery.addUpdate("salary", ExpressionMath.multiply((Expression)builder.get("salary"), (Object)new Integer(2)));
        UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
    }

    public static void testFirstNamePrefixBLADoubleSalaryForAll() {
        ExpressionBuilder builder = new ExpressionBuilder();
        UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class);
        updateQuery.addUpdate("firstName", Expression.fromLiteral((String)"'BLA'", null).concat((Object)builder.get("firstName")));
        updateQuery.addUpdate("salary", ExpressionMath.multiply((Expression)builder.get("salary"), (Object)new Integer(2)));
        UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
    }

    public static void testFirstNamePrefixBLADoubleSalaryForSalary() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression selectionExpression = builder.get("salary").lessThan(20000);
        UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class, selectionExpression);
        updateQuery.addUpdate("firstName", Expression.fromLiteral((String)"'BLA'", null).concat((Object)builder.get("firstName")));
        updateQuery.addUpdate("salary", ExpressionMath.multiply((Expression)builder.get("salary"), (Object)new Integer(2)));
        UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
    }

    public static void testFirstNamePrefixBLADoubleSalaryForSalaryForFirstName() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression selectionExpression = builder.get("salary").lessThan(20000).and(builder.get("firstName").like("J%"));
        UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class, selectionExpression);
        updateQuery.addUpdate("firstName", Expression.fromLiteral((String)"'BLA'", null).concat((Object)builder.get("firstName")));
        updateQuery.addUpdate("salary", ExpressionMath.multiply((Expression)builder.get("salary"), (Object)new Integer(2)));
        UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
    }

    public static void testAssignManagerName() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression selectionExpression = builder.get("manager").notNull();
        UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class, selectionExpression);
        updateQuery.addUpdate("firstName", builder.get("manager").get("firstName"));
        UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
    }

    public static void testAssignNullToAddress() {
        UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class);
        updateQuery.addUpdate("address", null);
        UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
    }

    public static void testAssignObjectToAddress() {
        Address address = new Address();
        address.setCountry("Canada");
        address.setProvince("Ontario");
        address.setCity("Ottawa");
        address.setStreet("O'Connor");
        UnitOfWork uow = UpdateAllQueryAdvancedJunitTest.acquireUnitOfWork();
        uow.registerNewObject((Object)address);
        uow.commit();
        UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class);
        updateQuery.addUpdate("address", (Object)address);
        UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
    }

    public static void testAssignExpressionToAddress() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression selectionExpression = builder.get("manager").notNull();
        UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class, selectionExpression);
        updateQuery.addUpdate("address", builder.get("manager").get("address"));
        UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
    }

    public static void testAggregate() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression selectionExpression = builder.get("manager").notNull();
        UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class, selectionExpression);
        updateQuery.addUpdate(builder.get("period").get("startDate"), builder.get("period").get("endDate"));
        updateQuery.addUpdate(builder.get("period").get("endDate"), builder.get("period").get("startDate"));
        UpdateAllQueryAdvancedJunitTest.updateAllQueryInternal(updateQuery);
    }

    protected static void updateAllQueryInternal(Class referenceClass, HashMap updateClauses, Expression selectionExpression) {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession().getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.getServerSession().logMessage("UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        String errorMsg = UpdateAllQueryTestHelper.execute((Session)UpdateAllQueryAdvancedJunitTest.getDbSession(), (Class)referenceClass, (HashMap)updateClauses, (Expression)selectionExpression);
        if (errorMsg != null) {
            UpdateAllQueryAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    protected static void updateAllQueryInternal(UpdateAllQuery uq) {
        if (UpdateAllQueryAdvancedJunitTest.getServerSession().getPlatform().isSymfoware()) {
            UpdateAllQueryAdvancedJunitTest.getServerSession().logMessage("UpdateAllQueryAdvancedJunitTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        String errorMsg = UpdateAllQueryTestHelper.execute((Session)UpdateAllQueryAdvancedJunitTest.getDbSession(), (UpdateAllQuery)uq);
        if (errorMsg != null) {
            UpdateAllQueryAdvancedJunitTest.fail((String)errorMsg);
        }
    }

    protected static boolean compare() {
        for (int i = 0; i < classes.length; ++i) {
            if (UpdateAllQueryAdvancedJunitTest.compare(i)) continue;
            return false;
        }
        return true;
    }

    protected static boolean compare(int i) {
        if (objectVectors[i] == null) {
            return false;
        }
        Vector currentVector = UpdateAllQueryAdvancedJunitTest.getDbSession().readAllObjects(classes[i]);
        if (currentVector.size() != objectVectors[i].size()) {
            return false;
        }
        ClassDescriptor descriptor = UpdateAllQueryAdvancedJunitTest.getDbSession().getDescriptor(classes[i]);
        for (int j = 0; j < currentVector.size(); ++j) {
            Object obj1 = objectVectors[i].elementAt(j);
            Object obj2 = currentVector.elementAt(j);
            if (descriptor.getObjectBuilder().compareObjects(obj1, obj2, (AbstractSession)UpdateAllQueryAdvancedJunitTest.getDbSession())) continue;
            return false;
        }
        return true;
    }
}

