/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm.broadcast;

import org.eclipse.persistence.exceptions.ExceptionHandler;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.testing.framework.TestProblemException;

public class BroadcastEventLock {
    public static final int LOCKED_BY_SOURCE_LISTENER = -2;
    protected static final int minState = -2;
    public static final int LOCKED_DIRECTLY = -1;
    public static final int UNLOCKED_INITIAL = 0;
    public static final int UNLOCKED_DIRECTLY = 1;
    public static final int UNLOCKED_BY_TIMER = 2;
    public static final int UNLOCKED_BY_TARGET_LISTENER = 3;
    public static final int UNLOCKED_BY_SOURCE_EXCEPTION_HANDLER = 4;
    public static final int UNLOCKED_BY_SOURCE_SESSION = 5;
    protected static final int maxState = 5;
    protected static final int numberOfStates = 8;
    private int state;
    private boolean[] enabled;
    SourceListener sourceListener = new SourceListener();
    TargetListener targetListener = new TargetListener();
    SourceExceptionHandler sourceExceptionHandler = new SourceExceptionHandler();
    AbstractSession sourceSession;

    public BroadcastEventLock() {
        this.enabled = new boolean[8];
        this.enableAllStates();
    }

    public boolean isAttached() {
        return this.sourceSession != null;
    }

    public void attach(AbstractSession session, boolean isSource) {
        if (isSource) {
            this.attachSource(session);
        } else {
            this.attachTarget(session);
        }
    }

    public void detach(AbstractSession session) {
        if (session == this.sourceSession) {
            this.detachSource();
        } else {
            this.detachTarget(session);
        }
    }

    public void initialize() {
        this.state = 0;
    }

    public void waitUntilUnlocked(long timeToWaitBeforeVerify) throws InterruptedException {
        if (this.isLocked()) {
            long n = timeToWaitBeforeVerify / 100L;
            int i = 0;
            while ((long)i < n && this.isLocked()) {
                if (this.isStateEnabled(5) && this.sourceSession.getCommandManager().getTransportManager().getConnectionsToExternalServices().isEmpty()) {
                    this.unlock(5);
                }
                if (this.isLocked()) {
                    Thread.sleep(100L);
                }
                ++i;
            }
            if (this.isLocked()) {
                this.unlock(2);
            } else if (this.state == 3) {
                Thread.sleep(100L);
            }
        }
    }

    public void enableAllStates() {
        for (int i = 0; i < 8; ++i) {
            this.enabled[i] = true;
        }
    }

    protected int getStateIndex(int state) {
        return state - -2;
    }

    public boolean isStateEnabled(int state) {
        return this.enabled[this.getStateIndex(state)];
    }

    public void enableState(int state) {
        this.enabled[this.getStateIndex((int)state)] = true;
    }

    public void disableState(int state) {
        this.enabled[this.getStateIndex((int)state)] = false;
    }

    public int getState() {
        return this.state;
    }

    public boolean isLocked() {
        return BroadcastEventLock.isLockedState(this.state);
    }

    public void lock() {
        this.lock(-1);
    }

    public void unlock() {
        this.unlock(1);
    }

    protected void attachSource(AbstractSession session) {
        this.sourceListener.attach(session);
        this.sourceExceptionHandler.attach(session);
        this.sourceSession = session;
    }

    protected void attachTarget(AbstractSession session) {
        this.targetListener.attach(session);
    }

    protected void detachSource() {
        this.sourceListener.attach(this.sourceSession);
        this.sourceExceptionHandler.detach(this.sourceSession);
        this.sourceSession = null;
    }

    protected void detachTarget(AbstractSession session) {
        this.targetListener.detach(session);
    }

    protected static boolean isLockedState(int stateToExamine) {
        return stateToExamine < 0;
    }

    protected void verifyState(boolean isNewStateSupposedToBeLocked, int newState) {
        if (isNewStateSupposedToBeLocked != BroadcastEventLock.isLockedState(newState)) {
            throw new TestProblemException("Locked states should be negative; unlocked - non-negative");
        }
    }

    protected void lock(int newState) {
        this.verifyState(true, newState);
        this.changeState(newState);
    }

    protected void unlock(int newState) {
        this.verifyState(false, newState);
        this.changeState(newState);
    }

    protected void changeState(int newState) {
        if (this.isLocked() != BroadcastEventLock.isLockedState(newState) && this.isStateEnabled(newState)) {
            this.state = newState;
        }
    }

    class SourceExceptionHandler
    implements ExceptionHandler {
        ExceptionHandler originalHandler;

        SourceExceptionHandler() {
        }

        public void attach(AbstractSession session) {
            this.originalHandler = session.getExceptionHandler();
            session.setExceptionHandler((ExceptionHandler)this);
        }

        public void detach(AbstractSession session) {
            session.setExceptionHandler(this.originalHandler);
        }

        public Object handleException(RuntimeException exception) {
            if (exception instanceof RemoteCommandManagerException && ((RemoteCommandManagerException)((Object)exception)).getErrorCode() == 22105) {
                BroadcastEventLock.this.unlock(4);
            }
            if (this.originalHandler != null) {
                return this.originalHandler.handleException(exception);
            }
            throw exception;
        }
    }

    class TargetListener
    extends Listener {
        TargetListener() {
        }

        public void postDistributedMergeUnitOfWorkChangeSet(SessionEvent event) {
            BroadcastEventLock.this.unlock(3);
        }
    }

    class SourceListener
    extends Listener {
        SourceListener() {
        }

        public void postMergeUnitOfWorkChangeSet(SessionEvent event) {
            UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)event.getProperty("UnitOfWorkChangeSet");
            if (uowChangeSet.hasChanges()) {
                BroadcastEventLock.this.lock(-2);
            }
        }
    }

    class Listener
    extends SessionEventAdapter {
        Listener() {
        }

        public void attach(AbstractSession session) {
            session.getEventManager().addListener((SessionEventListener)this);
        }

        public void detach(AbstractSession session) {
            session.getEventManager().removeListener((SessionEventListener)this);
        }
    }
}

