/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class OptimisticLockingDeleteRowTest
extends AutoVerifyTestCase {
    protected Object originalObject;

    public OptimisticLockingDeleteRowTest() {
        this.setDescription("This test verifies that an optimistic lock exception is thrown when underlying database row is delete");
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void setup() {
        this.beginTransaction();
        Employee guy = new Employee();
        guy.setFirstName("guy");
        this.getDatabaseSession().writeObject((Object)guy);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.originalObject = this.getSession().readObject((Object)guy);
    }

    public void test() {
        this.getSession().executeNonSelectingCall((Call)new SQLCall("DELETE FROM SALARY WHERE EMP_ID = (Select EMP_ID from EMPLOYEE where F_NAME = 'guy')"));
        this.getSession().executeNonSelectingCall((Call)new SQLCall("DELETE FROM EMPLOYEE WHERE F_NAME = 'guy'"));
    }

    protected void verify() {
        boolean exceptionCaught = false;
        try {
            this.getDatabaseSession().deleteObject(this.originalObject);
        }
        catch (OptimisticLockException exception) {
            exceptionCaught = true;
        }
        if (!exceptionCaught) {
            throw new TestErrorException("No Optimistic Lock exception was thrown");
        }
    }
}

