/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;

public final class BeanValidationException
extends EclipseLinkException {
    public static final int PROVIDER_NOT_FOUND = 7500;
    public static final int ILLEGAL_VALIDATION_MODE = 7501;
    public static final int CONSTRAINT_VIOLATION = 7510;
    public static final int NOT_NULL_AND_NILLABLE = 7525;

    public BeanValidationException(String msg) {
        super(msg);
    }

    public BeanValidationException(String msg, Throwable internalException) {
        super(msg, internalException);
    }

    public static BeanValidationException constraintViolation(Object[] args, Throwable internalException) {
        BeanValidationException bve = new BeanValidationException(ExceptionMessageGenerator.buildMessage(BeanValidationException.class, 7510, args), internalException);
        bve.setErrorCode(7510);
        return bve;
    }

    public static BeanValidationException providerNotFound(String prefix, Throwable internalException) {
        BeanValidationException bve = new BeanValidationException(ExceptionMessageGenerator.buildMessage(BeanValidationException.class, 7500, new Object[]{prefix}), internalException);
        bve.setErrorCode(7500);
        return bve;
    }

    public static BeanValidationException illegalValidationMode(String prefix, String modeName) {
        BeanValidationException bve = new BeanValidationException(ExceptionMessageGenerator.buildMessage(BeanValidationException.class, 7501, new Object[]{prefix, modeName}));
        bve.setErrorCode(7501);
        return bve;
    }

    public static BeanValidationException notNullAndNillable(String propertyName) {
        BeanValidationException bve = new BeanValidationException(ExceptionMessageGenerator.buildMessage(BeanValidationException.class, 7525, new Object[]{propertyName}));
        bve.setErrorCode(7525);
        return bve;
    }
}

