/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.sql.Date;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;

public class NullAggregateTest
extends TransactionalTestCase {
    public Employee workingCopy;
    public Employee cloneCopy;
    public UnitOfWork unitOfWork;

    public NullAggregateTest() {
        this.setDescription("Test that the unit of work mergeClone still works when object identity is lost.");
    }

    public void reset() {
        super.reset();
    }

    public void setup() {
        super.setup();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.workingCopy = (Employee)this.getSession().readObject(Employee.class);
        this.cloneCopy = (Employee)this.unitOfWork.registerObject((Object)this.workingCopy);
        this.cloneCopy.setPeriod(null);
        this.unitOfWork.commit();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.cloneCopy = (Employee)this.unitOfWork.registerObject((Object)this.workingCopy);
    }

    public void test() {
        try {
            this.cloneCopy.setPeriod(new EmploymentPeriod(new Date(System.currentTimeMillis()), Helper.dateFromYearMonthDate((int)2001, (int)10, (int)15)));
            this.unitOfWork.commit();
        }
        catch (Exception exception) {
            throw new TestErrorException("Aggregate could not be assigned to an initially null field");
        }
    }

    public void verify() {
    }
}

