/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.transactionisolation;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class TransactionIsolationNoOriginalsTest
extends AutoVerifyTestCase {
    UnitOfWork unitOfWork;

    protected void setup() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
    }

    public void reset() throws Exception {
        if (this.unitOfWork != null) {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.unitOfWork.release();
            this.unitOfWork = null;
        }
    }

    public void test() {
        this.unitOfWork.beginEarlyTransaction();
        Employee employeeClone = (Employee)this.unitOfWork.readObject(Employee.class);
        this.strongAssert(employeeClone != null, "Executing reads in early transaction doesn't work.");
        ReadObjectQuery cacheQuery = new ReadObjectQuery(Employee.class);
        cacheQuery.checkCacheOnly();
        Employee employee = (Employee)this.getSession().executeQuery((DatabaseQuery)cacheQuery);
        this.strongAssert(employee == null, "There should be nothing in the shared cache.");
    }
}

