/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.ownership.ObjectA;
import org.eclipse.persistence.testing.models.ownership.ObjectB;

public class UnitOfWorkInitializeAllIdentityMapsTest
extends AutoVerifyTestCase {
    public static final String TEST_NAME = "UnitOfWorkInitializeAllIdentityMapsTest";
    public Exception storedException;

    public UnitOfWorkInitializeAllIdentityMapsTest() {
        this.setDescription("UnitOfWorkInitializeAllIdentityMapsTest checks the getIdentityMapAccessor().initializeAllIdentityMaps() method.");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void test() {
        try {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            ObjectA testObjectA = (ObjectA)uow.readObject(ObjectA.class);
            ObjectB testObjectB = (ObjectB)uow.readObject(ObjectB.class);
            String nameA = testObjectA.name;
            String nameB = testObjectB.name;
            uow.getIdentityMapAccessor().initializeAllIdentityMaps();
            ExpressionBuilder eb = new ExpressionBuilder();
            Expression expressionA = eb.get("name").equal((Object)nameA);
            Expression expressionB = eb.get("name").equal((Object)nameB);
            ReadObjectQuery queryA = new ReadObjectQuery(ObjectA.class);
            ReadObjectQuery queryB = new ReadObjectQuery(ObjectB.class);
            queryA.checkCacheOnly();
            queryA.setSelectionCriteria(expressionA);
            queryB.checkCacheOnly();
            queryB.setSelectionCriteria(expressionB);
            ObjectA returnObjectA = (ObjectA)uow.executeQuery((DatabaseQuery)queryA);
            ObjectB returnObjectB = (ObjectB)uow.executeQuery((DatabaseQuery)queryB);
            if (returnObjectA != null || returnObjectB != null) {
                this.setStoredException((Exception)((Object)new TestErrorException("Objects not removed from cache by uow.getIdentityMapAccessor().initializeAllIdentityMaps() : UnitOfWorkInitializeAllIdentityMapsTest")));
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStoredException((Exception)((Object)new TestErrorException("Error using UnitOfWork getIdentityMapAccessor().initializeAllIdentityMaps() : UnitOfWorkInitializeAllIdentityMapsTest")));
            return;
        }
    }

    protected void verify() throws Exception {
        if (this.storedException != null) {
            throw this.storedException;
        }
    }

    protected void setStoredException(Exception e) {
        if (this.storedException == null) {
            this.storedException = e;
        }
    }
}

