/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Vector;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;

public class InheritanceOuterJoinTest
extends PerformanceComparisonTestCase {
    protected Connection connection;
    protected PreparedStatement selectTypeStatement;
    protected PreparedStatement selectSmallProjectStatement;
    protected PreparedStatement selectLargeProjectStatement;
    protected PreparedStatement selectAllProjectStatement;

    public InheritanceOuterJoinTest() {
        this.setDescription("Compares the performance of multiple queries vs single outer join.");
        this.addOuterJoinTest();
    }

    public void setup() throws Exception {
        this.connection = (Connection)this.getAbstractSession().getAccessor().getDatasourceConnection();
        this.selectTypeStatement = this.connection.prepareStatement("Select PROJ_TYPE from PROJECT");
        this.selectSmallProjectStatement = this.connection.prepareStatement("Select * from PROJECT where PROJ_TYPE = 'S'");
        this.selectLargeProjectStatement = this.connection.prepareStatement("Select * from PROJECT P, LPROJECT L where ((PROJ_TYPE = 'L') and (L.PROJ_ID = P.PROJ_ID))");
        this.selectAllProjectStatement = this.connection.prepareStatement("Select * from PROJECT P, LPROJECT L where L.PROJ_ID (+) = P.PROJ_ID");
    }

    public void reset() throws Exception {
        this.selectTypeStatement.close();
        this.selectSmallProjectStatement.close();
        this.selectLargeProjectStatement.close();
        this.selectAllProjectStatement.close();
    }

    public void fetchRows(ResultSet result) throws Exception {
        int size = result.getMetaData().getColumnCount();
        Vector rows = new Vector();
        while (result.next()) {
            Vector<Object> row = new Vector<Object>(size);
            for (int column = 1; column <= size; ++column) {
                row.add(result.getObject(column));
            }
            rows.add(row);
        }
        result.close();
    }

    public void test() throws Exception {
        this.fetchRows(this.selectTypeStatement.executeQuery());
        this.fetchRows(this.selectSmallProjectStatement.executeQuery());
        this.fetchRows(this.selectLargeProjectStatement.executeQuery());
    }

    public void addOuterJoinTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() throws Exception {
                InheritanceOuterJoinTest.this.fetchRows(InheritanceOuterJoinTest.this.selectAllProjectStatement.executeQuery());
            }
        };
        test.setName("OuterJoinTest");
        test.setAllowableDecrease(10.0);
        this.addTest((TestCase)test);
    }
}

