/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.oxm.XMLRoot;

public class JAXBElementAttributeAccessor
extends AttributeAccessor {
    private AttributeAccessor nestedAccessor;
    private ContainerPolicy containerPolicy;
    private boolean isContainer;

    public JAXBElementAttributeAccessor(AttributeAccessor nestedAccessor) {
        this.nestedAccessor = nestedAccessor;
        this.isContainer = false;
    }

    public JAXBElementAttributeAccessor(AttributeAccessor nestedAccessor, ContainerPolicy containerPolicy) {
        this.nestedAccessor = nestedAccessor;
        this.containerPolicy = containerPolicy;
        this.isContainer = true;
    }

    public Object getAttributeValueFromObject(Object object) {
        Object value = this.nestedAccessor.getAttributeValueFromObject(object);
        if (this.isContainer) {
            Object results = this.containerPolicy.containerInstance(this.containerPolicy.sizeFor(value));
            Object iterator = this.containerPolicy.iteratorFor(value);
            while (this.containerPolicy.hasNext(iterator)) {
                Object next = this.containerPolicy.next(iterator, null);
                if (next instanceof JAXBElement) {
                    JAXBElement element = (JAXBElement)next;
                    XMLRoot root = new XMLRoot();
                    root.setLocalName(element.getName().getLocalPart());
                    root.setNamespaceURI(element.getName().getNamespaceURI());
                    root.setObject(element.getValue());
                    this.containerPolicy.addInto((Object)root, results, null);
                    continue;
                }
                this.containerPolicy.addInto(next, results, null);
            }
            value = results;
        } else if (value instanceof JAXBElement) {
            JAXBElement element = (JAXBElement)value;
            XMLRoot root = new XMLRoot();
            root.setLocalName(element.getName().getLocalPart());
            root.setNamespaceURI(element.getName().getNamespaceURI());
            root.setObject(element.getValue());
            value = root;
        }
        return value;
    }

    public void setAttributeValueInObject(Object object, Object value) {
        Object attributeValue = value;
        if (this.isContainer) {
            Object results = this.containerPolicy.containerInstance(this.containerPolicy.sizeFor(attributeValue));
            Object iterator = this.containerPolicy.iteratorFor(attributeValue);
            while (this.containerPolicy.hasNext(iterator)) {
                Object next = this.containerPolicy.next(iterator, null);
                if (next instanceof XMLRoot) {
                    XMLRoot root = (XMLRoot)next;
                    QName name = new QName(root.getNamespaceURI(), root.getLocalName());
                    JAXBElement element = new JAXBElement(name, root.getObject().getClass(), root.getObject());
                    this.containerPolicy.addInto((Object)element, results, null);
                    continue;
                }
                this.containerPolicy.addInto(next, results, null);
            }
            attributeValue = results;
        } else if (attributeValue instanceof XMLRoot) {
            XMLRoot root = (XMLRoot)attributeValue;
            QName name = new QName(root.getNamespaceURI(), root.getLocalName());
            JAXBElement element = new JAXBElement(name, root.getObject().getClass(), root.getObject());
            attributeValue = element;
        }
        this.nestedAccessor.setAttributeValueInObject(object, attributeValue);
    }

    public void initializeAttributes(Class theJavaClass) throws DescriptorException {
        this.nestedAccessor.initializeAttributes(theJavaClass);
    }
}

