/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;

public class Persistence {
    protected static Set<PersistenceProvider> providers = new HashSet<PersistenceProvider>();
    protected static ProviderResolver providerResolver = new DefaultProviderResolver();

    public static ProviderResolver getProviderResolver() {
        return providerResolver;
    }

    public static void setProviderResolver(ProviderResolver providerResolver) {
        Persistence.providerResolver = providerResolver;
    }

    public static EntityManagerFactory createEntityManagerFactory(String string) {
        return Persistence.createEntityManagerFactory(string, null);
    }

    public static EntityManagerFactory createEntityManagerFactory(String string, Map map) {
        PersistenceProvider persistenceProvider;
        EntityManagerFactory entityManagerFactory = null;
        if (providers.size() == 0) {
            try {
                providers.addAll(providerResolver.findAllProviders());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Iterator<PersistenceProvider> iterator = providers.iterator();
        while (iterator.hasNext() && (entityManagerFactory = (persistenceProvider = iterator.next()).createEntityManagerFactory(string, map)) == null) {
        }
        if (entityManagerFactory == null) {
            throw new PersistenceException("No Persistence provider for EntityManager named " + string);
        }
        return entityManagerFactory;
    }

    public static void addProvider(PersistenceProvider persistenceProvider) {
        providers.add(persistenceProvider);
    }

    public static void removeProvider(String string) {
        Iterator<PersistenceProvider> iterator = providers.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getClass().getName().equals(string)) continue;
            iterator.remove();
        }
    }

    public static void resetProviders() {
        providers = new HashSet<PersistenceProvider>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultProviderResolver
    implements ProviderResolver {
        public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PersistenceProvider";
        public static final String SERVICE_PROVIDER_FILE = "META-INF/services/javax.persistence.spi.PersistenceProvider";
        private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<PersistenceProvider> findAllProviders() throws IOException {
            Serializable serializable;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> enumeration = classLoader.getResources(SERVICE_PROVIDER_FILE);
            HashSet<String> hashSet = new HashSet<String>();
            while (enumeration.hasMoreElements()) {
                serializable = enumeration.nextElement();
                InputStream inputStream = ((URL)serializable).openStream();
                try {
                    hashSet.addAll(this.providerNamesFromReader(new BufferedReader(new InputStreamReader(inputStream))));
                }
                finally {
                    inputStream.close();
                }
            }
            serializable = new HashSet();
            for (String string : hashSet) {
                try {
                    serializable.add((PersistenceProvider)classLoader.loadClass(string).newInstance());
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            return serializable;
        }

        private Set<String> providerNamesFromReader(BufferedReader bufferedReader) throws IOException {
            String string;
            HashSet<String> hashSet = new HashSet<String>();
            while ((string = bufferedReader.readLine()) != null) {
                Matcher matcher = nonCommentPattern.matcher(string = string.trim());
                if (!matcher.find()) continue;
                hashSet.add(matcher.group().trim());
            }
            return hashSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ProviderResolver {
        public Collection<PersistenceProvider> findAllProviders() throws IOException;
    }
}

