/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetField;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedSetValueInField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

public class CMP3Policy
extends CMPPolicy {
    protected CMPPolicy.KeyElementAccessor[] keyClassFields;
    protected DatabaseMapping[] keyMappings;
    protected String pkClassName;
    protected Class pkClass;

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.getPKClassName() != null) {
            try {
                Class pkClass = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        pkClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getPKClassName(), true, classLoader));
                    }
                    catch (PrivilegedActionException exception) {
                        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"pk_class_not_found", (Object[])new Object[]{this.pkClassName}), exception.getException());
                    }
                } else {
                    pkClass = PrivilegedAccessHelper.getClassForName((String)this.getPKClassName(), (boolean)true, (ClassLoader)classLoader);
                }
                this.setPKClass(pkClass);
            }
            catch (ClassNotFoundException exc) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"pk_class_not_found", (Object[])new Object[]{this.pkClassName}), exc);
            }
        }
    }

    public boolean isCMP3Policy() {
        return true;
    }

    public void setPrimaryKeyClassName(String pkClassName) {
        this.pkClassName = pkClassName;
    }

    public Class getPKClass() {
        if (this.pkClass == null && this.getPKClassName() == null) {
            this.initializePrimaryKeyFields(null);
        }
        return this.pkClass;
    }

    public void setPKClass(Class pkClass) {
        this.pkClass = pkClass;
    }

    public String getPKClassName() {
        return this.pkClassName;
    }

    public Object getPKClassInstance() {
        try {
            return this.getPKClass().newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Vector createPkVectorFromKey(Object key, AbstractSession session) {
        CMPPolicy.KeyElementAccessor[] pkElementArray = this.getKeyClassFields(key.getClass());
        NonSynchronizedVector pkVector = new NonSynchronizedVector(pkElementArray.length);
        for (int index = 0; index < pkElementArray.length; ++index) {
            DatabaseMapping mapping = this.keyMappings[index];
            Object fieldValue = null;
            fieldValue = mapping.isDirectToFieldMapping() ? ((AbstractDirectMapping)mapping).getFieldValue(pkElementArray[index].getValue(key), session) : pkElementArray[index].getValue(key);
            pkVector.add(fieldValue);
        }
        return pkVector;
    }

    public Object createBeanUsingKey(Object key, AbstractSession session) {
        try {
            Object bean = this.getDescriptor().getInstantiationPolicy().buildNewInstance();
            CMPPolicy.KeyElementAccessor[] keyElements = this.getKeyClassFields(key.getClass());
            for (int index = 0; index < keyElements.length; ++index) {
                Object toWriteInto = bean;
                Object keyFieldValue = keyElements[index].getValue(key);
                DatabaseField field = keyElements[index].getDatabaseField();
                DatabaseMapping mapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(keyElements[index].getAttributeName());
                if (mapping == null) {
                    mapping = this.getDescriptor().getObjectBuilder().getMappingForField(field);
                }
                while (mapping.isAggregateObjectMapping()) {
                    Object aggregate = mapping.getRealAttributeValueFromObject(toWriteInto, session);
                    if (aggregate == null) {
                        aggregate = mapping.getReferenceDescriptor().getJavaClass().newInstance();
                        mapping.setRealAttributeValueInObject(toWriteInto, aggregate);
                    }
                    if ((mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(keyElements[index].getAttributeName())) == null) {
                        mapping = this.getDescriptor().getObjectBuilder().getMappingForField(field);
                    }
                    toWriteInto = aggregate;
                }
                mapping.setRealAttributeValueInObject(toWriteInto, keyFieldValue);
            }
            return bean;
        }
        catch (Exception e) {
            throw DescriptorException.errorUsingPrimaryKey((Object)key, (ClassDescriptor)this.getDescriptor(), (Exception)e);
        }
    }

    protected CMPPolicy.KeyElementAccessor[] initializePrimaryKeyFields(Class keyClass) {
        CMPPolicy.KeyElementAccessor[] pkAttributes = null;
        ClassDescriptor descriptor = this.getDescriptor();
        pkAttributes = new CMPPolicy.KeyElementAccessor[descriptor.getObjectBuilder().getPrimaryKeyMappings().size()];
        Iterator attributesIter = descriptor.getPrimaryKeyFields().iterator();
        int i = 0;
        while (attributesIter.hasNext()) {
            DatabaseField field = (DatabaseField)attributesIter.next();
            Vector<DatabaseMapping> allMappings = descriptor.getObjectBuilder().getReadOnlyMappingsForField(field);
            if (allMappings == null) {
                allMappings = new Vector<DatabaseMapping>(1);
            }
            allMappings.add(descriptor.getObjectBuilder().getMappingForField(field));
            NoSuchMethodException elementIsFound = null;
            for (int index = allMappings.size() - 1; index >= 0; --index) {
                block22: {
                    DatabaseMapping mapping = (DatabaseMapping)allMappings.get(index);
                    if (mapping.isForeignReferenceMapping()) continue;
                    if (mapping.isAggregateMapping()) {
                        DatabaseMapping writableMapping;
                        ObjectBuilder builder = mapping.getReferenceDescriptor().getObjectBuilder();
                        List aggregateMappings = builder.getReadOnlyMappingsForField(field);
                        if (aggregateMappings != null && !aggregateMappings.isEmpty()) {
                            allMappings.addAll(aggregateMappings);
                        }
                        if ((writableMapping = builder.getMappingForField(field)) != null) {
                            allMappings.add(writableMapping);
                        }
                        allMappings.remove(mapping);
                        index = allMappings.size();
                        continue;
                    }
                    String fieldName = mapping.getAttributeName();
                    if (keyClass == null) {
                        pkAttributes[i] = new CMPPolicy.KeyIsElementAccessor((CMPPolicy)this, mapping.getAttributeName(), field);
                        this.setPKClass(ConversionManager.getObjectClass((Class)mapping.getAttributeClassification()));
                        elementIsFound = null;
                    } else {
                        try {
                            Field keyField = null;
                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                try {
                                    keyField = (Field)AccessController.doPrivileged(new PrivilegedGetField(keyClass, fieldName, true));
                                }
                                catch (PrivilegedActionException exception) {
                                    throw (NoSuchFieldException)exception.getException();
                                }
                            } else {
                                keyField = PrivilegedAccessHelper.getField((Class)keyClass, (String)fieldName, (boolean)true);
                            }
                            pkAttributes[i] = new FieldAccessor(keyField, fieldName, field);
                            elementIsFound = null;
                        }
                        catch (NoSuchFieldException ex) {
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("get");
                            buffer.append(fieldName.substring(0, 1).toUpperCase());
                            buffer.append(fieldName.substring(1));
                            try {
                                Method method = null;
                                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                    try {
                                        method = (Method)AccessController.doPrivileged(new PrivilegedGetMethod(keyClass, buffer.toString(), new Class[0], true));
                                    }
                                    catch (PrivilegedActionException exception) {
                                        throw (NoSuchMethodException)exception.getException();
                                    }
                                } else {
                                    method = PrivilegedAccessHelper.getMethod((Class)keyClass, (String)buffer.toString(), (Class[])new Class[0], (boolean)true);
                                }
                                pkAttributes[i] = new PropertyAccessor(method, fieldName, field);
                                elementIsFound = null;
                            }
                            catch (NoSuchMethodException exs) {
                                if (descriptor.getObjectBuilder().getPrimaryKeyMappings().size() == 1) {
                                    pkAttributes[i] = new CMPPolicy.KeyIsElementAccessor((CMPPolicy)this, mapping.getAttributeName(), field);
                                    this.setPKClass(ConversionManager.getObjectClass((Class)mapping.getAttributeClassification()));
                                    elementIsFound = null;
                                    break block22;
                                }
                                elementIsFound = exs;
                            }
                        }
                    }
                }
                if (elementIsFound == null) break;
            }
            if (elementIsFound != null) {
                throw DescriptorException.errorUsingPrimaryKey((Object)keyClass, (ClassDescriptor)this.getDescriptor(), elementIsFound);
            }
            ++i;
        }
        return pkAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CMPPolicy.KeyElementAccessor[] getKeyClassFields(Class clazz) {
        if (this.keyClassFields == null) {
            CMP3Policy cMP3Policy = this;
            synchronized (cMP3Policy) {
                if (this.keyClassFields == null) {
                    CMPPolicy.KeyElementAccessor[] tmpKeyClassFields = this.initializePrimaryKeyFields(this.pkClass == null ? clazz : this.pkClass);
                    int size = tmpKeyClassFields.length;
                    DatabaseMapping[] mappings = new DatabaseMapping[size];
                    for (int index = 0; index < size; ++index) {
                        CMPPolicy.KeyElementAccessor accessor = tmpKeyClassFields[index];
                        DatabaseMapping mapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(accessor.getAttributeName());
                        if (mapping == null) {
                            mapping = this.getDescriptor().getObjectBuilder().getMappingForField(accessor.getDatabaseField());
                        }
                        while (mapping.isAggregateObjectMapping()) {
                            DatabaseMapping nestedMapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(accessor.getAttributeName());
                            if (nestedMapping == null) {
                                nestedMapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(accessor.getDatabaseField());
                            }
                            mapping = nestedMapping;
                        }
                        mappings[index] = mapping;
                    }
                    this.keyMappings = mappings;
                    this.keyClassFields = tmpKeyClassFields;
                }
            }
        }
        return this.keyClassFields;
    }

    private class FieldAccessor
    implements CMPPolicy.KeyElementAccessor {
        protected Field field;
        protected String attributeName;
        protected DatabaseField databaseField;

        public FieldAccessor(Field field, String attributeName, DatabaseField databaseField) {
            this.field = field;
            this.attributeName = attributeName;
            this.databaseField = databaseField;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public Object getValue(Object object) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedGetValueFromField(this.field, object));
                    }
                    catch (PrivilegedActionException exception) {
                        throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)exception.getException());
                    }
                }
                return PrivilegedAccessHelper.getValueFromField((Field)this.field, (Object)object);
            }
            catch (Exception ex) {
                throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)ex);
            }
        }

        public void setValue(Object object, Object value) {
            block5: {
                try {
                    Field pkField = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            pkField = (Field)AccessController.doPrivileged(new PrivilegedGetField(object.getClass(), this.field.getName(), true));
                            AccessController.doPrivileged(new PrivilegedSetValueInField(pkField, object, value));
                            break block5;
                        }
                        catch (PrivilegedActionException exception) {
                            throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)exception.getException());
                        }
                    }
                    pkField = PrivilegedAccessHelper.getField(object.getClass(), (String)this.field.getName(), (boolean)true);
                    PrivilegedAccessHelper.setValueInField((Field)pkField, (Object)object, (Object)value);
                }
                catch (Exception ex) {
                    throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)ex);
                }
            }
        }
    }

    private class PropertyAccessor
    implements CMPPolicy.KeyElementAccessor {
        protected Method method;
        protected String attributeName;
        protected DatabaseField databaseField;

        public PropertyAccessor(Method method, String attributeName, DatabaseField field) {
            this.method = method;
            this.attributeName = attributeName;
            this.databaseField = field;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public Object getValue(Object object) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.method, object, new Object[0]));
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw (IllegalAccessException)throwableException;
                        }
                        throw (InvocationTargetException)throwableException;
                    }
                }
                return PrivilegedAccessHelper.invokeMethod((Method)this.method, (Object)object, (Object[])new Object[0]);
            }
            catch (Exception ex) {
                throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)ex);
            }
        }

        public void setValue(Object object, Object value) {
            block6: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(new MetadataMethod(this.method, object.getClass()).getSetMethod(), object, new Object[]{value}));
                            break block6;
                        }
                        catch (PrivilegedActionException exception) {
                            Exception throwableException = exception.getException();
                            if (throwableException instanceof IllegalAccessException) {
                                throw (IllegalAccessException)throwableException;
                            }
                            throw (InvocationTargetException)throwableException;
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod((Method)new MetadataMethod(this.method, object.getClass()).getSetMethod(), (Object)object, (Object[])new Object[]{value});
                }
                catch (Exception ex) {
                    throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)CMP3Policy.this.getDescriptor(), (Exception)ex);
                }
            }
        }
    }
}

