/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

public class OneToOneAccessor
extends ObjectAccessor {
    private String m_mappedBy;

    public OneToOneAccessor() {
        super("<one-to-one>");
    }

    public OneToOneAccessor(Annotation oneToOne, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(oneToOne, accessibleObject, classAccessor);
        this.m_mappedBy = oneToOne == null ? "" : (String)MetadataHelper.invokeMethod("mappedBy", oneToOne);
    }

    protected String getLoggingContext() {
        return "metadata_default_one_to_one_reference_class";
    }

    public String getMappedBy() {
        return this.m_mappedBy;
    }

    public boolean isOneToOne() {
        return true;
    }

    public void process() {
        OneToOneMapping mapping = this.initOneToOneMapping();
        if (this.m_mappedBy == null || this.m_mappedBy.equals("")) {
            this.processOwningMappingKeys(mapping);
        } else {
            HashMap<DatabaseField, DatabaseField> sourceToTargetKeyFields;
            HashMap<DatabaseField, DatabaseField> targetToSourceKeyFields;
            OneToOneMapping ownerMapping = null;
            if (!this.getOwningMapping(this.m_mappedBy).isOneToOneMapping()) {
                throw ValidationException.invalidMapping((Class)this.getJavaClass(), (Class)this.getReferenceClass());
            }
            ownerMapping = (OneToOneMapping)this.getOwningMapping(this.m_mappedBy);
            if (this.getDescriptor().usesTablePerClassInheritanceStrategy()) {
                targetToSourceKeyFields = new HashMap<DatabaseField, DatabaseField>();
                sourceToTargetKeyFields = new HashMap<DatabaseField, DatabaseField>();
                for (DatabaseField fkField : ownerMapping.getSourceToTargetKeyFields().keySet()) {
                    DatabaseField pkField = (DatabaseField)((DatabaseField)ownerMapping.getSourceToTargetKeyFields().get(fkField)).clone();
                    pkField.setTable(this.getDescriptor().getPrimaryTable());
                    sourceToTargetKeyFields.put(fkField, pkField);
                    targetToSourceKeyFields.put(pkField, fkField);
                }
            } else {
                targetToSourceKeyFields = ownerMapping.getTargetToSourceKeyFields();
                sourceToTargetKeyFields = ownerMapping.getSourceToTargetKeyFields();
            }
            mapping.setSourceToTargetKeyFields(targetToSourceKeyFields);
            mapping.setTargetToSourceKeyFields(sourceToTargetKeyFields);
        }
        this.processProperties((DatabaseMapping)mapping);
        this.getDescriptor().addMapping((DatabaseMapping)mapping);
    }

    public void setMappedBy(String mappedBy) {
        this.m_mappedBy = mappedBy;
    }
}

