/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.cache;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.cache.MetadataHelper;

public class TimeOfDayMetadata
extends ORMetadata {
    private Integer m_hour;
    private Integer m_millisecond;
    private Integer m_minute;
    private Integer m_second;

    public TimeOfDayMetadata() {
        super("<time-of-day>");
    }

    public TimeOfDayMetadata(Annotation timeOfDay, MetadataAccessibleObject accessibleObject) {
        super(timeOfDay, accessibleObject);
        this.m_hour = (Integer)MetadataHelper.invokeMethod("hour", timeOfDay);
        this.m_millisecond = (Integer)MetadataHelper.invokeMethod("millisecond", timeOfDay);
        this.m_minute = (Integer)MetadataHelper.invokeMethod("minute", timeOfDay);
        this.m_second = (Integer)MetadataHelper.invokeMethod("second", timeOfDay);
    }

    public Integer getHour() {
        return this.m_hour;
    }

    public Integer getMillisecond() {
        return this.m_millisecond;
    }

    public Integer getMinute() {
        return this.m_minute;
    }

    public Integer getSecond() {
        return this.m_second;
    }

    public Integer processHour() {
        return this.m_hour == null ? 0 : this.m_hour;
    }

    public Integer processMillisecond() {
        return this.m_millisecond == null ? 0 : this.m_millisecond;
    }

    public Integer processMinute() {
        return this.m_minute == null ? 0 : this.m_minute;
    }

    public Integer processSecond() {
        return this.m_second == null ? 0 : this.m_second;
    }

    public void setHour(Integer hour) {
        this.m_hour = hour;
    }

    public void setMillisecond(Integer millisecond) {
        this.m_millisecond = millisecond;
    }

    public void setMinute(Integer minute) {
        this.m_minute = minute;
    }

    public void setSecond(Integer second) {
        this.m_second = second;
    }
}

