/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ConcurrentFixedCache;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class DescriptorQueryManager
implements Cloneable,
Serializable {
    protected transient InsertObjectQuery insertQuery;
    protected transient UpdateObjectQuery updateQuery;
    protected transient ReadObjectQuery readObjectQuery;
    protected transient ReadAllQuery readAllQuery;
    protected transient DeleteObjectQuery deleteQuery;
    protected DoesExistQuery doesExistQuery;
    protected ClassDescriptor descriptor;
    protected boolean hasCustomMultipleTableJoinExpression;
    protected transient Expression additionalJoinExpression;
    protected transient Expression multipleTableJoinExpression;
    protected transient Map queries = new LinkedHashMap(5);
    protected transient Map tablesJoinExpressions;
    protected transient ConcurrentFixedCache cachedUpdateCalls = new ConcurrentFixedCache(10);
    protected transient ConcurrentFixedCache cachedExpressionQueries = new ConcurrentFixedCache(20);
    public static final int NoTimeout = 0;
    public static final int DefaultTimeout = -1;
    protected int queryTimeout;

    public DescriptorQueryManager() {
        this.setDoesExistQuery(new DoesExistQuery());
        this.setQueryTimeout(-1);
    }

    public void setExpressionQueryCacheMaxSize(int n) {
        this.cachedExpressionQueries = new ConcurrentFixedCache(n);
    }

    public int getExpressionQueryCacheMaxSize() {
        return this.cachedExpressionQueries.getMaxSize();
    }

    public void addQuery(String string, DatabaseQuery databaseQuery) {
        databaseQuery.setName(string);
        this.addQuery(databaseQuery);
    }

    public synchronized void addQuery(DatabaseQuery databaseQuery) {
        Vector vector;
        if (databaseQuery instanceof ObjectLevelReadQuery && ((ObjectLevelReadQuery)databaseQuery).getReferenceClassName() == null) {
            ((ObjectLevelReadQuery)databaseQuery).setReferenceClassName(this.getDescriptor().getJavaClassName());
            try {
                ((ObjectLevelReadQuery)databaseQuery).setReferenceClass(this.getDescriptor().getJavaClass());
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
            databaseQuery.setDescriptor(this.getDescriptor());
        }
        if ((vector = (Vector)this.getQueries().get(databaseQuery.getName())) == null) {
            vector = NonSynchronizedVector.newInstance();
            this.getQueries().put(databaseQuery.getName(), vector);
        } else {
            int n;
            int n2 = 0;
            if (databaseQuery.getArguments() != null) {
                n2 = databaseQuery.getArguments().size();
            }
            NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(n2);
            for (n = 0; n < n2; ++n) {
                ((Vector)nonSynchronizedVector).addElement(databaseQuery.getArgumentTypeNames().elementAt(n));
            }
            for (n = 0; n < vector.size(); ++n) {
                DatabaseQuery databaseQuery2 = (DatabaseQuery)vector.elementAt(n);
                if (!((Vector)nonSynchronizedVector).equals(databaseQuery2.getArgumentTypeNames())) continue;
                vector.remove(n);
                vector.add(n, databaseQuery);
                return;
            }
        }
        vector.add(databaseQuery);
    }

    public void assumeExistenceForDoesExist() {
        this.getDoesExistQuery().assumeExistenceForDoesExist();
    }

    public void assumeNonExistenceForDoesExist() {
        this.getDoesExistQuery().assumeNonExistenceForDoesExist();
    }

    public void checkCacheForDoesExist() {
        this.getDoesExistQuery().checkCacheForDoesExist();
    }

    public void checkDatabaseForDoesExist() {
        this.getDoesExistQuery().checkDatabaseForDoesExist();
    }

    public Object clone() {
        DescriptorQueryManager descriptorQueryManager = null;
        try {
            descriptorQueryManager = (DescriptorQueryManager)super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        descriptorQueryManager.setQueries(new LinkedHashMap(this.getQueries().size()));
        Iterator iterator = this.queries.values().iterator();
        while (iterator.hasNext()) {
            for (DatabaseQuery databaseQuery : (Vector)iterator.next()) {
                DatabaseQuery databaseQuery2 = (DatabaseQuery)databaseQuery.clone();
                databaseQuery2.setDescriptor(descriptorQueryManager.getDescriptor());
                descriptorQueryManager.addQuery(databaseQuery2);
            }
        }
        descriptorQueryManager.setDoesExistQuery((DoesExistQuery)this.getDoesExistQuery().clone());
        if (this.getReadAllQuery() != null) {
            descriptorQueryManager.setReadAllQuery((ReadAllQuery)this.getReadAllQuery().clone());
        }
        if (this.getReadObjectQuery() != null) {
            descriptorQueryManager.setReadObjectQuery((ReadObjectQuery)this.getReadObjectQuery().clone());
        }
        if (this.getUpdateQuery() != null) {
            descriptorQueryManager.setUpdateQuery((UpdateObjectQuery)this.getUpdateQuery().clone());
        }
        if (this.getInsertQuery() != null) {
            descriptorQueryManager.setInsertQuery((InsertObjectQuery)this.getInsertQuery().clone());
        }
        if (this.getDeleteQuery() != null) {
            descriptorQueryManager.setDeleteQuery((DeleteObjectQuery)this.getDeleteQuery().clone());
        }
        return descriptorQueryManager;
    }

    public boolean containsQuery(String string) {
        return this.queries.containsKey(string);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Iterator iterator = this.getQueries().values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((Vector)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                ((DatabaseQuery)iterator2.next()).convertClassNamesToClasses(classLoader);
            }
        }
        if (this.getReadObjectQuery() != null) {
            this.getReadObjectQuery().convertClassNamesToClasses(classLoader);
        }
        if (this.getReadAllQuery() != null) {
            this.getReadAllQuery().convertClassNamesToClasses(classLoader);
        }
    }

    public Expression getAdditionalJoinExpression() {
        return this.additionalJoinExpression;
    }

    public DeleteObjectQuery getDeleteQuery() {
        return this.deleteQuery;
    }

    public String getDeleteSQLString() {
        if (this.getDeleteQuery() == null) {
            return null;
        }
        return this.getDeleteQuery().getSQLString();
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public DoesExistQuery getDoesExistQuery() {
        return this.doesExistQuery;
    }

    public String getDoesExistSQLString() {
        if (this.getDoesExistQuery() == null) {
            return null;
        }
        return this.getDoesExistQuery().getSQLString();
    }

    public String getExistenceCheck() {
        if (this.getDoesExistQuery().shouldAssumeExistenceForDoesExist()) {
            return "Assume existence";
        }
        if (this.getDoesExistQuery().shouldAssumeNonExistenceForDoesExist()) {
            return "Assume non-existence";
        }
        if (this.getDoesExistQuery().shouldCheckCacheForDoesExist()) {
            return "Check cache";
        }
        if (this.getDoesExistQuery().shouldCheckDatabaseForDoesExist()) {
            return "Check database";
        }
        return "Check cache";
    }

    public InsertObjectQuery getInsertQuery() {
        return this.insertQuery;
    }

    public String getInsertSQLString() {
        if (this.getInsertQuery() == null) {
            return null;
        }
        return this.getInsertQuery().getSQLString();
    }

    public Expression getMultipleTableJoinExpression() {
        return this.multipleTableJoinExpression;
    }

    public Map getQueries() {
        return this.queries;
    }

    public Vector getAllQueries() {
        Vector vector = new Vector();
        Iterator iterator = this.getQueries().values().iterator();
        while (iterator.hasNext()) {
            vector.addAll((Vector)iterator.next());
        }
        return vector;
    }

    public void setAllQueries(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addQuery((DatabaseQuery)enumeration.nextElement());
        }
    }

    public void setQueries(Map map) {
        this.queries = map;
    }

    public DatabaseQuery getQuery(String string) {
        return this.getQuery(string, null);
    }

    public DatabaseQuery getQuery(String string, Vector vector) {
        DatabaseQuery databaseQuery = this.getLocalQuery(string, vector);
        if (databaseQuery == null) {
            DatabaseQuery databaseQuery2 = this.getQueryFromParent(string, vector);
            if (databaseQuery2 != null && databaseQuery2.isReadQuery()) {
                databaseQuery2 = (DatabaseQuery)databaseQuery2.clone();
                ((ObjectLevelReadQuery)databaseQuery2).setReferenceClass(this.descriptor.getJavaClass());
                this.addQuery(string, databaseQuery2);
            }
            return databaseQuery2;
        }
        return databaseQuery;
    }

    public DatabaseQuery getLocalQuery(String string, Vector vector) {
        Vector vector2 = (Vector)this.getQueries().get(string);
        if (vector2 == null) {
            return null;
        }
        if (vector2.size() == 1) {
            return (DatabaseQuery)vector2.firstElement();
        }
        int n = 0;
        if (vector != null) {
            n = vector.size();
        }
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(n);
        for (int i = 0; i < n; ++i) {
            ((Vector)nonSynchronizedVector).addElement(vector.elementAt(i).getClass());
        }
        return this.getLocalQueryByArgumentTypes(string, nonSynchronizedVector);
    }

    public DatabaseQuery getLocalQueryByArgumentTypes(String string, List list) {
        List list2 = (List)this.getQueries().get(string);
        if (list2 == null) {
            return null;
        }
        if (list2.size() == 1) {
            return (DatabaseQuery)list2.get(0);
        }
        for (DatabaseQuery databaseQuery : list2) {
            if (!Helper.areTypesAssignable(databaseQuery.getArgumentTypes(), list)) continue;
            return databaseQuery;
        }
        return null;
    }

    protected DatabaseQuery getQueryFromParent(String string, Vector vector) {
        InheritancePolicy inheritancePolicy;
        ClassDescriptor classDescriptor;
        ClassDescriptor classDescriptor2 = this.descriptor;
        if (classDescriptor2.hasInheritance() && (classDescriptor = (inheritancePolicy = classDescriptor2.getInheritancePolicy()).getParentDescriptor()) != null) {
            return classDescriptor.getQueryManager().getQuery(string, vector);
        }
        return null;
    }

    public ReadAllQuery getReadAllQuery() {
        return this.readAllQuery;
    }

    public String getReadAllSQLString() {
        if (this.getReadAllQuery() == null) {
            return null;
        }
        return this.getReadAllQuery().getSQLString();
    }

    public ReadObjectQuery getReadObjectQuery() {
        return this.readObjectQuery;
    }

    public String getReadObjectSQLString() {
        if (this.getReadObjectQuery() == null) {
            return null;
        }
        return this.getReadObjectQuery().getSQLString();
    }

    public UpdateObjectQuery getUpdateQuery() {
        return this.updateQuery;
    }

    public String getUpdateSQLString() {
        if (this.getUpdateQuery() == null) {
            return null;
        }
        return this.getUpdateQuery().getSQLString();
    }

    public boolean hasCustomMultipleTableJoinExpression() {
        return this.hasCustomMultipleTableJoinExpression;
    }

    public boolean hasDeleteQuery() {
        return this.deleteQuery != null;
    }

    public boolean hasDoesExistQuery() {
        return this.doesExistQuery != null;
    }

    public boolean hasInsertQuery() {
        return this.insertQuery != null;
    }

    public boolean hasReadAllQuery() {
        return this.readAllQuery != null;
    }

    public boolean hasReadObjectQuery() {
        return this.readObjectQuery != null;
    }

    public boolean hasUpdateQuery() {
        return this.updateQuery != null;
    }

    private void populateQueries() {
        if (this.getInsertQuery() != null) {
            this.getInsertQuery().setDescriptor(this.descriptor);
        }
        if (this.getUpdateQuery() != null) {
            this.getUpdateQuery().setDescriptor(this.descriptor);
        }
        if (this.getReadObjectQuery() != null) {
            this.getReadObjectQuery().setReferenceClass(this.getDescriptor().getJavaClass());
            this.getReadObjectQuery().setDescriptor(this.descriptor);
        }
        if (this.getDeleteQuery() != null) {
            this.getDeleteQuery().setDescriptor(this.descriptor);
        }
        if (this.getReadAllQuery() != null) {
            this.getReadAllQuery().setReferenceClass(this.getDescriptor().getJavaClass());
            this.getReadAllQuery().setDescriptor(this.descriptor);
        }
        Iterator iterator = this.getAllQueries().iterator();
        while (iterator.hasNext()) {
            ((DatabaseQuery)iterator.next()).setDescriptor(this.descriptor);
        }
    }

    public void initialize(AbstractSession abstractSession) {
        this.initializeQueryTimeout(abstractSession);
        if (this.getDescriptor().isAggregateDescriptor()) {
            return;
        }
        if (this.getMultipleTableJoinExpression() != null) {
            this.setAdditionalJoinExpression(this.getMultipleTableJoinExpression().and(this.getAdditionalJoinExpression()));
        }
        if (this.getDescriptor().isAggregateCollectionDescriptor()) {
            return;
        }
        if (!this.hasReadObjectQuery()) {
            ReadObjectQuery readObjectQuery = new ReadObjectQuery();
            readObjectQuery.setSelectionCriteria(this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression());
            this.setReadObjectQuery(readObjectQuery);
        }
        if (!this.hasInsertQuery()) {
            this.setInsertQuery(new InsertObjectQuery());
        }
        this.getInsertQuery().setModifyRow(this.getDescriptor().getObjectBuilder().buildTemplateInsertRow(abstractSession));
        if (!this.getDescriptor().usesFieldLocking()) {
            if (!this.hasDeleteQuery()) {
                this.setDeleteQuery(new DeleteObjectQuery());
            }
            this.getDeleteQuery().setModifyRow(new DatabaseRecord());
        }
        if (this.hasUpdateQuery()) {
            this.getUpdateQuery().setModifyRow(this.getDescriptor().getObjectBuilder().buildTemplateUpdateRow(abstractSession));
        }
    }

    public void initializeQueryTimeout(AbstractSession abstractSession) {
        if (this.getQueryTimeout() == -1 && this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().getParentDescriptor() != null) {
            this.setQueryTimeout(this.getParentDescriptorQueryManager().getQueryTimeout());
        }
        if (this.getQueryTimeout() == -1) {
            this.setQueryTimeout(0);
        }
    }

    public DescriptorQueryManager getParentDescriptorQueryManager() {
        return this.descriptor.getInheritancePolicy().getParentDescriptor().getQueryManager();
    }

    public void postDelete(DeleteObjectQuery deleteObjectQuery) {
        ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
        if (!objectBuilder.isSimple()) {
            List<DatabaseMapping> list = objectBuilder.getRelationshipMappings();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                list.get(i).postDelete(deleteObjectQuery);
            }
        }
    }

    public void postInsert(WriteObjectQuery writeObjectQuery) {
        ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
        if (!objectBuilder.isSimple()) {
            List<DatabaseMapping> list = objectBuilder.getRelationshipMappings();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                list.get(i).postInsert(writeObjectQuery);
            }
        }
    }

    public void postUpdate(WriteObjectQuery writeObjectQuery) {
        block4: {
            ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
            if (objectBuilder.isSimple()) break block4;
            ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
            if (objectChangeSet != null && !objectChangeSet.isNew()) {
                Vector vector = objectChangeSet.getChanges();
                for (ChangeRecord changeRecord : vector) {
                    changeRecord.getMapping().postUpdate(writeObjectQuery);
                }
            } else {
                List<DatabaseMapping> list = objectBuilder.getRelationshipMappings();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    list.get(i).postUpdate(writeObjectQuery);
                }
            }
        }
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) {
        ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
        if (!objectBuilder.isSimple()) {
            List<DatabaseMapping> list = objectBuilder.getRelationshipMappings();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                list.get(i).preDelete(deleteObjectQuery);
            }
        }
    }

    public void preInitialize(AbstractSession abstractSession) {
        if (this.getDescriptor().isAggregateDescriptor()) {
            return;
        }
        if (this.getDescriptor().isChildDescriptor()) {
            DescriptorQueryManager descriptorQueryManager = this.getDescriptor().getInheritancePolicy().getParentDescriptor().getQueryManager();
            if (!this.hasInsertQuery() && descriptorQueryManager.hasInsertQuery()) {
                this.setInsertQuery((InsertObjectQuery)descriptorQueryManager.getInsertQuery().clone());
            }
            if (!this.hasUpdateQuery() && descriptorQueryManager.hasUpdateQuery()) {
                this.setUpdateQuery((UpdateObjectQuery)descriptorQueryManager.getUpdateQuery().clone());
            }
            if (!this.hasDeleteQuery() && descriptorQueryManager.hasDeleteQuery()) {
                this.setDeleteQuery((DeleteObjectQuery)descriptorQueryManager.getDeleteQuery().clone());
            }
            if (!this.hasReadObjectQuery() && descriptorQueryManager.hasReadObjectQuery()) {
                this.setReadObjectQuery((ReadObjectQuery)descriptorQueryManager.getReadObjectQuery().clone());
            }
            if (!this.hasReadAllQuery() && descriptorQueryManager.hasReadAllQuery()) {
                this.setReadAllQuery((ReadAllQuery)descriptorQueryManager.getReadAllQuery().clone());
            }
            if (!this.getDoesExistQuery().isUserDefined() && this.getDoesExistQuery().shouldCheckCacheForDoesExist()) {
                this.setDoesExistQuery((DoesExistQuery)descriptorQueryManager.getDoesExistQuery().clone());
            }
        }
    }

    public void preInsert(WriteObjectQuery writeObjectQuery) {
        ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
        if (!objectBuilder.isSimple()) {
            List<DatabaseMapping> list = objectBuilder.getRelationshipMappings();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                list.get(i).preInsert(writeObjectQuery);
            }
        }
    }

    public void preUpdate(WriteObjectQuery writeObjectQuery) {
        block4: {
            ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
            if (objectBuilder.isSimple()) break block4;
            ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
            if (objectChangeSet != null && !objectChangeSet.isNew()) {
                Vector vector = objectChangeSet.getChanges();
                for (ChangeRecord changeRecord : vector) {
                    changeRecord.getMapping().preUpdate(writeObjectQuery);
                }
            } else {
                List<DatabaseMapping> list = objectBuilder.getRelationshipMappings();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    list.get(i).preUpdate(writeObjectQuery);
                }
            }
        }
    }

    public void removeQuery(String string) {
        this.queries.remove(string);
    }

    public void removeQuery(String string, Vector vector) {
        Vector vector2 = (Vector)this.getQueries().get(string);
        if (vector2 == null) {
            return;
        }
        DatabaseQuery databaseQuery = null;
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements() && !Helper.areTypesAssignable(vector, (databaseQuery = (DatabaseQuery)enumeration.nextElement()).getArgumentTypes())) {
        }
        if (databaseQuery != null) {
            vector2.remove(databaseQuery);
        }
    }

    public void setAdditionalJoinExpression(Expression expression) {
        this.additionalJoinExpression = expression;
    }

    public void setDeleteQuery(DeleteObjectQuery deleteObjectQuery) {
        this.deleteQuery = deleteObjectQuery;
        if (deleteObjectQuery == null) {
            return;
        }
        deleteObjectQuery.setIsUserDefined(true);
        deleteObjectQuery.setDescriptor(this.getDescriptor());
        if (deleteObjectQuery.isCallQuery()) {
            deleteObjectQuery.setIsFullRowRequired(true);
        }
    }

    public void setDeleteSQLString(String string) {
        if (string == null) {
            return;
        }
        DeleteObjectQuery deleteObjectQuery = new DeleteObjectQuery();
        deleteObjectQuery.setSQLString(string);
        this.setDeleteQuery(deleteObjectQuery);
    }

    public void setDeleteCall(Call call) {
        if (call == null) {
            return;
        }
        DeleteObjectQuery deleteObjectQuery = new DeleteObjectQuery();
        deleteObjectQuery.setCall(call);
        this.setDeleteQuery(deleteObjectQuery);
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
        this.populateQueries();
    }

    public void setDoesExistQuery(DoesExistQuery doesExistQuery) {
        this.doesExistQuery = doesExistQuery;
        if (doesExistQuery == null) {
            return;
        }
        this.doesExistQuery.setIsUserDefined(true);
        this.doesExistQuery.setDescriptor(this.getDescriptor());
    }

    public void setDoesExistSQLString(String string) {
        if (string == null) {
            return;
        }
        this.getDoesExistQuery().setSQLString(string);
        this.getDoesExistQuery().checkDatabaseForDoesExist();
    }

    public void setDoesExistCall(Call call) {
        if (call == null) {
            return;
        }
        this.getDoesExistQuery().setCall(call);
    }

    public void setExistenceCheck(String string) throws DescriptorException {
        if (string.equals("Check cache")) {
            this.checkCacheForDoesExist();
        } else if (string.equals("Check database")) {
            this.checkDatabaseForDoesExist();
        } else if (string.equals("Assume existence")) {
            this.assumeExistenceForDoesExist();
        } else if (string.equals("Assume non-existence")) {
            this.assumeNonExistenceForDoesExist();
        } else {
            throw DescriptorException.setExistenceCheckingNotUnderstood(string, this.getDescriptor());
        }
    }

    protected void setHasCustomMultipleTableJoinExpression(boolean bl) {
        this.hasCustomMultipleTableJoinExpression = bl;
    }

    public void setInsertQuery(InsertObjectQuery insertObjectQuery) {
        this.insertQuery = insertObjectQuery;
        if (insertObjectQuery == null) {
            return;
        }
        this.insertQuery.setIsUserDefined(true);
        this.insertQuery.setDescriptor(this.getDescriptor());
    }

    public void setInsertCall(Call call) {
        if (call == null) {
            return;
        }
        InsertObjectQuery insertObjectQuery = new InsertObjectQuery();
        insertObjectQuery.setCall(call);
        this.setInsertQuery(insertObjectQuery);
    }

    public void setInsertSQLString(String string) {
        if (string == null) {
            return;
        }
        InsertObjectQuery insertObjectQuery = new InsertObjectQuery();
        insertObjectQuery.setSQLString(string);
        this.setInsertQuery(insertObjectQuery);
    }

    public Call getInsertCall() {
        if (this.getInsertQuery() == null) {
            return null;
        }
        return this.getInsertQuery().getDatasourceCall();
    }

    public Call getUpdateCall() {
        if (this.getUpdateQuery() == null) {
            return null;
        }
        return this.getUpdateQuery().getDatasourceCall();
    }

    public Call getDeleteCall() {
        if (this.getDeleteQuery() == null) {
            return null;
        }
        return this.getDeleteQuery().getDatasourceCall();
    }

    public Call getReadObjectCall() {
        if (this.getReadObjectQuery() == null) {
            return null;
        }
        return this.getReadObjectQuery().getDatasourceCall();
    }

    public Call getReadAllCall() {
        if (this.getReadAllQuery() == null) {
            return null;
        }
        return this.getReadAllQuery().getDatasourceCall();
    }

    public Call getDoesExistCall() {
        if (this.getDoesExistQuery() == null) {
            return null;
        }
        return this.getDoesExistQuery().getDatasourceCall();
    }

    public Map getTablesJoinExpressions() {
        if (this.tablesJoinExpressions == null) {
            this.tablesJoinExpressions = new HashMap();
        }
        return this.tablesJoinExpressions;
    }

    public void setInternalMultipleTableJoinExpression(Expression expression) {
        this.multipleTableJoinExpression = expression;
    }

    public void setMultipleTableJoinExpression(Expression expression) {
        this.multipleTableJoinExpression = expression;
        this.setHasCustomMultipleTableJoinExpression(true);
    }

    public void setReadAllQuery(ReadAllQuery readAllQuery) {
        this.readAllQuery = readAllQuery;
        if (readAllQuery == null) {
            return;
        }
        this.readAllQuery.setIsUserDefined(true);
        if (this.getDescriptor() != null) {
            this.readAllQuery.setDescriptor(this.getDescriptor());
            this.readAllQuery.setReferenceClassName(this.getDescriptor().getJavaClassName());
            try {
                this.readAllQuery.setReferenceClass(this.getDescriptor().getJavaClass());
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
    }

    public void setReadAllSQLString(String string) {
        if (string == null) {
            return;
        }
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setSQLString(string);
        this.setReadAllQuery(readAllQuery);
    }

    public void setReadAllCall(Call call) {
        if (call == null) {
            return;
        }
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setCall(call);
        this.setReadAllQuery(readAllQuery);
    }

    public void setReadObjectQuery(ReadObjectQuery readObjectQuery) {
        this.readObjectQuery = readObjectQuery;
        if (readObjectQuery == null) {
            return;
        }
        this.readObjectQuery.setIsUserDefined(true);
        if (this.getDescriptor() != null) {
            this.readObjectQuery.setDescriptor(this.getDescriptor());
            this.readObjectQuery.setReferenceClassName(this.getDescriptor().getJavaClassName());
            try {
                this.readObjectQuery.setReferenceClass(this.getDescriptor().getJavaClass());
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
    }

    public void setReadObjectSQLString(String string) {
        if (string == null) {
            return;
        }
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setSQLString(string);
        this.setReadObjectQuery(readObjectQuery);
    }

    public void setReadObjectCall(Call call) {
        if (call == null) {
            return;
        }
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setCall(call);
        this.setReadObjectQuery(readObjectQuery);
    }

    public void setUpdateQuery(UpdateObjectQuery updateObjectQuery) {
        this.updateQuery = updateObjectQuery;
        if (updateObjectQuery == null) {
            return;
        }
        this.updateQuery.setIsUserDefined(true);
        this.updateQuery.setDescriptor(this.getDescriptor());
    }

    public void setUpdateSQLString(String string) {
        if (string == null) {
            return;
        }
        UpdateObjectQuery updateObjectQuery = new UpdateObjectQuery();
        updateObjectQuery.setSQLString(string);
        this.setUpdateQuery(updateObjectQuery);
    }

    public void setUpdateCall(Call call) {
        if (call == null) {
            return;
        }
        UpdateObjectQuery updateObjectQuery = new UpdateObjectQuery();
        updateObjectQuery.setCall(call);
        this.setUpdateQuery(updateObjectQuery);
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public int getUpdateCallCacheSize() {
        return this.cachedUpdateCalls.getMaxSize();
    }

    public void setUpdateCallCacheSize(int n) {
        this.cachedUpdateCalls.setMaxSize(n);
    }

    public Vector getCachedUpdateCalls(Vector vector) {
        return (Vector)this.cachedUpdateCalls.get(vector);
    }

    public void putCachedUpdateCalls(Vector vector, Vector vector2) {
        Vector<DatasourceCall> vector3 = vector2;
        if (!vector2.isEmpty()) {
            int n = vector2.size();
            vector3 = new Vector<DatasourceCall>(n);
            for (int i = 0; i < n; ++i) {
                DatasourceCall datasourceCall = (DatasourceCall)vector2.get(i);
                DatasourceCall datasourceCall2 = (DatasourceCall)datasourceCall.clone();
                datasourceCall2.setQuery(null);
                vector3.add(datasourceCall2);
            }
        }
        this.cachedUpdateCalls.put(vector, vector3);
    }

    public DatabaseQuery getCachedExpressionQuery(DatabaseQuery databaseQuery) {
        return (DatabaseQuery)this.cachedExpressionQueries.get(databaseQuery);
    }

    public void putCachedExpressionQuery(DatabaseQuery databaseQuery) {
        this.cachedExpressionQueries.put(databaseQuery, databaseQuery);
    }
}

