/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import javax.resource.ResourceException;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;

public class EISException
extends DatabaseException {
    public static final int INCORRECT_LOGIN_INSTANCE_PROVIDED = 17002;
    public static final int PROP_NOT_SET = 17007;
    public static final int INVALID_PROP = 17008;
    public static final int PROPS_NOT_SET = 17009;
    public static final int OUTPUT_UNSUPPORTED_MSG_TYPE = 17010;
    public static final int NO_CONN_FACTORY = 17011;
    public static final int INVALID_INTERACTION_SPEC_TYPE = 17012;
    public static final int INVALID_RECORD_TYPE = 17013;
    public static final int UNKNOWN_INTERACTION_SPEC_TYPE = 17014;
    public static final int INVALID_INPUT = 17015;
    public static final int TIMEOUT = 17016;
    public static final int INPUT_UNSUPPORTED_MSG_TYPE = 17017;
    public static final int INVALID_METHOD_INVOCATION = 17018;
    public static final int TX_SESSION_TEST_ERROR = 17019;
    public static final int INVALID_AQ_INTERACTION_SPEC_TYPE = 17020;
    public static final int INVALID_AQ_RECORD_TYPE = 17021;
    public static final int INVALID_AQ_INPUT = 17022;
    public static final int INVALID_FACTORY_ATTRIBUTES = 17023;
    public static final int COULD_NOT_DELETE_FILE = 17024;
    public static final int GROUPING_ELEMENT_REQUIRED = 17025;
    public static final int EIS_EXCEPTION = 91000;
    public static final int RESOURCE_EXCEPTION = 90000;

    protected EISException(Exception exception) {
        this(exception, exception.toString());
    }

    protected EISException(String string) {
        super(string);
    }

    protected EISException(Exception exception, String string) {
        this(string);
        this.setInternalException(exception);
    }

    public static EISException resourceException(Exception exception, EISAccessor eISAccessor, AbstractSession abstractSession) {
        EISException eISException = new EISException(exception);
        eISException.setErrorCode(90000);
        eISException.setInternalException(exception);
        eISException.setAccessor(eISAccessor);
        eISException.setSession(abstractSession);
        return eISException;
    }

    public static EISException resourceException(ResourceException resourceException, EISAccessor eISAccessor, AbstractSession abstractSession) {
        return EISException.resourceException((Exception)((Object)resourceException), eISAccessor, abstractSession);
    }

    public static EISException resourceException(ResourceException resourceException, Call call, EISAccessor eISAccessor, AbstractSession abstractSession) {
        EISException eISException = EISException.resourceException(resourceException, eISAccessor, abstractSession);
        eISException.setCall(call);
        return eISException;
    }

    public static EISException createResourceException(Object[] objectArray, int n) {
        ResourceException resourceException = new ResourceException(ExceptionMessageGenerator.buildMessage(EISException.class, n, objectArray));
        EISException eISException = new EISException((Exception)((Object)resourceException));
        eISException.setErrorCode(90000);
        eISException.setInternalException(resourceException);
        return eISException;
    }

    public static EISException createException(Exception exception) {
        EISException eISException = new EISException(exception);
        eISException.setErrorCode(91000);
        return eISException;
    }

    public static EISException createException(Object[] objectArray, int n) {
        EISException eISException = new EISException(ExceptionMessageGenerator.buildMessage(EISException.class, n, objectArray));
        eISException.setErrorCode(n);
        return eISException;
    }

    public static EISException propertyNotSet(String string) {
        return EISException.createException(new Object[]{string}, 17007);
    }

    public static EISException propertiesNotSet(String string, String string2) {
        return EISException.createException(new Object[]{string, string2}, 17009);
    }

    public static EISException invalidProperty(String string) {
        return EISException.createException(new Object[]{string}, 17008);
    }

    public static EISException unsupportedMessageInOutputRecord() {
        return EISException.createException(new Object[0], 17010);
    }

    public static EISException unsupportedMessageInInputRecord() {
        return EISException.createException(new Object[0], 17017);
    }

    public static EISException noConnectionFactorySpecified() {
        return EISException.createException(new Object[0], 17011);
    }

    public static EISException invalidInteractionSpecType() {
        return EISException.createException(new Object[0], 17012);
    }

    public static EISException invalidAQInteractionSpecType() {
        return EISException.createResourceException(new Object[0], 17020);
    }

    public static EISException invalidRecordType() {
        return EISException.createException(new Object[0], 17013);
    }

    public static EISException invalidAQRecordType() {
        return EISException.createResourceException(new Object[0], 17021);
    }

    public static EISException unknownInteractionSpecType() {
        return EISException.createException(new Object[0], 17014);
    }

    public static EISException invalidConnectionFactoryAttributes() {
        return EISException.createResourceException(new Object[0], 17023);
    }

    public static EISException invalidInput() {
        return EISException.createException(new Object[0], 17015);
    }

    public static EISException invalidAQInput() {
        return EISException.createResourceException(new Object[0], 17022);
    }

    public static EISException timeoutOccurred() {
        return EISException.createException(new Object[0], 17016);
    }

    public static EISException invalidMethodInvocation() {
        return EISException.createException(new Object[0], 17018);
    }

    public static EISException transactedSessionTestError() {
        return EISException.createException(new Object[0], 17019);
    }

    public static EISException groupingElementRequired() {
        return EISException.createException(new Object[0], 17025);
    }

    public static EISException couldNotDeleteFile(Object[] objectArray) {
        return EISException.createResourceException(objectArray, 17024);
    }

    public static EISException incorrectLoginInstanceProvided(Class clazz) {
        Object[] objectArray = new Object[]{clazz};
        EISException eISException = new EISException(ExceptionMessageGenerator.buildMessage(EISException.class, 17002, objectArray));
        eISException.setErrorCode(17002);
        return eISException;
    }
}

