/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.util.Vector;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class EISOrderedCollectionChangeRecord
extends CollectionChangeRecord
implements org.eclipse.persistence.sessions.changesets.EISOrderedCollectionChangeRecord {
    private Vector adds;
    private int[] addIndexes;
    private Vector moves;
    private int[][] moveIndexPairs;
    private Vector removes;
    private int[] removeIndexes;

    public EISOrderedCollectionChangeRecord(ObjectChangeSet objectChangeSet, String string, DatabaseMapping databaseMapping) {
        this.owner = objectChangeSet;
        this.attribute = string;
        this.mapping = databaseMapping;
    }

    public void addAddedChangeSet(Object object, int n) {
        this.getAdds().addElement(object);
        this.setAddIndexes(this.addTo(n, this.getAddIndexes()));
    }

    public void addMovedChangeSet(Object object, int n, int n2) {
        this.getMoves().addElement(object);
        int[] nArray = new int[]{n, n2};
        this.setMoveIndexPairs(this.addTo(nArray, this.getMoveIndexPairs()));
    }

    public void addRemovedChangeSet(Object object, int n) {
        this.getRemoves().addElement(object);
        this.setRemoveIndexes(this.addTo(n, this.getRemoveIndexes()));
    }

    private int[] addTo(int n, int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2 + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        nArray2[n2] = n;
        return nArray2;
    }

    private int[][] addTo(int[] nArray, int[][] nArray2) {
        int n = nArray2.length;
        int[][] nArrayArray = new int[n + 1][];
        System.arraycopy(nArray2, 0, nArrayArray, 0, n);
        nArrayArray[n] = nArray;
        return nArrayArray;
    }

    private Object getAdd(int n) {
        return this.getAdds().get(n);
    }

    public int[] getAddIndexes() {
        if (this.addIndexes == null) {
            this.addIndexes = new int[0];
        }
        return this.addIndexes;
    }

    public Vector getAdds() {
        if (this.adds == null) {
            this.adds = new Vector(1);
        }
        return this.adds;
    }

    private int getAddsIndexOf(Object object) {
        if (this.adds == null) {
            return -1;
        }
        return this.adds.indexOf(object);
    }

    private int getAddsSize() {
        if (this.adds == null) {
            return 0;
        }
        return this.adds.size();
    }

    private Object getMove(int n) {
        return this.getMoves().get(n);
    }

    private int getBeforeMoveIndex(int n) {
        int[][] nArray = this.getMoveIndexPairs();
        return nArray[n][0];
    }

    public int[][] getMoveIndexPairs() {
        if (this.moveIndexPairs == null) {
            this.moveIndexPairs = new int[0][0];
        }
        return this.moveIndexPairs;
    }

    public Vector getMoves() {
        if (this.moves == null) {
            this.moves = new Vector(1);
        }
        return this.moves;
    }

    private int getMovesIndexOf(Object object) {
        if (this.moves == null) {
            return -1;
        }
        return this.moves.indexOf(object);
    }

    private int getMovesSize() {
        if (this.moves == null) {
            return 0;
        }
        return this.moves.size();
    }

    public Vector getNewCollection() {
        int[][] nArray;
        int n = this.getNewCollectionSize();
        Vector<Object> vector = new Vector<Object>(n);
        int[] nArray2 = this.addIndexes;
        if (nArray2 == null) {
            nArray2 = new int[]{};
        }
        if ((nArray = this.moveIndexPairs) == null) {
            nArray = new int[0][0];
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (n2 < nArray2.length && nArray2[n2] == i) {
                vector.add(this.getAdd(n2));
                ++n2;
                continue;
            }
            if (n3 < nArray.length && nArray[n3][1] == i) {
                vector.add(this.getMove(n3));
                ++n3;
                continue;
            }
            throw new IllegalStateException(String.valueOf(i));
        }
        return vector;
    }

    private int getNewCollectionSize() {
        return this.getAddsSize() + this.getMovesSize();
    }

    private int getRemoveIndex(int n) {
        return this.getRemoveIndexes()[n];
    }

    public int[] getRemoveIndexes() {
        if (this.removeIndexes == null) {
            this.removeIndexes = new int[0];
        }
        return this.removeIndexes;
    }

    public Vector getRemoves() {
        if (this.removes == null) {
            this.removes = new Vector(1);
        }
        return this.removes;
    }

    private int getRemovesIndexOf(Object object) {
        if (this.removes == null) {
            return -1;
        }
        return this.removes.indexOf(object);
    }

    private boolean hasAdds() {
        return this.addIndexes != null && this.addIndexes.length != 0;
    }

    public boolean hasChanges() {
        if (this.hasAdds() || this.hasRemoves() || this.getOwner().isNew()) {
            return true;
        }
        if (this.hasMoves()) {
            for (int i = 0; i < this.moveIndexPairs.length; ++i) {
                if (this.moveIndexPairs[i][0] == this.moveIndexPairs[i][1]) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasMoves() {
        return this.moveIndexPairs != null && this.moveIndexPairs.length != 0;
    }

    private boolean hasRemoves() {
        return this.removeIndexes != null && this.removeIndexes.length != 0;
    }

    private int[] removeFrom(int n, int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2 - 1];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        System.arraycopy(nArray, n + 1, nArray2, n, n2 - n - 1);
        return nArray2;
    }

    private int[][] removeFrom(int n, int[][] nArray) {
        int n2 = nArray.length;
        int[][] nArrayArray = new int[n2 - 1][];
        System.arraycopy(nArray, 0, nArrayArray, 0, n);
        System.arraycopy(nArray, n + 1, nArrayArray, n, n2 - n - 1);
        return nArrayArray;
    }

    private void cancelAddedChangeSet(Object object) {
        int n = this.getAddsIndexOf(object);
        if (n == -1) {
            throw new IllegalStateException(object.toString());
        }
        this.getAdds().remove(n);
        this.setAddIndexes(this.removeFrom(n, this.getAddIndexes()));
    }

    private boolean removeMovedChangeSet(Object object) {
        int n = this.getMovesIndexOf(object);
        if (n == -1) {
            return false;
        }
        this.getMoves().remove(n);
        int n2 = this.getBeforeMoveIndex(n);
        this.setMoveIndexPairs(this.removeFrom(n, this.getMoveIndexPairs()));
        this.addRemovedChangeSet(object, n2);
        return true;
    }

    private boolean restoreRemovedChangeSet(Object object) {
        int n = this.getRemovesIndexOf(object);
        if (n == -1) {
            return false;
        }
        this.getRemoves().remove(n);
        int n2 = this.getRemoveIndex(n);
        this.setRemoveIndexes(this.removeFrom(n, this.getRemoveIndexes()));
        this.addMovedChangeSet(object, n2, this.getNewCollectionSize());
        return true;
    }

    private void setAddIndexes(int[] nArray) {
        this.addIndexes = nArray;
    }

    private void setMoveIndexPairs(int[][] nArray) {
        this.moveIndexPairs = nArray;
    }

    private void setRemoveIndexes(int[] nArray) {
        this.removeIndexes = nArray;
    }

    public void simpleAddChangeSet(Object object) {
        if (!this.restoreRemovedChangeSet(object)) {
            this.addAddedChangeSet(object, this.getNewCollectionSize());
        }
    }

    public void simpleRemoveChangeSet(Object object) {
        if (!this.removeMovedChangeSet(object)) {
            this.cancelAddedChangeSet(object);
        }
    }
}

