/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.interactions;

import java.io.StringWriter;
import java.util.Enumeration;
import org.eclipse.persistence.eis.interactions.MappedInteraction;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.QueryStringCall;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class QueryStringInteraction
extends MappedInteraction
implements QueryStringCall {
    protected String queryString;

    public QueryStringInteraction() {
        this.queryString = "";
    }

    public QueryStringInteraction(String string) {
        this.queryString = string;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public void translate(AbstractRecord abstractRecord, AbstractRecord abstractRecord2, AbstractSession abstractSession) {
        this.translateQueryString(abstractRecord, abstractRecord2, abstractSession);
    }

    public void prepare(AbstractSession abstractSession) {
        if (this.isPrepared()) {
            return;
        }
        this.translateCustomQuery();
        this.setIsPrepared(true);
    }

    public String getLogString(Accessor accessor) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("Executing ");
        stringWriter.write(this.toString());
        stringWriter.write(Helper.cr());
        stringWriter.write("\tspec => ");
        stringWriter.write(String.valueOf(this.getInteractionSpec()));
        stringWriter.write(Helper.cr());
        stringWriter.write("\tquery => ");
        stringWriter.write(this.getQueryString());
        stringWriter.write(Helper.cr());
        stringWriter.write("\tparameters => [");
        if (this.hasParameters()) {
            Enumeration enumeration = this.getParameters().elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                stringWriter.write(String.valueOf(e));
                if (!enumeration.hasMoreElements()) continue;
                stringWriter.write(", ");
            }
        }
        stringWriter.write("]");
        return stringWriter.toString();
    }

    public boolean isQueryStringCall() {
        return true;
    }
}

