/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.interactions;

import java.io.StringWriter;
import java.util.Vector;
import javax.resource.cci.Record;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISDOMRecord;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.interactions.MappedInteraction;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.w3c.dom.Element;

public class XMLInteraction
extends MappedInteraction {
    protected String inputRootElementName = "";
    protected String outputRootElementName = "";

    public String getInputRootElementName() {
        return this.inputRootElementName;
    }

    public void setInputRootElementName(String string) {
        this.inputRootElementName = string;
    }

    public String getOutputRootElementName() {
        return this.outputRootElementName;
    }

    public void setOutputRootElementName(String string) {
        this.outputRootElementName = string;
    }

    public void prepare(AbstractSession abstractSession) {
        EISDescriptor eISDescriptor;
        if (this.getInputRootElementName().length() == 0) {
            if (this.getQuery() != null && this.getQuery().getDescriptor() instanceof EISDescriptor) {
                eISDescriptor = (EISDescriptor)this.getQuery().getDescriptor();
                this.setInputRootElementName(eISDescriptor.getDataTypeName());
            } else {
                this.setInputRootElementName("input");
            }
        }
        if (this.getOutputRootElementName().length() == 0) {
            if (this.getQuery() != null && this.getQuery().getDescriptor() instanceof EISDescriptor) {
                eISDescriptor = (EISDescriptor)this.getQuery().getDescriptor();
                this.setOutputRootElementName(eISDescriptor.getDataTypeName());
            } else {
                this.setInputRootElementName("output");
            }
        }
        super.prepare(abstractSession);
    }

    public Record createInputRecord(EISAccessor eISAccessor) {
        Record record = eISAccessor.getEISPlatform().createDOMRecord(this.getInputRecordName(), eISAccessor);
        Element element = this.createInputDOM(eISAccessor);
        eISAccessor.getEISPlatform().setDOMInRecord(element, record, this, eISAccessor);
        if (record instanceof XMLRecord) {
            ((XMLRecord)record).setSession(this.getQuery().getSession());
        }
        return record;
    }

    public Element createInputDOM(EISAccessor eISAccessor) {
        Element element = null;
        if (this.getInputRow() != null && !this.hasArguments()) {
            if (this.getInputResultPath().length() == 0) {
                if (this.getInputRow() instanceof XMLRecord) {
                    element = (Element)((XMLRecord)this.getInputRow()).getDOM();
                    if (!element.getTagName().equals(this.getInputRootElementName())) {
                        XMLRecord xMLRecord = this.createXMLRecord(this.getInputRootElementName());
                        xMLRecord.put("/" + this.getInputRootElementName(), (Object)this.getInputRow());
                        element = (Element)xMLRecord.getDOM();
                    }
                } else {
                    XMLRecord xMLRecord = this.createXMLRecord(this.getInputRootElementName());
                    for (int i = 0; i < this.getInputRow().size(); ++i) {
                        xMLRecord.put(this.getInputRow().getFields().elementAt(i), this.getInputRow().getValues().elementAt(i));
                    }
                    element = (Element)xMLRecord.getDOM();
                }
            } else {
                XMLRecord xMLRecord = this.createXMLRecord(this.getInputRootElementName());
                xMLRecord.put(this.getInputResultPath(), (Object)this.getInputRow());
                element = (Element)xMLRecord.getDOM();
            }
        } else {
            XMLRecord xMLRecord = this.createXMLRecord(this.getInputRootElementName());
            for (int i = 0; i < this.getArgumentNames().size(); ++i) {
                String string = (String)this.getArgumentNames().get(i);
                Object object = this.getParameters().get(i);
                if (object == null && this.getInputRow() != null) {
                    object = this.getInputRow().get(string);
                }
                xMLRecord.put(string, object);
            }
            element = (Element)xMLRecord.getDOM();
        }
        return element;
    }

    public AbstractRecord buildRow(Record record, EISAccessor eISAccessor) {
        if (record == null) {
            return null;
        }
        AbstractRecord abstractRecord = eISAccessor.getEISPlatform().createDatabaseRowFromDOMRecord(record, this, eISAccessor);
        if (abstractRecord == null) {
            return null;
        }
        if (this.getOutputResultPath().length() > 0) {
            abstractRecord = (AbstractRecord)abstractRecord.get(this.getOutputResultPath());
        } else if (this.hasOutputArguments()) {
            abstractRecord = this.createXMLRecord(this.getOutputRootElementName());
            for (int i = 0; i < this.getOutputArgumentNames().size(); ++i) {
                DatabaseField databaseField = (DatabaseField)this.getOutputArguments().get(i);
                abstractRecord.put(databaseField, abstractRecord.get(this.getOutputArgumentNames().get(i)));
            }
        }
        return abstractRecord;
    }

    public Vector buildRows(Record record, EISAccessor eISAccessor) {
        Vector<AbstractRecord> vector = null;
        if (record == null) {
            return new Vector(0);
        }
        AbstractRecord abstractRecord = eISAccessor.getEISPlatform().createDatabaseRowFromDOMRecord(record, this, eISAccessor);
        if (this.getOutputResultPath().length() > 0) {
            Vector<AbstractRecord> vector2 = (Vector<AbstractRecord>)abstractRecord.getValues(this.getOutputResultPath());
            if (vector2 == null) {
                vector2 = new Vector<AbstractRecord>(0);
            }
            vector = vector2;
        } else {
            vector = new Vector<AbstractRecord>(1);
            vector.add(abstractRecord);
        }
        return vector;
    }

    public String getLogString(Accessor accessor) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("Executing ");
        stringWriter.write(this.toString());
        stringWriter.write(Helper.cr());
        stringWriter.write("\tspec => ");
        stringWriter.write(String.valueOf(this.getInteractionSpec()));
        stringWriter.write(Helper.cr());
        stringWriter.write("\tproperties => ");
        stringWriter.write(String.valueOf(this.getProperties()));
        stringWriter.write(Helper.cr());
        stringWriter.write("\txml => ");
        Element element = this.createInputDOM((EISAccessor)accessor);
        EISDOMRecord eISDOMRecord = new EISDOMRecord(element);
        eISDOMRecord.transformToWriter(stringWriter);
        return stringWriter.toString();
    }

    protected DatabaseField createField(String string) {
        if (this.getQuery().getDescriptor() != null) {
            return this.getQuery().getDescriptor().buildField(string);
        }
        return new XMLField(string);
    }

    protected XMLRecord createXMLRecord(String string) {
        XMLRecord xMLRecord;
        if (this.getQuery().getDescriptor() != null && this.getQuery().getDescriptor() instanceof EISDescriptor) {
            xMLRecord = (XMLRecord)((XMLObjectBuilder)this.getQuery().getDescriptor().getObjectBuilder()).createRecord(this.getInputRootElementName(), this.getQuery().getSession());
        } else {
            xMLRecord = new DOMRecord(this.getInputRootElementName());
            xMLRecord.setSession(this.getQuery().getSession());
        }
        return xMLRecord;
    }
}

