/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseLogin;

public abstract class EclipseLinkException
extends RuntimeException {
    protected transient AbstractSession session;
    protected Throwable internalException;
    protected static Boolean shouldPrintInternalException = null;
    protected String indentationString = "";
    protected int errorCode;
    protected static final String CR = System.getProperty("line.separator");
    protected boolean hasBeenLogged = false;

    public EclipseLinkException() {
        this("");
    }

    public EclipseLinkException(String string) {
        super(string);
    }

    public EclipseLinkException(String string, Throwable throwable) {
        this(string);
        this.setInternalException(throwable);
    }

    protected static String cr() {
        return Helper.cr();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getIndentationString() {
        return this.indentationString;
    }

    public Throwable getInternalException() {
        return this.internalException;
    }

    public String getMessage() {
        StringWriter stringWriter = new StringWriter(100);
        if (this.getInternalException() == null || super.getMessage() != null && !super.getMessage().equals(this.getInternalException().toString())) {
            stringWriter.write(EclipseLinkException.cr());
            stringWriter.write(this.getIndentationString());
            stringWriter.write(ExceptionMessageGenerator.getHeader("DescriptionHeader"));
            stringWriter.write(super.getMessage());
        }
        if (this.getInternalException() != null) {
            stringWriter.write(EclipseLinkException.cr());
            stringWriter.write(this.getIndentationString());
            stringWriter.write(ExceptionMessageGenerator.getHeader("InternalExceptionHeader"));
            stringWriter.write(this.getInternalException().toString());
            if (this.getInternalException() instanceof InvocationTargetException && ((InvocationTargetException)this.getInternalException()).getTargetException() != null) {
                stringWriter.write(EclipseLinkException.cr());
                stringWriter.write(this.getIndentationString());
                stringWriter.write(ExceptionMessageGenerator.getHeader("TargetInvocationExceptionHeader"));
                stringWriter.write(((InvocationTargetException)this.getInternalException()).getTargetException().toString());
            }
        }
        return stringWriter.toString();
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public boolean hasBeenLogged() {
        return this.hasBeenLogged;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream));
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.write(ExceptionMessageGenerator.getHeader("LocalExceptionStackHeader"));
        printWriter.write(EclipseLinkException.cr());
        super.printStackTrace(printWriter);
        if (this.getInternalException() != null && EclipseLinkException.shouldPrintInternalException()) {
            printWriter.write(ExceptionMessageGenerator.getHeader("InternalExceptionStackHeader"));
            printWriter.write(EclipseLinkException.cr());
            this.getInternalException().printStackTrace(printWriter);
            if (this.getInternalException() instanceof InvocationTargetException && ((InvocationTargetException)this.getInternalException()).getTargetException() != null) {
                printWriter.write(ExceptionMessageGenerator.getHeader("TargetInvocationExceptionStackHeader"));
                printWriter.write(EclipseLinkException.cr());
                ((InvocationTargetException)this.getInternalException()).getTargetException().printStackTrace(printWriter);
            }
        }
        printWriter.flush();
    }

    public void setErrorCode(int n) {
        this.errorCode = n;
    }

    public void setHasBeenLogged(boolean bl) {
        this.hasBeenLogged = bl;
    }

    public void setIndentationString(String string) {
        this.indentationString = string;
    }

    public void setInternalException(Throwable throwable) {
        this.internalException = throwable;
        if (this.getCause() == null) {
            this.initCause(throwable);
        }
    }

    public void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    public static void setShouldPrintInternalException(boolean bl) {
        shouldPrintInternalException = new Boolean(bl);
    }

    public static boolean shouldPrintInternalException() {
        if (shouldPrintInternalException == null) {
            shouldPrintInternalException = Boolean.FALSE;
        }
        return shouldPrintInternalException;
    }

    public String toString() {
        return this.getIndentationString() + ExceptionMessageGenerator.getHeader("ExceptionHeader") + this.getErrorCode() + "] (" + DatabaseLogin.getVersion() + "): " + this.getClass().getName() + this.getMessage();
    }
}

