/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.util.Vector;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;

public class OptimisticLockException
extends EclipseLinkException {
    protected transient ObjectLevelModifyQuery query;
    public static final int NO_VERSION_NUMBER_WHEN_DELETING = 5001;
    public static final int OBJECT_CHANGED_SINCE_LAST_READ_WHEN_DELETING = 5003;
    public static final int NO_VERSION_NUMBER_WHEN_UPDATING = 5004;
    public static final int OBJECT_CHANGED_SINCE_LAST_READ_WHEN_UPDATING = 5006;
    public static final int MUST_HAVE_MAPPING_WHEN_IN_OBJECT = 5007;
    public static final int NEED_TO_MAP_JAVA_SQL_TIMESTAMP = 5008;
    public static final int UNWRAPPING_OBJECT_DELETED_SINCE_LAST_READ = 5009;
    public static final int OBJECT_CHANGED_SINCE_LAST_MERGE = 5010;
    public static final int STATEMENT_NOT_EXECUTED_IN_BATCH = 5011;

    protected OptimisticLockException(String string) {
        super(string);
    }

    protected OptimisticLockException(String string, ObjectLevelModifyQuery objectLevelModifyQuery) {
        super(string);
        this.query = objectLevelModifyQuery;
        objectLevelModifyQuery.getSession().incrementProfile("OptimisticLocks");
    }

    public Object getObject() {
        return this.getQuery().getObject();
    }

    public ObjectLevelModifyQuery getQuery() {
        return this.query;
    }

    public static OptimisticLockException batchStatementExecutionFailure() {
        Object[] objectArray = new Object[]{};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5011, objectArray));
        optimisticLockException.setErrorCode(5011);
        return optimisticLockException;
    }

    public static OptimisticLockException mustHaveMappingWhenStoredInObject(Class clazz) {
        Object[] objectArray = new Object[]{clazz};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5007, objectArray));
        optimisticLockException.setErrorCode(5007);
        return optimisticLockException;
    }

    public static OptimisticLockException noVersionNumberWhenDeleting(Object object, ObjectLevelModifyQuery objectLevelModifyQuery) {
        Vector vector = new Vector();
        if (objectLevelModifyQuery.getSession() != null) {
            vector = objectLevelModifyQuery.getSession().keyFromObject(object);
        }
        Object[] objectArray = new Object[]{object, object.getClass().getName(), vector, CR};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5001, objectArray), objectLevelModifyQuery);
        optimisticLockException.setErrorCode(5001);
        return optimisticLockException;
    }

    public static OptimisticLockException noVersionNumberWhenUpdating(Object object, ObjectLevelModifyQuery objectLevelModifyQuery) {
        Vector vector = new Vector();
        if (objectLevelModifyQuery.getSession() != null) {
            vector = objectLevelModifyQuery.getSession().keyFromObject(object);
        }
        Object[] objectArray = new Object[]{object, object.getClass().getName(), vector, CR};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5004, objectArray), objectLevelModifyQuery);
        optimisticLockException.setErrorCode(5004);
        return optimisticLockException;
    }

    public static OptimisticLockException objectChangedSinceLastReadWhenDeleting(Object object, ObjectLevelModifyQuery objectLevelModifyQuery) {
        Vector vector = new Vector();
        if (objectLevelModifyQuery.getSession() != null) {
            vector = objectLevelModifyQuery.getSession().keyFromObject(object);
        }
        Object[] objectArray = new Object[]{object, object.getClass().getName(), vector, CR};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5003, objectArray), objectLevelModifyQuery);
        optimisticLockException.setErrorCode(5003);
        return optimisticLockException;
    }

    public static OptimisticLockException objectChangedSinceLastReadWhenUpdating(Object object, ObjectLevelModifyQuery objectLevelModifyQuery) {
        Vector vector = new Vector();
        if (objectLevelModifyQuery.getSession() != null) {
            vector = objectLevelModifyQuery.getSession().keyFromObject(object);
        }
        Object[] objectArray = new Object[]{object, object.getClass().getName(), vector, CR};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5006, objectArray), objectLevelModifyQuery);
        optimisticLockException.setErrorCode(5006);
        return optimisticLockException;
    }

    public static OptimisticLockException objectChangedSinceLastMerge(Object object) {
        Object[] objectArray = new Object[]{object, object.getClass().getName(), CR};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5010, objectArray));
        optimisticLockException.setErrorCode(5010);
        return optimisticLockException;
    }

    public static OptimisticLockException unwrappingObjectDeletedSinceLastRead(Vector vector, String string) {
        Object[] objectArray = new Object[]{vector, string};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5009, objectArray));
        optimisticLockException.setErrorCode(5009);
        return optimisticLockException;
    }

    public static OptimisticLockException needToMapJavaSqlTimestampWhenStoredInObject() {
        Object[] objectArray = new Object[]{};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5008, objectArray));
        optimisticLockException.setErrorCode(5008);
        return optimisticLockException;
    }

    public void setQuery(ObjectLevelModifyQuery objectLevelModifyQuery) {
        this.query = objectLevelModifyQuery;
    }
}

