/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.history;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLInsertStatement;
import org.eclipse.persistence.internal.expressions.SQLUpdateStatement;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.history.HistoricalDatabaseTable;
import org.eclipse.persistence.internal.queries.StatementQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class HistoryPolicy
implements Cloneable,
Serializable {
    protected ClassDescriptor descriptor;
    protected DatabaseMapping mapping;
    protected Vector historicalTables;
    protected Vector startFields;
    protected Vector endFields;
    protected boolean shouldHandleWrites = true;
    protected boolean usesLocalTime = true;

    public Expression additionalHistoryExpression(ObjectExpression objectExpression) {
        Cloneable cloneable;
        AsOfClause asOfClause = objectExpression.getAsOfClause();
        Object object = asOfClause.getValue();
        Expression expression = null;
        Expression expression2 = null;
        Expression expression3 = null;
        Expression expression4 = null;
        if (object == null) {
            return null;
        }
        if (object instanceof Expression) {
            if (object instanceof ConstantExpression && ((ConstantExpression)object).getValue() instanceof String) {
                object = ((ConstantExpression)object).getValue();
            }
        } else {
            cloneable = ConversionManager.getDefaultManager();
            object = ((ConversionManager)cloneable).convertObject(object, ClassConstants.TIMESTAMP);
        }
        if (this.getMapping() != null) {
            cloneable = null;
            DatabaseTable databaseTable = (DatabaseTable)this.getHistoricalTables().elementAt(0);
            cloneable = (TableExpression)objectExpression.existingDerivedTable(databaseTable);
            expression3 = ((DataExpression)cloneable).getField(this.getStart());
            expression4 = ((DataExpression)cloneable).getField(this.getEnd());
            expression = objectExpression.shouldUseOuterJoin() && objectExpression.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() ? expression3.isNull().or(expression3.lessThanEqual(object)) : expression3.lessThanEqual(object);
            expression = expression.and(expression4.isNull().or(expression4.greaterThan(object)));
            ((TableExpression)cloneable).setTable(databaseTable);
            return expression;
        }
        for (int i = 0; i < this.getHistoricalTables().size(); ++i) {
            expression3 = objectExpression.getField(this.getStart(i));
            expression4 = objectExpression.getField(this.getEnd(i));
            expression2 = objectExpression.shouldUseOuterJoin() && objectExpression.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() ? expression3.isNull().or(expression3.lessThanEqual(object)) : expression3.lessThanEqual(object);
            expression2 = expression2.and(expression4.isNull().or(expression4.greaterThan(object)));
            expression = expression == null ? expression2 : expression.and(expression2);
        }
        return expression;
    }

    public Object clone() {
        Enumeration enumeration;
        HistoryPolicy historyPolicy = null;
        try {
            historyPolicy = (HistoryPolicy)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.startFields != null) {
            historyPolicy.setStartFields(NonSynchronizedVector.newInstance(this.startFields.size()));
            enumeration = this.startFields.elements();
            while (enumeration.hasMoreElements()) {
                historyPolicy.getStartFields().addElement(((DatabaseField)enumeration.nextElement()).clone());
            }
        }
        if (this.endFields != null) {
            historyPolicy.setEndFields(NonSynchronizedVector.newInstance(this.endFields.size()));
            enumeration = this.endFields.elements();
            while (enumeration.hasMoreElements()) {
                historyPolicy.getEndFields().addElement(((DatabaseField)enumeration.nextElement()).clone());
            }
        }
        if (this.historicalTables != null) {
            historyPolicy.setHistoricalTables((Vector)this.historicalTables.clone());
        }
        return historyPolicy;
    }

    public Object getCurrentTime(AbstractSession abstractSession) {
        if (this.shouldUseLocalTime()) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (this.shouldUseDatabaseTime()) {
            AbstractSession abstractSession2 = abstractSession.getSessionForClass(this.getDescriptor().getJavaClass());
            while (abstractSession2.isUnitOfWork()) {
                abstractSession2 = ((UnitOfWorkImpl)abstractSession2).getParent().getSessionForClass(this.getDescriptor().getJavaClass());
            }
            return abstractSession2.getDatasourceLogin().getDatasourcePlatform().getTimestampFromServer(abstractSession, abstractSession2.getName());
        }
        return null;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final Vector getHistoricalTables() {
        if (this.historicalTables == null) {
            this.historicalTables = NonSynchronizedVector.newInstance(1);
        }
        return this.historicalTables;
    }

    public Vector getHistoryTableNames() {
        Vector<String> vector = new Vector<String>(this.getHistoricalTables().size());
        Enumeration enumeration = this.getHistoricalTables().elements();
        while (enumeration.hasMoreElements()) {
            HistoricalDatabaseTable historicalDatabaseTable = (HistoricalDatabaseTable)enumeration.nextElement();
            vector.addElement(historicalDatabaseTable.getQualifiedName());
        }
        return vector;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected DatabaseField getStart() {
        if (this.startFields != null) {
            return (DatabaseField)this.startFields.elementAt(0);
        }
        return null;
    }

    protected DatabaseField getStart(int n) {
        return (DatabaseField)this.startFields.elementAt(n);
    }

    public String getStartFieldName() {
        if (this.getStart() != null) {
            return this.getStart().getName();
        }
        return null;
    }

    public Vector getStartFields() {
        return this.startFields;
    }

    protected DatabaseField getEnd() {
        if (this.endFields != null) {
            return (DatabaseField)this.endFields.elementAt(0);
        }
        return null;
    }

    protected DatabaseField getEnd(int n) {
        return (DatabaseField)this.endFields.elementAt(n);
    }

    public String getEndFieldName() {
        if (this.getEnd() != null) {
            return this.getEnd().getName();
        }
        return null;
    }

    public Vector getEndFields() {
        return this.endFields;
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    public void initialize(AbstractSession abstractSession) {
        Cloneable cloneable;
        Cloneable cloneable2;
        if (this.getMapping() != null) {
            this.setDescriptor(this.getMapping().getDescriptor());
            if (this.getMapping().isDirectCollectionMapping()) {
                DatabaseTable databaseTable = ((DirectCollectionMapping)this.getMapping()).getReferenceTable();
                DatabaseTable databaseTable2 = (DatabaseTable)this.getHistoricalTables().elementAt(0);
                databaseTable2.setName(databaseTable.getName());
                databaseTable2.setTableQualifier(databaseTable.getTableQualifier());
                this.getStart().setTable(databaseTable2);
                this.getEnd().setTable(databaseTable2);
            } else if (this.getMapping().isManyToManyMapping()) {
                DatabaseTable databaseTable = ((ManyToManyMapping)this.getMapping()).getRelationTable();
                DatabaseTable databaseTable3 = (DatabaseTable)this.getHistoricalTables().elementAt(0);
                databaseTable3.setName(databaseTable.getName());
                databaseTable3.setTableQualifier(databaseTable.getTableQualifier());
                this.getStart().setTable(databaseTable3);
                this.getEnd().setTable(databaseTable3);
            }
            this.verifyTableQualifiers(abstractSession.getPlatform());
            return;
        }
        int n = this.getDescriptor().getTables().size() - this.getHistoricalTables().size();
        if (!this.getHistoricalTables().isEmpty() && ((DatabaseTable)this.getHistoricalTables().elementAt(0)).getName().equals("")) {
            for (int i = 0; i < this.getHistoricalTables().size(); ++i) {
                cloneable2 = (HistoricalDatabaseTable)this.getHistoricalTables().elementAt(i);
                if (((DatabaseTable)cloneable2).getName().equals("")) {
                    cloneable = this.getDescriptor().getTables().elementAt(i + n);
                    ((DatabaseTable)cloneable2).setName(((DatabaseTable)cloneable).getName());
                    ((DatabaseTable)cloneable2).setTableQualifier(((DatabaseTable)cloneable).getTableQualifier());
                }
                if (this.getStartFields().size() < i + 1) {
                    cloneable = (DatabaseField)this.getStart(0).clone();
                    ((DatabaseField)cloneable).setTable((DatabaseTable)cloneable2);
                    this.getStartFields().addElement(cloneable);
                } else {
                    cloneable = this.getStart(i);
                    ((DatabaseField)cloneable).setTable((DatabaseTable)cloneable2);
                }
                if (this.getEndFields().size() < i + 1) {
                    cloneable = (DatabaseField)this.getEnd(0).clone();
                    ((DatabaseField)cloneable).setTable((DatabaseTable)cloneable2);
                    this.getEndFields().addElement(cloneable);
                    continue;
                }
                cloneable = this.getEnd(i);
                ((DatabaseField)cloneable).setTable((DatabaseTable)cloneable2);
            }
        } else {
            Vector vector = this.getHistoricalTables();
            cloneable2 = NonSynchronizedVector.newInstance(vector.size());
            cloneable = NonSynchronizedVector.newInstance(vector.size());
            NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
            boolean bl = this.getStartFields().size() == 1 && ((DatabaseField)this.getStartFields().get(0)).getTableName().equals("");
            boolean bl2 = this.getEndFields().size() == 1 && ((DatabaseField)this.getEndFields().get(0)).getTableName().equals("");
            DatabaseTable databaseTable = null;
            HistoricalDatabaseTable historicalDatabaseTable = null;
            DatabaseField databaseField = null;
            Vector<DatabaseTable> vector2 = this.getDescriptor().getTables();
            block1: for (int i = n; i < vector2.size(); ++i) {
                Enumeration enumeration;
                databaseTable = vector2.elementAt(i);
                int n2 = vector.indexOf(databaseTable);
                if (n2 == -1) {
                    // empty if block
                }
                historicalDatabaseTable = (HistoricalDatabaseTable)vector.elementAt(n2);
                historicalDatabaseTable.setTableQualifier(databaseTable.getTableQualifier());
                ((Vector)cloneable2).add(historicalDatabaseTable);
                if (bl) {
                    databaseField = (DatabaseField)this.getStart(0).clone();
                    databaseField.setTable(historicalDatabaseTable);
                    ((Vector)cloneable).add(databaseField);
                } else {
                    enumeration = this.getStartFields().elements();
                    while (enumeration.hasMoreElements()) {
                        databaseField = (DatabaseField)enumeration.nextElement();
                        if (databaseField.getTable().equals(historicalDatabaseTable)) {
                            ((Vector)cloneable).add(databaseField);
                            break;
                        }
                        if (enumeration.hasMoreElements()) continue;
                    }
                }
                if (bl2) {
                    databaseField = (DatabaseField)this.getEnd(0).clone();
                    databaseField.setTable(historicalDatabaseTable);
                    ((Vector)nonSynchronizedVector).add(databaseField);
                    continue;
                }
                enumeration = this.getEndFields().elements();
                while (enumeration.hasMoreElements()) {
                    databaseField = (DatabaseField)enumeration.nextElement();
                    if (databaseField.getTable().equals(historicalDatabaseTable)) {
                        ((Vector)nonSynchronizedVector).add(databaseField);
                        continue block1;
                    }
                    if (enumeration.hasMoreElements()) continue;
                }
            }
            this.setHistoricalTables((Vector)cloneable2);
            this.setStartFields((Vector)cloneable);
            this.setEndFields(nonSynchronizedVector);
        }
        this.verifyTableQualifiers(abstractSession.getDatasourcePlatform());
        if (this.getDescriptor().hasInheritance()) {
            ClassDescriptor classDescriptor = this.getDescriptor().getInheritancePolicy().getParentDescriptor();
            while (classDescriptor != null && classDescriptor.getHistoryPolicy() == null) {
                classDescriptor = classDescriptor.getInheritancePolicy().getParentDescriptor();
            }
            if (classDescriptor != null) {
                this.setHistoricalTables(Helper.concatenateUniqueVectors(classDescriptor.getHistoryPolicy().getHistoricalTables(), this.getHistoricalTables()));
                this.setStartFields(Helper.concatenateUniqueVectors(classDescriptor.getHistoryPolicy().getStartFields(), this.getStartFields()));
                this.setEndFields(Helper.concatenateUniqueVectors(classDescriptor.getHistoryPolicy().getEndFields(), this.getEndFields()));
            }
        }
    }

    public void addHistoryTableName(String string) {
        HistoricalDatabaseTable historicalDatabaseTable = new HistoricalDatabaseTable("");
        historicalDatabaseTable.setHistoricalName(string);
        this.getHistoricalTables().add(historicalDatabaseTable);
    }

    public void addHistoryTableName(String string, String string2) {
        if (string == null || string.equals("")) {
            this.addHistoryTableName(string2);
        }
        HistoricalDatabaseTable historicalDatabaseTable = new HistoricalDatabaseTable(string);
        historicalDatabaseTable.setHistoricalName(string2);
        int n = this.getHistoricalTables().indexOf(historicalDatabaseTable);
        if (n == -1) {
            this.getHistoricalTables().add(historicalDatabaseTable);
        } else {
            this.getHistoricalTables().set(n, historicalDatabaseTable);
        }
    }

    public void setHistoricalTables(Vector vector) {
        this.historicalTables = vector;
    }

    public void setMapping(DatabaseMapping databaseMapping) {
        this.mapping = databaseMapping;
    }

    protected void setStartFields(Vector vector) {
        this.startFields = vector;
    }

    public void addStartFieldName(String string) {
        DatabaseField databaseField = new DatabaseField(string);
        databaseField.setType(ClassConstants.TIMESTAMP);
        if (this.startFields == null) {
            this.startFields = NonSynchronizedVector.newInstance();
            this.startFields.addElement(databaseField);
            return;
        }
        Enumeration enumeration = this.startFields.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField2 = (DatabaseField)enumeration.nextElement();
            if (!databaseField.getTableName().equals(databaseField2.getTableName())) continue;
            databaseField2.setName(databaseField.getName());
            return;
        }
        this.startFields.addElement(databaseField);
    }

    public void setStartFieldType(Class clazz) {
        Enumeration enumeration = this.startFields.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            databaseField.setType(clazz);
        }
    }

    protected void setEndFields(Vector vector) {
        this.endFields = vector;
    }

    public void addEndFieldName(String string) {
        DatabaseField databaseField = new DatabaseField(string);
        databaseField.setType(ClassConstants.TIMESTAMP);
        if (this.endFields == null) {
            this.endFields = NonSynchronizedVector.newInstance();
            this.endFields.addElement(databaseField);
            return;
        }
        Enumeration enumeration = this.endFields.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField2 = (DatabaseField)enumeration.nextElement();
            if (!databaseField.getTableName().equals(databaseField2.getTableName())) continue;
            databaseField2.setName(databaseField.getName());
            return;
        }
        this.endFields.addElement(databaseField);
    }

    public void setEndFieldType(String string, Class clazz) {
        Enumeration enumeration = this.endFields.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            databaseField.setType(clazz);
        }
    }

    public void setShouldHandleWrites(boolean bl) {
        this.shouldHandleWrites = bl;
    }

    public boolean shouldHandleWrites() {
        return this.shouldHandleWrites;
    }

    public void setShouldUseDatabaseTime(boolean bl) {
        this.usesLocalTime = !bl;
    }

    public boolean shouldUseLocalTime() {
        return this.usesLocalTime;
    }

    public boolean shouldUseDatabaseTime() {
        return !this.usesLocalTime;
    }

    public void useLocalTime() {
        this.usesLocalTime = true;
    }

    public void useDatabaseTime() {
        this.usesLocalTime = false;
    }

    protected void verifyTableQualifiers(Platform platform) {
        String string = platform.getTableQualifier();
        if (string.length() == 0) {
            return;
        }
        Enumeration enumeration = this.getHistoricalTables().elements();
        while (enumeration.hasMoreElements()) {
            HistoricalDatabaseTable historicalDatabaseTable = (HistoricalDatabaseTable)enumeration.nextElement();
            DatabaseTable databaseTable = new DatabaseTable(historicalDatabaseTable.getQualifiedName());
            if (databaseTable.getTableQualifier().length() != 0) continue;
            databaseTable.setTableQualifier(string);
            historicalDatabaseTable.setHistoricalName(databaseTable.getQualifiedName());
        }
    }

    protected boolean checkWastedVersioning(AbstractRecord abstractRecord, DatabaseTable databaseTable) {
        Enumeration enumeration = abstractRecord.keys();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            if (!databaseField.getTable().equals(databaseTable) && databaseField.hasTableName()) continue;
            return true;
        }
        return false;
    }

    public void postDelete(ModifyQuery modifyQuery) {
        this.logicalDelete(modifyQuery, false);
    }

    public void postUpdate(ObjectLevelModifyQuery objectLevelModifyQuery) {
        this.logicalDelete(objectLevelModifyQuery, true);
        this.logicalInsert(objectLevelModifyQuery, true);
    }

    public void postInsert(ObjectLevelModifyQuery objectLevelModifyQuery) {
        this.logicalInsert(objectLevelModifyQuery, false);
    }

    public void logicalInsert(ObjectLevelModifyQuery objectLevelModifyQuery, boolean bl) {
        ClassDescriptor classDescriptor = this.getDescriptor();
        AbstractRecord abstractRecord = null;
        AbstractRecord abstractRecord2 = objectLevelModifyQuery.getModifyRow();
        Object object = null;
        if (bl) {
            abstractRecord = classDescriptor.getObjectBuilder().buildRow(objectLevelModifyQuery.getObject(), objectLevelModifyQuery.getSession());
            abstractRecord.putAll((Map)abstractRecord2);
        } else {
            abstractRecord = abstractRecord2;
            object = this.getCurrentTime(objectLevelModifyQuery.getSession());
        }
        StatementQueryMechanism statementQueryMechanism = new StatementQueryMechanism(objectLevelModifyQuery);
        for (int i = 0; i < this.getHistoricalTables().size(); ++i) {
            DatabaseTable databaseTable = (DatabaseTable)this.getHistoricalTables().elementAt(i);
            if (bl && !this.checkWastedVersioning(abstractRecord2, databaseTable)) continue;
            if (!bl) {
                abstractRecord.add(this.getStart(i), object);
            }
            SQLInsertStatement sQLInsertStatement = new SQLInsertStatement();
            sQLInsertStatement.setTable(databaseTable);
            statementQueryMechanism.getSQLStatements().add(sQLInsertStatement);
        }
        if (statementQueryMechanism.hasMultipleStatements()) {
            objectLevelModifyQuery.setTranslationRow(abstractRecord);
            objectLevelModifyQuery.setModifyRow(abstractRecord);
            statementQueryMechanism.insertObject();
        }
    }

    public void mappingLogicalInsert(DataModifyQuery dataModifyQuery, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        DataModifyQuery dataModifyQuery2 = new DataModifyQuery();
        SQLInsertStatement sQLInsertStatement = new SQLInsertStatement();
        DatabaseTable databaseTable = (DatabaseTable)this.getHistoricalTables().elementAt(0);
        sQLInsertStatement.setTable(databaseTable);
        AbstractRecord abstractRecord2 = (AbstractRecord)dataModifyQuery.getModifyRow().clone();
        AbstractRecord abstractRecord3 = (AbstractRecord)abstractRecord.clone();
        if (!abstractRecord2.containsKey(this.getStart())) {
            Object object = this.getCurrentTime(abstractSession);
            abstractRecord2.add(this.getStart(), object);
            abstractRecord3.add(this.getStart(), object);
        }
        dataModifyQuery2.setSQLStatement(sQLInsertStatement);
        dataModifyQuery2.setModifyRow(abstractRecord2);
        sQLInsertStatement.setModifyRow(abstractRecord2);
        abstractSession.executeQuery((DatabaseQuery)dataModifyQuery2, abstractRecord3);
    }

    public void logicalDelete(ModifyQuery modifyQuery, boolean bl) {
        ClassDescriptor classDescriptor = modifyQuery.getDescriptor();
        AbstractRecord abstractRecord = modifyQuery.getModifyRow();
        DatabaseRecord databaseRecord = new DatabaseRecord();
        StatementQueryMechanism statementQueryMechanism = new StatementQueryMechanism(modifyQuery);
        Object object = this.getCurrentTime(modifyQuery.getSession());
        for (int i = 0; i < this.getHistoricalTables().size(); ++i) {
            DatabaseTable databaseTable = (DatabaseTable)this.getHistoricalTables().elementAt(i);
            if (bl && !this.checkWastedVersioning(abstractRecord, databaseTable)) continue;
            SQLUpdateStatement sQLUpdateStatement = new SQLUpdateStatement();
            sQLUpdateStatement.setTable(databaseTable);
            Expression expression = null;
            if (modifyQuery instanceof DeleteAllQuery) {
                if (modifyQuery.getSelectionCriteria() != null) {
                    expression = (Expression)modifyQuery.getSelectionCriteria().clone();
                }
            } else {
                expression = classDescriptor.getObjectBuilder().buildPrimaryKeyExpression(databaseTable);
            }
            ExpressionBuilder expressionBuilder = expression == null ? new ExpressionBuilder() : expression.getBuilder();
            expression = expressionBuilder.getField(this.getEnd(i)).isNull().and(expression);
            sQLUpdateStatement.setWhereClause(expression);
            databaseRecord.add(this.getEnd(i), object);
            if (bl) {
                abstractRecord.add(this.getStart(i), object);
            }
            statementQueryMechanism.getSQLStatements().add(sQLUpdateStatement);
        }
        if (statementQueryMechanism.hasMultipleStatements()) {
            modifyQuery.setModifyRow(databaseRecord);
            statementQueryMechanism.updateObject();
            modifyQuery.setModifyRow(abstractRecord);
        }
    }

    public void mappingLogicalDelete(ModifyQuery modifyQuery, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        SQLDeleteStatement sQLDeleteStatement = (SQLDeleteStatement)modifyQuery.getSQLStatement();
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        SQLUpdateStatement sQLUpdateStatement = new SQLUpdateStatement();
        DatabaseTable databaseTable = (DatabaseTable)this.getHistoricalTables().elementAt(0);
        sQLUpdateStatement.setTable(databaseTable);
        Expression expression = (Expression)sQLDeleteStatement.getWhereClause().clone();
        DatabaseField databaseField = this.getEnd();
        expression = expression.getBuilder().getField(databaseField).isNull().and(expression);
        sQLUpdateStatement.setWhereClause(expression);
        DatabaseRecord databaseRecord = new DatabaseRecord();
        AbstractRecord abstractRecord2 = (AbstractRecord)abstractRecord.clone();
        Object object = this.getCurrentTime(abstractSession);
        databaseRecord.add(this.getEnd(), object);
        abstractRecord2.add(this.getEnd(), object);
        sQLUpdateStatement.setModifyRow(databaseRecord);
        dataModifyQuery.setSQLStatement(sQLUpdateStatement);
        dataModifyQuery.setModifyRow(databaseRecord);
        abstractSession.executeQuery((DatabaseQuery)dataModifyQuery, abstractRecord2);
    }
}

