/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;

public class OutputParameterForCallableStatement
extends BindCallCustomParameter {
    protected boolean isCursor;
    protected int jdbcType;
    protected String typeName;
    protected boolean isTypeNameRequired;

    public OutputParameterForCallableStatement(DatabaseField databaseField) {
        super(databaseField);
    }

    public OutputParameterForCallableStatement(DatabaseField databaseField, AbstractSession abstractSession) {
        this(databaseField, abstractSession, false);
    }

    public OutputParameterForCallableStatement(DatabaseField databaseField, AbstractSession abstractSession, boolean bl) {
        this(databaseField);
        this.isCursor = bl;
        this.prepare(abstractSession);
    }

    public OutputParameterForCallableStatement(OutputParameterForCallableStatement outputParameterForCallableStatement) {
        super(outputParameterForCallableStatement.obj);
        this.isCursor = outputParameterForCallableStatement.isCursor;
        this.jdbcType = outputParameterForCallableStatement.jdbcType;
        this.typeName = outputParameterForCallableStatement.typeName;
        this.isTypeNameRequired = outputParameterForCallableStatement.isTypeNameRequired;
    }

    protected OutputParameterForCallableStatement() {
    }

    public void setIsCursor(boolean bl) {
        this.isCursor = bl;
    }

    public boolean isCursor() {
        return this.isCursor;
    }

    public boolean isTypeNameRequired() {
        return this.isTypeNameRequired;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public DatabaseField getOutputField() {
        return (DatabaseField)this.obj;
    }

    public void prepare(AbstractSession abstractSession) {
        org.eclipse.persistence.platform.database.DatabasePlatform databasePlatform = abstractSession.getPlatform();
        if (this.isCursor()) {
            this.jdbcType = databasePlatform.getCursorCode();
        } else {
            this.jdbcType = databasePlatform.getJDBCType(this.getOutputField());
            if (this.obj instanceof ObjectRelationalDatabaseField) {
                this.isTypeNameRequired = true;
                this.typeName = ((ObjectRelationalDatabaseField)this.obj).getSqlTypeName();
            } else {
                this.isTypeNameRequired = databasePlatform.requiresTypeNameToRegisterOutputParameter();
                if (this.isTypeNameRequired) {
                    this.typeName = databasePlatform.getJdbcTypeName(this.jdbcType);
                }
            }
        }
    }

    public void set(DatabasePlatform databasePlatform, PreparedStatement preparedStatement, int n, AbstractSession abstractSession) throws SQLException {
        if (this.isTypeNameRequired) {
            ((CallableStatement)preparedStatement).registerOutParameter(n, this.jdbcType, this.typeName);
        } else {
            ((CallableStatement)preparedStatement).registerOutParameter(n, this.jdbcType);
        }
    }

    public String toString() {
        return "=> " + this.getOutputField().getName();
    }
}

