/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CascadeLockingPolicy {
    protected Class m_parentClass;
    protected ReadObjectQuery m_query;
    protected ClassDescriptor m_descriptor;
    protected ClassDescriptor m_parentDescriptor;
    protected Map<DatabaseField, DatabaseField> m_queryKeyFields;
    protected Map<DatabaseField, DatabaseField> m_mappedQueryKeyFields;
    protected Map<DatabaseField, DatabaseField> m_unmappedQueryKeyFields;
    protected DatabaseMapping m_parentMapping;
    protected boolean m_lookForParentMapping;
    protected boolean m_shouldHandleUnmappedFields;
    protected boolean m_hasCheckedForUnmappedFields;
    protected DataReadQuery m_unmappedFieldsQuery;

    public CascadeLockingPolicy(ClassDescriptor classDescriptor, ClassDescriptor classDescriptor2) {
        this.m_descriptor = classDescriptor2;
        this.m_parentDescriptor = classDescriptor;
        this.m_parentClass = this.m_parentDescriptor.getJavaClass();
    }

    protected ReadObjectQuery getQuery() {
        if (this.m_query == null) {
            this.m_query = new ReadObjectQuery(this.m_parentClass);
            Expression expression = null;
            Iterator<DatabaseField> iterator = this.m_queryKeyFields.keySet().iterator();
            ExpressionBuilder expressionBuilder = new ExpressionBuilder();
            while (iterator.hasNext()) {
                String string = iterator.next().getQualifiedName();
                if (expression == null) {
                    expression = expressionBuilder.getField(string).equal(expressionBuilder.getParameter(string));
                } else {
                    expression.and(expressionBuilder.getField(string).equal(expressionBuilder.getParameter(string)));
                }
                this.m_query.addArgument(string);
            }
            this.m_query.setSelectionCriteria(expression);
            this.m_query.setShouldUseWrapperPolicy(false);
        }
        return this.m_query;
    }

    protected DatabaseMapping getParentMapping() {
        if (this.m_parentMapping == null && this.m_lookForParentMapping && this.m_query == null) {
            Iterator<DatabaseField> iterator = this.m_queryKeyFields.values().iterator();
            while (iterator.hasNext()) {
                DatabaseMapping databaseMapping = this.m_descriptor.getObjectBuilder().getMappingForField(iterator.next());
                if (databaseMapping == null) {
                    this.m_parentMapping = null;
                    break;
                }
                if (!databaseMapping.isObjectReferenceMapping()) continue;
                if (this.m_parentMapping == null) {
                    this.m_parentMapping = databaseMapping;
                    continue;
                }
                if (this.m_parentMapping == databaseMapping) continue;
                this.m_parentMapping = null;
                break;
            }
        }
        return this.m_parentMapping;
    }

    protected ClassDescriptor getParentDescriptorFromInheritancePolicy(Object object) {
        InheritancePolicy inheritancePolicy;
        ClassDescriptor classDescriptor;
        ClassDescriptor classDescriptor2 = this.m_parentDescriptor;
        if (classDescriptor2.hasInheritance() && (classDescriptor = (inheritancePolicy = classDescriptor2.getInheritancePolicy()).getDescriptor(object.getClass())) != null) {
            classDescriptor2 = classDescriptor;
        }
        return classDescriptor2;
    }

    protected AbstractRecord getMappedTranslationRow(Object object, UnitOfWorkImpl unitOfWorkImpl) {
        DatabaseRecord databaseRecord = new DatabaseRecord();
        for (Map.Entry<DatabaseField, DatabaseField> entry : this.m_mappedQueryKeyFields.entrySet()) {
            Object object2 = this.m_descriptor.getObjectBuilder().extractValueFromObjectForField(object, entry.getValue(), unitOfWorkImpl);
            databaseRecord.add(entry.getKey(), object2);
        }
        return databaseRecord;
    }

    protected AbstractRecord getUnmappedTranslationRow(Object object, UnitOfWorkImpl unitOfWorkImpl) {
        Object object2;
        DatabaseRecord databaseRecord = new DatabaseRecord();
        for (DatabaseField object32 : this.m_descriptor.getPrimaryKeyFields()) {
            object2 = this.m_descriptor.getObjectBuilder().extractValueFromObjectForField(object, object32, unitOfWorkImpl);
            databaseRecord.add(object32, object2);
        }
        List list = (List)unitOfWorkImpl.executeQuery((DatabaseQuery)this.m_unmappedFieldsQuery, databaseRecord);
        if (list == null || list.isEmpty()) {
            return null;
        }
        object2 = (AbstractRecord)list.get(0);
        DatabaseRecord databaseRecord2 = new DatabaseRecord();
        for (Map.Entry<DatabaseField, DatabaseField> entry : this.m_unmappedQueryKeyFields.entrySet()) {
            Object object3 = ((AbstractRecord)object2).get(entry.getValue());
            databaseRecord2.add(entry.getKey(), object3);
        }
        return databaseRecord2;
    }

    public void initUnmappedFields(UnitOfWorkImpl unitOfWorkImpl) {
        if (!this.m_hasCheckedForUnmappedFields) {
            this.m_mappedQueryKeyFields = new HashMap<DatabaseField, DatabaseField>();
            this.m_unmappedQueryKeyFields = new HashMap<DatabaseField, DatabaseField>();
            for (Map.Entry<DatabaseField, DatabaseField> entry : this.m_queryKeyFields.entrySet()) {
                if (this.m_descriptor.getObjectBuilder().getMappingForField(entry.getValue()) == null) {
                    this.m_unmappedQueryKeyFields.put(entry.getKey(), entry.getValue());
                    continue;
                }
                this.m_mappedQueryKeyFields.put(entry.getKey(), entry.getValue());
            }
            if (this.m_unmappedQueryKeyFields.isEmpty()) {
                this.m_unmappedQueryKeyFields = null;
                this.m_mappedQueryKeyFields = this.m_queryKeyFields;
            }
            this.initUnmappedFieldsQuery(unitOfWorkImpl);
            this.m_hasCheckedForUnmappedFields = true;
        }
    }

    public void initUnmappedFieldsQuery(UnitOfWorkImpl unitOfWorkImpl) {
        if (this.m_unmappedFieldsQuery == null) {
            this.m_unmappedFieldsQuery = new DataReadQuery();
            Expression expression = null;
            ExpressionBuilder expressionBuilder = new ExpressionBuilder();
            for (DatabaseField cloneable2 : this.m_descriptor.getPrimaryKeyFields()) {
                Expression expression2 = ((Expression)expressionBuilder).getField(cloneable2).equal(expressionBuilder.getParameter(cloneable2));
                expression = expression2.and(expression);
                this.m_unmappedFieldsQuery.addArgument(cloneable2.getQualifiedName());
            }
            SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
            for (DatabaseField databaseField : this.m_unmappedQueryKeyFields.values()) {
                sQLSelectStatement.addField(databaseField);
            }
            sQLSelectStatement.setWhereClause(expression);
            sQLSelectStatement.normalize(unitOfWorkImpl.getParent(), this.m_descriptor);
            this.m_unmappedFieldsQuery.setSQLStatement(sQLSelectStatement);
            this.m_unmappedFieldsQuery.setSessionName(this.m_descriptor.getSessionName());
        }
    }

    public void lockNotifyParent(Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkImpl unitOfWorkImpl) {
        Cloneable cloneable;
        Object object2;
        Object object3 = null;
        DatabaseMapping databaseMapping = this.getParentMapping();
        if (databaseMapping != null && databaseMapping.isObjectReferenceMapping()) {
            object3 = databaseMapping.getRealAttributeValueFromObject(object, unitOfWorkImpl);
        }
        if (object3 == null) {
            if (this.m_shouldHandleUnmappedFields) {
                this.initUnmappedFields(unitOfWorkImpl);
                if (this.m_unmappedQueryKeyFields != null) {
                    object2 = this.getUnmappedTranslationRow(object, unitOfWorkImpl);
                    if (object2 == null) {
                        return;
                    }
                    cloneable = this.getMappedTranslationRow(object, unitOfWorkImpl);
                    ((AbstractRecord)cloneable).putAll((Map)object2);
                } else {
                    cloneable = this.getMappedTranslationRow(object, unitOfWorkImpl);
                }
            } else {
                cloneable = this.getMappedTranslationRow(object, unitOfWorkImpl);
            }
            object3 = unitOfWorkImpl.executeQuery((DatabaseQuery)this.getQuery(), (AbstractRecord)cloneable);
        } else if (this.m_parentDescriptor.hasWrapperPolicy()) {
            this.m_parentDescriptor.getWrapperPolicy().unwrapObject(object3, unitOfWorkImpl);
        }
        cloneable = this.m_parentDescriptor;
        if (object3 != null) {
            cloneable = this.getParentDescriptorFromInheritancePolicy(object3);
        }
        if (object3 != null) {
            if (((ClassDescriptor)cloneable).usesOptimisticLocking() && ((ClassDescriptor)cloneable).getOptimisticLockingPolicy().isCascaded() && !((ObjectChangeSet)(object2 = ((ClassDescriptor)cloneable).getObjectBuilder().createObjectChangeSet(object3, unitOfWorkChangeSet, unitOfWorkImpl))).hasForcedChangesFromCascadeLocking()) {
                ((ObjectChangeSet)object2).setHasForcedChangesFromCascadeLocking(true);
                unitOfWorkChangeSet.addObjectChangeSet((ObjectChangeSet)object2, unitOfWorkImpl, true);
            }
            if (((ClassDescriptor)cloneable).hasCascadeLockingPolicies()) {
                object2 = ((ClassDescriptor)cloneable).getCascadeLockingPolicies().elements();
                while (object2.hasMoreElements()) {
                    CascadeLockingPolicy cascadeLockingPolicy = (CascadeLockingPolicy)object2.nextElement();
                    cascadeLockingPolicy.lockNotifyParent(object3, unitOfWorkChangeSet, unitOfWorkImpl);
                }
            }
        }
    }

    public void setQueryKeyFields(Map<DatabaseField, DatabaseField> map) {
        this.setQueryKeyFields(map, true);
    }

    public void setQueryKeyFields(Map<DatabaseField, DatabaseField> map, boolean bl) {
        this.m_queryKeyFields = map;
        this.m_mappedQueryKeyFields = this.m_queryKeyFields;
        this.m_lookForParentMapping = bl;
    }

    public void setShouldHandleUnmappedFields(boolean bl) {
        this.m_shouldHandleUnmappedFields = bl;
    }

    public boolean shouldHandleUnmappedFields() {
        return this.m_shouldHandleUnmappedFields;
    }
}

