/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.internal.descriptors.FieldTransformation;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;

public class TransformerBasedFieldTransformation
extends FieldTransformation {
    protected Class transformerClass;
    protected String transformerClassName;
    protected FieldTransformer transformer;

    public TransformerBasedFieldTransformation() {
    }

    public TransformerBasedFieldTransformation(FieldTransformer fieldTransformer) {
        this.transformer = fieldTransformer;
        if (this.transformer != null) {
            this.setTransformerClass(this.transformer.getClass());
            this.setTransformerClassName(this.transformer.getClass().getName());
        }
    }

    public Class getTransformerClass() {
        return this.transformerClass;
    }

    public void setTransformerClass(Class clazz) {
        this.transformerClass = clazz;
    }

    public String getTransformerClassName() {
        return this.transformerClassName;
    }

    public void setTransformerClassName(String string) {
        this.transformerClassName = string;
    }

    public FieldTransformer buildTransformer() throws Exception {
        if (this.transformer == null) {
            Class clazz = this.getTransformerClass();
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    this.transformer = (FieldTransformer)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (Exception)privilegedActionException.getCause();
                }
            } else {
                this.transformer = (FieldTransformer)PrivilegedAccessHelper.newInstanceFromClass(clazz);
            }
        }
        return this.transformer;
    }
}

