/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;

public class ForUpdateClause
implements Serializable,
Cloneable {
    protected static final ForUpdateClause NO_LOCK_CLAUSE = new ForUpdateClause();
    short lockMode;
    Integer waitTimeout;

    public ForUpdateClause() {
        this.lockMode = 0;
    }

    public ForUpdateClause(short s) {
        this.lockMode = s;
    }

    public ForUpdateClause(Integer n) {
        this.lockMode = 1;
        this.waitTimeout = n;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static ForUpdateClause newInstance(short s) {
        if (s == 0) {
            return NO_LOCK_CLAUSE;
        }
        return new ForUpdateClause(s);
    }

    public static ForUpdateClause newInstance(Integer n) {
        return new ForUpdateClause(n);
    }

    public boolean isForUpdateOfClause() {
        return false;
    }

    public boolean isReferenceClassLocked() {
        return true;
    }

    public short getLockMode() {
        return this.lockMode;
    }

    public Integer getWaitTimeout() {
        return this.waitTimeout;
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter, SQLSelectStatement sQLSelectStatement) {
        if (this.getLockMode() == 1) {
            if (this.waitTimeout == null) {
                expressionSQLPrinter.printString(expressionSQLPrinter.getSession().getPlatform().getSelectForUpdateString());
            } else {
                expressionSQLPrinter.printString(expressionSQLPrinter.getSession().getPlatform().getSelectForUpdateWaitString(this.waitTimeout));
            }
        } else if (this.lockMode == 2) {
            expressionSQLPrinter.printString(expressionSQLPrinter.getSession().getPlatform().getSelectForUpdateNoWaitString());
        }
    }

    public Collection getAliasesOfTablesToBeLocked(SQLSelectStatement sQLSelectStatement) {
        return new HashSet(sQLSelectStatement.getTableAliases().keySet());
    }
}

