/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;

public class ForUpdateOfClause
extends ForUpdateClause {
    protected Vector lockedExpressions;

    public void addLockedExpression(ObjectExpression objectExpression) {
        this.getLockedExpressions().addElement(objectExpression);
    }

    public Vector getLockedExpressions() {
        if (this.lockedExpressions == null) {
            this.lockedExpressions = NonSynchronizedVector.newInstance();
        }
        return this.lockedExpressions;
    }

    public boolean isForUpdateOfClause() {
        return true;
    }

    public boolean isReferenceClassLocked() {
        if (this.lockedExpressions == null) {
            return false;
        }
        for (int i = 0; i < this.lockedExpressions.size(); ++i) {
            if (!((Expression)this.lockedExpressions.elementAt(i)).isExpressionBuilder()) continue;
            return true;
        }
        return false;
    }

    public void setLockedExpressions(Vector vector) {
        this.lockedExpressions = vector;
    }

    public void setLockMode(short s) {
        this.lockMode = s;
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter, SQLSelectStatement sQLSelectStatement) {
        if (expressionSQLPrinter.getSession().getPlatform().shouldPrintLockingClauseAfterWhereClause()) {
            ExpressionBuilder expressionBuilder = sQLSelectStatement.getBuilder();
            expressionSQLPrinter.printString(expressionSQLPrinter.getSession().getPlatform().getSelectForUpdateOfString());
            expressionSQLPrinter.setIsFirstElementPrinted(false);
            Enumeration enumeration = this.getLockedExpressions().elements();
            while (enumeration.hasMoreElements()) {
                ObjectExpression objectExpression = (ObjectExpression)enumeration.nextElement();
                objectExpression = (ObjectExpression)objectExpression.rebuildOn(expressionBuilder);
                objectExpression.writeForUpdateOfFields(expressionSQLPrinter, sQLSelectStatement);
            }
            if (this.lockMode == 2) {
                expressionSQLPrinter.printString(expressionSQLPrinter.getSession().getPlatform().getNoWaitString());
            }
        } else {
            super.printSQL(expressionSQLPrinter, sQLSelectStatement);
        }
    }

    public Collection getAliasesOfTablesToBeLocked(SQLSelectStatement sQLSelectStatement) {
        int n = sQLSelectStatement.getTableAliases().size();
        HashSet<DatabaseTable> hashSet = new HashSet<DatabaseTable>(n);
        ExpressionBuilder expressionBuilder = sQLSelectStatement.getBuilder();
        Enumeration enumeration = this.getLockedExpressions().elements();
        while (enumeration.hasMoreElements() && hashSet.size() < n) {
            ObjectExpression objectExpression = (ObjectExpression)enumeration.nextElement();
            objectExpression = (ObjectExpression)objectExpression.rebuildOn(expressionBuilder);
            DatabaseTable[] databaseTableArray = objectExpression.getTableAliases().keys();
            for (int i = 0; i < databaseTableArray.length; ++i) {
                hashSet.add(databaseTableArray[i]);
            }
        }
        return hashSet;
    }
}

