/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.CompoundExpression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.expressions.TableAliasLookup;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.history.DecoratedDatabaseTable;
import org.eclipse.persistence.internal.history.UniversalAsOfClause;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.platform.database.DB2MainframePlatform;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.SQLCall;

public class SQLSelectStatement
extends SQLStatement {
    protected ReadQuery query;
    protected boolean useUniqueFieldAliases = false;
    protected int fieldCounter = 0;
    protected Vector fields = NonSynchronizedVector.newInstance(2);
    protected Vector nonSelectFields;
    protected Vector tables = NonSynchronizedVector.newInstance(4);
    protected short distinctState = 0;
    protected Vector orderByExpressions;
    protected Vector groupByExpressions;
    protected Expression havingExpression;
    protected ForUpdateClause forUpdateClause;
    protected boolean isAggregateSelect = false;
    protected Vector outerJoinedExpressions;
    protected Vector outerJoinedMappingCriteria;
    protected Vector outerJoinedAdditionalJoinCriteria;
    protected List descriptorsForMultitableInheritanceOnly;
    protected Expression startWithExpression;
    protected Expression connectByExpression;
    protected Vector orderSiblingsByExpressions;
    protected boolean requiresAliases = false;
    protected Hashtable tableAliases;
    protected DatabaseTable lastTable;
    protected DatabaseTable currentAlias;
    protected int currentAliasNumber = 0;
    protected SQLSelectStatement parentStatement;

    public void addField(DatabaseField databaseField) {
        this.getFields().addElement(databaseField);
    }

    public void addField(Expression expression) {
        if (expression instanceof FunctionExpression && ((FunctionExpression)expression).getOperator().isAggregateOperator()) {
            this.setIsAggregateSelect(true);
        }
        this.getFields().addElement(expression);
    }

    protected void addOrderByExpressionToSelectForDistinct() {
        Enumeration enumeration = this.getOrderByExpressions().elements();
        while (enumeration.hasMoreElements()) {
            Expression expression = (Expression)enumeration.nextElement();
            Expression expression2 = null;
            expression2 = expression.isFunctionExpression() && expression.getOperator().isOrderOperator() ? ((FunctionExpression)expression).getBaseExpression() : expression;
            if (!expression2.selectIfOrderedBy() || this.fieldsContainField(this.getFields(), expression2)) continue;
            this.addField(expression2);
        }
    }

    public void addTable(DatabaseTable databaseTable) {
        if (!this.getTables().contains(databaseTable)) {
            this.getTables().addElement(databaseTable);
        }
    }

    public void appendFromClauseForInformixOuterJoin(ExpressionSQLPrinter expressionSQLPrinter, Vector vector) throws IOException {
        Writer writer = expressionSQLPrinter.getWriter();
        AbstractSession abstractSession = expressionSQLPrinter.getSession();
        boolean bl = true;
        for (int i = 0; i < this.getOuterJoinExpressions().size(); ++i) {
            DatabaseTable databaseTable;
            Object object;
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)this.getOuterJoinExpressions().elementAt(i);
            CompoundExpression compoundExpression = (CompoundExpression)this.getOuterJoinedMappingCriteria().elementAt(i);
            DatabaseTable databaseTable2 = null;
            databaseTable2 = queryKeyExpression.getMapping().isDirectCollectionMapping() ? ((DirectCollectionMapping)queryKeyExpression.getMapping()).getReferenceTable() : queryKeyExpression.getMapping().getReferenceDescriptor().getTables().firstElement();
            DatabaseTable databaseTable3 = queryKeyExpression.getMapping().isObjectReferenceMapping() && ((ObjectReferenceMapping)queryKeyExpression.getMapping()).isForeignKeyRelationship() ? queryKeyExpression.getMapping().getFields().firstElement().getTable() : ((ObjectExpression)queryKeyExpression.getBaseExpression()).getDescriptor().getTables().firstElement();
            DatabaseTable databaseTable4 = queryKeyExpression.getBaseExpression().aliasForTable(databaseTable3);
            DatabaseTable databaseTable5 = queryKeyExpression.aliasForTable(databaseTable2);
            if (vector.contains(databaseTable4) || vector.contains(databaseTable5)) continue;
            if (!bl) {
                writer.write(", ");
            }
            bl = false;
            writer.write(databaseTable3.getQualifiedName());
            vector.addElement(databaseTable4);
            writer.write(" ");
            writer.write(databaseTable4.getQualifiedName());
            if (queryKeyExpression.getMapping().isManyToManyMapping()) {
                object = ((ManyToManyMapping)queryKeyExpression.getMapping()).getRelationTable();
                databaseTable = compoundExpression.aliasForTable((DatabaseTable)object);
                writer.write(", OUTER ");
                writer.write(((DatabaseTable)object).getQualifiedName());
                writer.write(" ");
                vector.addElement(databaseTable);
                writer.write(databaseTable.getQualifiedName());
                continue;
            }
            if (queryKeyExpression.getMapping().isDirectCollectionMapping()) {
                object = ((DirectCollectionMapping)queryKeyExpression.getMapping()).getReferenceTable();
                databaseTable = compoundExpression.aliasForTable((DatabaseTable)object);
                writer.write(", OUTER ");
                writer.write(((DatabaseTable)object).getQualifiedName());
                writer.write(" ");
                vector.addElement(databaseTable);
                writer.write(databaseTable.getQualifiedName());
                continue;
            }
            object = queryKeyExpression.getMapping().getReferenceDescriptor().getTables().elements();
            while (object.hasMoreElements()) {
                databaseTable = (DatabaseTable)object.nextElement();
                QueryKeyExpression queryKeyExpression2 = queryKeyExpression;
                DatabaseTable databaseTable6 = queryKeyExpression.aliasForTable(databaseTable);
                writer.write(", OUTER ");
                writer.write(databaseTable.getQualifiedName());
                writer.write(" ");
                vector.addElement(databaseTable6);
                writer.write(databaseTable6.getQualifiedName());
            }
        }
    }

    public void appendFromClauseForOuterJoin(ExpressionSQLPrinter expressionSQLPrinter, Vector vector) throws IOException {
        Cloneable cloneable;
        DatabaseTable databaseTable;
        DatabaseTable databaseTable2;
        Cloneable cloneable2;
        Writer writer = expressionSQLPrinter.getWriter();
        AbstractSession abstractSession = expressionSQLPrinter.getSession();
        boolean bl = true;
        boolean bl2 = false;
        OuterJoinExpressionHolders outerJoinExpressionHolders = new OuterJoinExpressionHolders();
        for (int i = 0; i < this.getOuterJoinExpressions().size(); ++i) {
            Object object = (QueryKeyExpression)this.getOuterJoinExpressions().elementAt(i);
            cloneable2 = null;
            DatabaseTable databaseTable3 = null;
            databaseTable2 = null;
            databaseTable = null;
            if (object != null) {
                cloneable2 = ((QueryKeyExpression)object).getReferenceTable();
                databaseTable3 = ((QueryKeyExpression)object).getSourceTable();
                databaseTable2 = ((BaseExpression)object).getBaseExpression().aliasForTable(databaseTable3);
                databaseTable = ((QueryKeyExpression)object).aliasForTable((DatabaseTable)cloneable2);
            } else {
                databaseTable3 = ((ClassDescriptor)this.getDescriptorsForMultitableInheritanceOnly().get(i)).getTables().firstElement();
                cloneable2 = (DatabaseTable)((ClassDescriptor)this.getDescriptorsForMultitableInheritanceOnly().get(i)).getInheritancePolicy().getChildrenTables().get(0);
                cloneable = (Expression)((Map)this.getOuterJoinedAdditionalJoinCriteria().elementAt(i)).get(cloneable2);
                databaseTable2 = ((Expression)cloneable).aliasForTable(databaseTable3);
                databaseTable = ((Expression)cloneable).aliasForTable((DatabaseTable)cloneable2);
            }
            outerJoinExpressionHolders.add(new OuterJoinExpressionHolder((QueryKeyExpression)object, i, (DatabaseTable)cloneable2, databaseTable3, databaseTable, databaseTable2));
        }
        for (Object object : outerJoinExpressionHolders.linearize(this)) {
            boolean bl3;
            Cloneable cloneable3;
            Object object2;
            cloneable2 = ((OuterJoinExpressionHolder)object).joinExpression;
            int n = ((OuterJoinExpressionHolder)object).index;
            databaseTable2 = ((OuterJoinExpressionHolder)object).targetTable;
            databaseTable = ((OuterJoinExpressionHolder)object).sourceTable;
            cloneable = ((OuterJoinExpressionHolder)object).sourceAlias;
            DatabaseTable databaseTable4 = ((OuterJoinExpressionHolder)object).targetAlias;
            if (vector.contains(databaseTable4)) continue;
            if (!vector.contains(cloneable)) {
                if (bl2 && abstractSession.getPlatform().shouldUseJDBCOuterJoinSyntax()) {
                    writer.write("}");
                }
                if (!bl) {
                    writer.write(",");
                }
                if (abstractSession.getPlatform().shouldUseJDBCOuterJoinSyntax()) {
                    writer.write(abstractSession.getPlatform().getJDBCOuterJoinString());
                }
                bl2 = true;
                bl = false;
                writer.write(databaseTable.getQualifiedName());
                vector.addElement(cloneable);
                writer.write(" ");
                writer.write(((DatabaseTable)cloneable).getQualifiedName());
            }
            if (cloneable2 == null) {
                this.printAdditionalJoins(expressionSQLPrinter, vector, (ClassDescriptor)this.getDescriptorsForMultitableInheritanceOnly().get(n), (Map)this.getOuterJoinedAdditionalJoinCriteria().elementAt(n));
                continue;
            }
            if (((QueryKeyExpression)cloneable2).isDirectCollection()) {
                object2 = (Expression)this.getOuterJoinedMappingCriteria().elementAt(n);
                DatabaseTable databaseTable5 = ((Expression)object2).aliasForTable(databaseTable2);
                writer.write(" LEFT OUTER JOIN ");
                writer.write(databaseTable2.getQualifiedName());
                writer.write(" ");
                vector.addElement(databaseTable5);
                writer.write(databaseTable5.getQualifiedName());
                writer.write(" ON ");
                if (abstractSession.getPlatform() instanceof DB2MainframePlatform) {
                    ((RelationExpression)object2).printSQLNoParens(expressionSQLPrinter);
                    continue;
                }
                ((Expression)object2).printSQL(expressionSQLPrinter);
                continue;
            }
            if (((QueryKeyExpression)cloneable2).isManyToMany()) {
                object2 = ((QueryKeyExpression)cloneable2).getRelationTable();
                DatabaseTable databaseTable6 = ((Expression)this.getOuterJoinedMappingCriteria().elementAt(n)).aliasForTable((DatabaseTable)object2);
                writer.write(" LEFT OUTER JOIN (");
                writer.write(((DatabaseTable)object2).getQualifiedName());
                writer.write(" ");
                vector.addElement(databaseTable6);
                writer.write(databaseTable6.getQualifiedName());
                cloneable3 = NonSynchronizedVector.newInstance(3);
                ((Vector)cloneable3).add(cloneable);
                ((Vector)cloneable3).add(databaseTable6);
                ((Vector)cloneable3).add(databaseTable4);
                TreeMap treeMap = new TreeMap();
                SQLSelectStatement.mapTableIndexToExpression((Expression)this.getOuterJoinedMappingCriteria().elementAt(n), treeMap, (Vector)cloneable3);
                Expression expression = (Expression)treeMap.get(new Integer(1));
                Expression expression2 = (Expression)treeMap.get(new Integer(2));
                writer.write(" JOIN ");
                writer.write(databaseTable2.getQualifiedName());
                writer.write(" ");
                vector.addElement(databaseTable4);
                writer.write(databaseTable4.getQualifiedName());
                writer.write(" ON ");
                if (abstractSession.getPlatform() instanceof DB2MainframePlatform) {
                    ((RelationExpression)expression2).printSQLNoParens(expressionSQLPrinter);
                } else {
                    expression2.printSQL(expressionSQLPrinter);
                }
                Map map = (Map)this.getOuterJoinedAdditionalJoinCriteria().elementAt(n);
                if (map != null && !map.isEmpty()) {
                    this.printAdditionalJoins(expressionSQLPrinter, vector, ((ObjectExpression)cloneable2).getDescriptor(), map);
                }
                writer.write(") ON ");
                if (abstractSession.getPlatform() instanceof DB2MainframePlatform) {
                    ((RelationExpression)expression).printSQLNoParens(expressionSQLPrinter);
                    continue;
                }
                expression.printSQL(expressionSQLPrinter);
                continue;
            }
            writer.write(" LEFT OUTER JOIN ");
            object2 = (Map)this.getOuterJoinedAdditionalJoinCriteria().elementAt(n);
            boolean bl4 = bl3 = object2 != null && !object2.isEmpty();
            if (bl3) {
                writer.write("(");
            }
            writer.write(databaseTable2.getQualifiedName());
            writer.write(" ");
            vector.addElement(databaseTable4);
            writer.write(databaseTable4.getQualifiedName());
            if (bl3) {
                this.printAdditionalJoins(expressionSQLPrinter, vector, ((ObjectExpression)cloneable2).getDescriptor(), (Map)object2);
                writer.write(")");
            }
            writer.write(" ON ");
            cloneable3 = (Expression)this.getOuterJoinedMappingCriteria().elementAt(n);
            if (abstractSession.getPlatform() instanceof DB2MainframePlatform) {
                ((RelationExpression)cloneable3).printSQLNoParens(expressionSQLPrinter);
                continue;
            }
            ((Expression)cloneable3).printSQL(expressionSQLPrinter);
        }
        if (bl2 && abstractSession.getPlatform().shouldUseJDBCOuterJoinSyntax()) {
            writer.write("}");
        }
    }

    protected void printAdditionalJoins(ExpressionSQLPrinter expressionSQLPrinter, Vector vector, ClassDescriptor classDescriptor, Map map) throws IOException {
        Writer writer = expressionSQLPrinter.getWriter();
        AbstractSession abstractSession = expressionSQLPrinter.getSession();
        Vector vector2 = classDescriptor.getTables();
        int n = vector2.size();
        Vector vector3 = classDescriptor.hasInheritance() ? classDescriptor.getInheritancePolicy().getAllTables() : vector2;
        int n2 = vector3.size();
        for (int i = 1; i < n2; ++i) {
            DatabaseTable databaseTable = (DatabaseTable)vector3.elementAt(i);
            Expression expression = (Expression)map.get(databaseTable);
            if (expression == null) continue;
            if (i < n) {
                writer.write(" JOIN ");
            } else {
                writer.write(" LEFT OUTER JOIN ");
            }
            writer.write(databaseTable.getQualifiedName());
            writer.write(" ");
            DatabaseTable databaseTable2 = expression.aliasForTable(databaseTable);
            vector.addElement(databaseTable2);
            writer.write(databaseTable2.getQualifiedName());
            writer.write(" ON ");
            if (abstractSession.getPlatform() instanceof DB2MainframePlatform) {
                ((RelationExpression)expression).printSQLNoParens(expressionSQLPrinter);
                continue;
            }
            expression.printSQL(expressionSQLPrinter);
        }
    }

    public void appendFromClauseToWriter(ExpressionSQLPrinter expressionSQLPrinter) throws IOException {
        Writer writer = expressionSQLPrinter.getWriter();
        AbstractSession abstractSession = expressionSQLPrinter.getSession();
        writer.write(" FROM ");
        boolean bl = true;
        Vector vector = new Vector(1);
        if (this.hasOuterJoinExpressions()) {
            if (abstractSession.getPlatform().isInformixOuterJoin()) {
                this.appendFromClauseForInformixOuterJoin(expressionSQLPrinter, vector);
            } else if (!abstractSession.getPlatform().shouldPrintOuterJoinInWhereClause()) {
                this.appendFromClauseForOuterJoin(expressionSQLPrinter, vector);
            }
            bl = false;
        }
        if (this.getTableAliases().isEmpty()) {
            throw QueryException.invalidBuilderInQuery(null);
        }
        boolean bl2 = !expressionSQLPrinter.getPlatform().shouldPrintLockingClauseAfterWhereClause() && this.getForUpdateClause() != null;
        Collection collection = null;
        boolean bl3 = false;
        if (bl2) {
            collection = this.getForUpdateClause().getAliasesOfTablesToBeLocked(this);
            bl3 = collection.size() == this.getTableAliases().size();
        }
        Enumeration enumeration = this.getTableAliases().keys();
        while (enumeration.hasMoreElements()) {
            DatabaseTable databaseTable = (DatabaseTable)enumeration.nextElement();
            if (vector.contains(databaseTable)) continue;
            DatabaseTable databaseTable2 = (DatabaseTable)this.getTableAliases().get(databaseTable);
            if (this.requiresAliases()) {
                if (!bl) {
                    writer.write(", ");
                }
                bl = false;
                writer.write(databaseTable2.getQualifiedName());
                writer.write(" ");
                if (databaseTable.isDecorated()) {
                    ((DecoratedDatabaseTable)databaseTable).getAsOfClause().printSQL(expressionSQLPrinter);
                    writer.write(" ");
                }
                writer.write(databaseTable.getQualifiedName());
            } else {
                writer.write(databaseTable2.getQualifiedName());
                if (databaseTable.isDecorated()) {
                    writer.write(" ");
                    ((DecoratedDatabaseTable)databaseTable).getAsOfClause().printSQL(expressionSQLPrinter);
                }
            }
            if (!bl2 || !bl3 && !collection.remove(databaseTable)) continue;
            this.getForUpdateClause().printSQL(expressionSQLPrinter, this);
        }
    }

    public void appendGroupByClauseToWriter(ExpressionSQLPrinter expressionSQLPrinter) throws IOException {
        if (this.getGroupByExpressions().isEmpty()) {
            return;
        }
        expressionSQLPrinter.getWriter().write(" GROUP BY ");
        Vector vector = new Vector();
        expressionSQLPrinter.setIsFirstElementPrinted(false);
        Enumeration enumeration = this.getGroupByExpressions().elements();
        while (enumeration.hasMoreElements()) {
            Expression expression = (Expression)enumeration.nextElement();
            this.writeFieldsFromExpression(expressionSQLPrinter, expression, vector);
        }
    }

    public void appendHierarchicalQueryClauseToWriter(ExpressionSQLPrinter expressionSQLPrinter) throws IOException {
        Cloneable cloneable;
        Object object;
        Expression expression = this.getStartWithExpression();
        Expression expression2 = this.getConnectByExpression();
        Vector vector = this.getOrderSiblingsByExpressions();
        if (expression != null) {
            expressionSQLPrinter.getWriter().write(" START WITH ");
            expression.printSQL(expressionSQLPrinter);
        }
        if (expression2 != null) {
            Cloneable cloneable2;
            if (!expression2.isQueryKeyExpression()) {
                throw QueryException.illFormedExpression(expression2);
            }
            expressionSQLPrinter.getWriter().write(" CONNECT BY ");
            object = ((QueryKeyExpression)expression2).getMapping();
            cloneable = ((DatabaseMapping)object).getDescriptor();
            Map<DatabaseField, DatabaseField> map = null;
            if (((DatabaseMapping)object).isOneToManyMapping()) {
                cloneable2 = (OneToManyMapping)object;
                map = ((OneToManyMapping)cloneable2).getTargetForeignKeyToSourceKeys();
            } else if (((DatabaseMapping)object).isOneToOneMapping()) {
                cloneable2 = (OneToOneMapping)object;
                map = ((OneToOneMapping)cloneable2).getSourceToTargetKeyFields();
            } else if (((DatabaseMapping)object).isAggregateCollectionMapping()) {
                cloneable2 = (AggregateCollectionMapping)object;
                map = ((AggregateCollectionMapping)cloneable2).getTargetForeignKeyToSourceKeys();
            } else {
                throw QueryException.invalidQueryKeyInExpression(expression2);
            }
            cloneable2 = ((ClassDescriptor)cloneable).getDefaultTable();
            String string = "";
            string = this.requiresAliases() ? this.getBuilder().aliasForTable((DatabaseTable)cloneable2).getName() : ((DatabaseTable)cloneable2).getName();
            if (map != null && !map.isEmpty()) {
                Iterator<DatabaseField> iterator = map.keySet().iterator();
                if (map.size() > 1) {
                    expressionSQLPrinter.getWriter().write("((");
                }
                DatabaseField databaseField = iterator.next();
                DatabaseField databaseField2 = map.get(databaseField);
                if (((DatabaseMapping)object).isOneToOneMapping()) {
                    expressionSQLPrinter.getWriter().write("PRIOR " + string + "." + databaseField.getName());
                    expressionSQLPrinter.getWriter().write(" = " + string + "." + databaseField2.getName());
                } else {
                    expressionSQLPrinter.getWriter().write(string + "." + databaseField.getName());
                    expressionSQLPrinter.getWriter().write(" = PRIOR " + string + "." + databaseField2.getName());
                }
                while (iterator.hasNext()) {
                    expressionSQLPrinter.getWriter().write(") AND (");
                    databaseField = iterator.next();
                    databaseField2 = map.get(databaseField);
                    if (((DatabaseMapping)object).isOneToOneMapping()) {
                        expressionSQLPrinter.getWriter().write("PRIOR " + string + "." + databaseField.getName());
                        expressionSQLPrinter.getWriter().write(" = " + string + "." + databaseField2.getName());
                        continue;
                    }
                    expressionSQLPrinter.getWriter().write(string + "." + databaseField.getName());
                    expressionSQLPrinter.getWriter().write(" = PRIOR " + string + "." + databaseField2.getName());
                }
                if (map.size() > 1) {
                    expressionSQLPrinter.getWriter().write("))");
                }
            }
        }
        if (vector != null) {
            expressionSQLPrinter.getWriter().write(" ORDER SIBLINGS BY ");
            object = vector.elements();
            while (object.hasMoreElements()) {
                cloneable = (Expression)object.nextElement();
                ((Expression)cloneable).printSQL(expressionSQLPrinter);
                if (!object.hasMoreElements()) continue;
                expressionSQLPrinter.getWriter().write(", ");
            }
        }
    }

    public void appendOrderClauseToWriter(ExpressionSQLPrinter expressionSQLPrinter) throws IOException {
        if (!this.hasOrderByExpressions()) {
            return;
        }
        expressionSQLPrinter.getWriter().write(" ORDER BY ");
        Enumeration enumeration = this.getOrderByExpressions().elements();
        while (enumeration.hasMoreElements()) {
            Expression expression = (Expression)enumeration.nextElement();
            expression.printSQL(expressionSQLPrinter);
            if (!enumeration.hasMoreElements()) continue;
            expressionSQLPrinter.getWriter().write(", ");
        }
    }

    public void assignAliases(Vector vector) {
        this.currentAliasNumber = this.getCurrentAliasNumber();
        ExpressionIterator expressionIterator = new ExpressionIterator(){

            public void iterate(Expression expression) {
                SQLSelectStatement.this.currentAliasNumber = expression.assignTableAliasesStartingAt(SQLSelectStatement.this.currentAliasNumber);
            }
        };
        if (vector.isEmpty()) {
            if (this.getBuilder() != null && this.requiresAliases()) {
                this.getBuilder().assignTableAliasesStartingAt(this.currentAliasNumber);
            }
        } else {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Expression expression = (Expression)enumeration.nextElement();
                expressionIterator.iterateOn(expression);
            }
        }
        this.setCurrentAliasNumber(this.currentAliasNumber);
    }

    public DatabaseCall buildCall(AbstractSession abstractSession) {
        SQLCall sQLCall = new SQLCall();
        sQLCall.returnManyRows();
        CharArrayWriter charArrayWriter = new CharArrayWriter(200);
        ExpressionSQLPrinter expressionSQLPrinter = new ExpressionSQLPrinter(abstractSession, this.getTranslationRow(), sQLCall, this.requiresAliases(), this.getBuilder());
        expressionSQLPrinter.setWriter(charArrayWriter);
        abstractSession.getPlatform().printSQLSelectStatement(sQLCall, expressionSQLPrinter, this);
        sQLCall.setSQLString(((Object)charArrayWriter).toString());
        return sQLCall;
    }

    public void computeDistinct() {
        ExpressionIterator expressionIterator = new ExpressionIterator(){

            public void iterate(Expression expression) {
                if (expression.isQueryKeyExpression() && ((QueryKeyExpression)expression).shouldQueryToManyRelationship() && !SQLSelectStatement.this.isDistinctComputed()) {
                    SQLSelectStatement.this.useDistinct();
                }
            }
        };
        if (this.getWhereClause() != null) {
            expressionIterator.iterateOn(this.getWhereClause());
        }
    }

    public boolean isSubSelect() {
        return this.getParentStatement() != null;
    }

    public void computeTables() {
        Object object3;
        Object object2;
        ExpressionIterator expressionIterator = new ExpressionIterator(){

            public void iterate(Expression expression) {
                TableAliasLookup tableAliasLookup = expression.getTableAliases();
                if (tableAliasLookup != null && !tableAliasLookup.haveBeenAddedToStatement()) {
                    tableAliasLookup.addToHashtable((Hashtable)this.getResult());
                    tableAliasLookup.setHaveBeenAddedToStatement(true);
                }
            }
        };
        expressionIterator.setResult(new Hashtable(5));
        if (this.getWhereClause() != null) {
            expressionIterator.iterateOn(this.getWhereClause());
        } else if (this.hasOuterJoinExpressions() && (object2 = (Expression)this.getOuterJoinedMappingCriteria().firstElement()) != null) {
            expressionIterator.iterateOn((Expression)object2);
        }
        for (Object object3 : this.getFields()) {
            if (!(object3 instanceof Expression)) continue;
            expressionIterator.iterateOn((Expression)object3);
        }
        expressionIterator.iterateOn(this.getBuilder());
        object2 = (Hashtable)expressionIterator.getResult();
        this.setTableAliases((Hashtable)object2);
        object3 = ((Hashtable)object2).elements();
        while (object3.hasMoreElements()) {
            this.addTable((DatabaseTable)object3.nextElement());
        }
    }

    public void computeTablesFromTables() {
        Hashtable<DecoratedDatabaseTable, DatabaseTable> hashtable = new Hashtable<DecoratedDatabaseTable, DatabaseTable>();
        AsOfClause asOfClause = null;
        if (this.getBuilder().hasAsOfClause() && !this.getBuilder().getSession().getProject().hasGenericHistorySupport()) {
            asOfClause = this.getBuilder().getAsOfClause();
        }
        for (int i = 0; i < this.getTables().size(); ++i) {
            DatabaseTable databaseTable = (DatabaseTable)this.getTables().elementAt(i);
            DecoratedDatabaseTable decoratedDatabaseTable = new DecoratedDatabaseTable("t" + i, asOfClause);
            hashtable.put(decoratedDatabaseTable, databaseTable);
        }
        this.setTableAliases(hashtable);
    }

    public void dontUseDistinct() {
        this.setDistinctState((short)2);
    }

    protected boolean fieldsContainField(Vector vector, Expression expression) {
        if (!(expression instanceof DataExpression)) {
            return false;
        }
        DatabaseField databaseField = ((DataExpression)expression).getField();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Cloneable cloneable;
            Cloneable cloneable2;
            Object e = enumeration.nextElement();
            if (e instanceof DatabaseField) {
                cloneable2 = (DatabaseField)e;
                cloneable = (DataExpression)expression;
                if (!((DatabaseField)cloneable2).equals(databaseField) || ((BaseExpression)cloneable).getBaseExpression() != this.getBuilder()) continue;
                return true;
            }
            cloneable2 = (Expression)e;
            cloneable = databaseField.getTable();
            if (!((Expression)cloneable2).getFields().contains(databaseField) || !expression.aliasForTable((DatabaseTable)cloneable).equals(((Expression)cloneable2).aliasForTable((DatabaseTable)cloneable))) continue;
            return true;
        }
        return false;
    }

    public int getCurrentAliasNumber() {
        if (this.getParentStatement() != null) {
            return this.getParentStatement().getCurrentAliasNumber();
        }
        return this.currentAliasNumber;
    }

    public Vector getFields() {
        return this.fields;
    }

    protected ForUpdateClause getForUpdateClause() {
        return this.forUpdateClause;
    }

    public Vector getGroupByExpressions() {
        if (this.groupByExpressions == null) {
            this.groupByExpressions = NonSynchronizedVector.newInstance(3);
        }
        return this.groupByExpressions;
    }

    public Expression getHavingExpression() {
        return this.havingExpression;
    }

    public ReadQuery getQuery() {
        return this.query;
    }

    public Expression getStartWithExpression() {
        return this.startWithExpression;
    }

    public Expression getConnectByExpression() {
        return this.connectByExpression;
    }

    public Vector getOrderSiblingsByExpressions() {
        return this.orderSiblingsByExpressions;
    }

    public int getNextFieldCounterValue() {
        return ++this.fieldCounter;
    }

    public Vector getNonSelectFields() {
        return this.nonSelectFields;
    }

    public Vector getOrderByExpressions() {
        if (this.orderByExpressions == null) {
            this.orderByExpressions = NonSynchronizedVector.newInstance(3);
        }
        return this.orderByExpressions;
    }

    public Vector getOuterJoinedAdditionalJoinCriteria() {
        if (this.outerJoinedAdditionalJoinCriteria == null) {
            this.outerJoinedAdditionalJoinCriteria = NonSynchronizedVector.newInstance(3);
        }
        return this.outerJoinedAdditionalJoinCriteria;
    }

    public Vector getOuterJoinedMappingCriteria() {
        if (this.outerJoinedMappingCriteria == null) {
            this.outerJoinedMappingCriteria = NonSynchronizedVector.newInstance(3);
        }
        return this.outerJoinedMappingCriteria;
    }

    public Vector getOuterJoinExpressions() {
        if (this.outerJoinedExpressions == null) {
            this.outerJoinedExpressions = NonSynchronizedVector.newInstance(3);
        }
        return this.outerJoinedExpressions;
    }

    public List getDescriptorsForMultitableInheritanceOnly() {
        if (this.descriptorsForMultitableInheritanceOnly == null) {
            this.descriptorsForMultitableInheritanceOnly = new ArrayList(3);
        }
        return this.descriptorsForMultitableInheritanceOnly;
    }

    public SQLSelectStatement getParentStatement() {
        return this.parentStatement;
    }

    public Hashtable getTableAliases() {
        return this.tableAliases;
    }

    public Vector getTables() {
        return this.tables;
    }

    public boolean getUseUniqueFieldAliases() {
        return this.useUniqueFieldAliases;
    }

    protected boolean hasAliasForTable(DatabaseTable databaseTable) {
        if (this.tableAliases != null) {
            return this.getTableAliases().containsKey(databaseTable);
        }
        return false;
    }

    public boolean hasGroupByExpressions() {
        return this.groupByExpressions != null && !this.groupByExpressions.isEmpty();
    }

    public boolean hasHavingExpression() {
        return this.havingExpression != null;
    }

    public boolean hasStartWithExpression() {
        return this.startWithExpression != null;
    }

    public boolean hasConnectByExpression() {
        return this.connectByExpression != null;
    }

    public boolean hasOrderSiblingsByExpressions() {
        return this.orderSiblingsByExpressions != null;
    }

    public boolean hasHierarchicalQueryExpressions() {
        return this.startWithExpression != null || this.connectByExpression != null || this.orderSiblingsByExpressions != null;
    }

    public boolean hasOrderByExpressions() {
        return this.orderByExpressions != null && !this.orderByExpressions.isEmpty();
    }

    public boolean hasNonSelectFields() {
        return this.nonSelectFields != null && !this.nonSelectFields.isEmpty();
    }

    public boolean hasOuterJoinedAdditionalJoinCriteria() {
        return this.outerJoinedAdditionalJoinCriteria != null && !this.outerJoinedAdditionalJoinCriteria.isEmpty();
    }

    public boolean hasOuterJoinExpressions() {
        return this.outerJoinedExpressions != null && !this.outerJoinedExpressions.isEmpty();
    }

    public boolean isAggregateSelect() {
        return this.isAggregateSelect;
    }

    public boolean isDistinctComputed() {
        return this.distinctState != 0;
    }

    public final void normalize(AbstractSession abstractSession, ClassDescriptor classDescriptor) {
        this.normalize(abstractSession, classDescriptor, new IdentityHashMap());
    }

    public void normalize(AbstractSession abstractSession, ClassDescriptor classDescriptor, Map map) {
        Object object;
        Object object2;
        Serializable serializable;
        if (this.getBuilder() == null) {
            if (this.getWhereClause() == null) {
                this.setBuilder(new ExpressionBuilder());
            } else {
                this.setBuilder(this.getWhereClause().getBuilder());
            }
        }
        ExpressionBuilder expressionBuilder = this.getBuilder();
        if (abstractSession.getAsOfClause() != null && !this.isSubSelect()) {
            this.getWhereClause().asOf(abstractSession.getAsOfClause());
        } else if (expressionBuilder.hasAsOfClause() && expressionBuilder.getAsOfClause().isUniversal()) {
            this.getWhereClause().asOf(((UniversalAsOfClause)expressionBuilder.getAsOfClause()).getAsOfClause());
        }
        if (this.getWhereClause() == expressionBuilder) {
            this.setWhereClause(null);
        }
        expressionBuilder.setSession(abstractSession.getRootSession(null));
        if (!expressionBuilder.doesNotRepresentAnObjectInTheQuery() && classDescriptor != null && ((serializable = expressionBuilder.getQueryClass()) == null || classDescriptor.isChildDescriptor())) {
            expressionBuilder.setQueryClassAndDescriptor(classDescriptor.getJavaClass(), classDescriptor);
        }
        serializable = new Vector();
        this.rebuildAndAddExpressions(this.getFields(), (Vector)serializable, expressionBuilder, map);
        if (this.hasNonSelectFields()) {
            this.rebuildAndAddExpressions(this.getNonSelectFields(), (Vector)serializable, expressionBuilder, map);
        }
        if (this.hasGroupByExpressions()) {
            this.rebuildAndAddExpressions(this.getGroupByExpressions(), (Vector)serializable, expressionBuilder, map);
        }
        if (this.hasHavingExpression()) {
            object2 = this.getHavingExpression();
            object = ((Expression)object2).getBuilder();
            if (object != expressionBuilder) {
                object2 = map.get(object) != null ? ((Expression)object2).copiedVersionFrom(map) : ((Expression)object2).rebuildOn(expressionBuilder);
                this.setHavingExpression((Expression)object2);
            }
            ((Vector)serializable).addElement(object2);
        }
        if (this.hasOrderByExpressions()) {
            this.rebuildAndAddExpressions(this.getOrderByExpressions(), (Vector)serializable, expressionBuilder, map);
        }
        if (this.hasOuterJoinExpressions()) {
            this.rebuildAndAddExpressions(this.getOuterJoinedMappingCriteria(), (Vector)serializable, expressionBuilder, map);
            object2 = this.getOuterJoinedAdditionalJoinCriteria().iterator();
            while (object2.hasNext()) {
                this.rebuildAndAddExpressions((Map)object2.next(), (Vector)serializable, expressionBuilder, map);
            }
        }
        if (this.hasStartWithExpression()) {
            this.startWithExpression = this.getStartWithExpression().rebuildOn(expressionBuilder);
            ((Vector)serializable).addElement(this.startWithExpression);
        }
        if (this.hasConnectByExpression()) {
            this.connectByExpression = this.getConnectByExpression().rebuildOn(expressionBuilder);
        }
        if (this.hasOrderSiblingsByExpressions()) {
            this.rebuildAndAddExpressions(this.getOrderSiblingsByExpressions(), (Vector)serializable, expressionBuilder, map);
        }
        object2 = this.getWhereClause();
        object = new ExpressionNormalizer(this);
        ((ExpressionNormalizer)object).setSession(abstractSession);
        Expression expression = null;
        if (object2 != null) {
            expression = ((Expression)object2).normalize((ExpressionNormalizer)object);
        }
        if (classDescriptor != null) {
            expressionBuilder.normalize((ExpressionNormalizer)object);
        }
        for (int i = 0; i < ((Vector)serializable).size(); ++i) {
            Object object3 = (Expression)((Vector)serializable).elementAt(i);
            ((Expression)object3).normalize((ExpressionNormalizer)object);
        }
        if (expression == null) {
            this.setNormalizedWhereClause(((ExpressionNormalizer)object).getAdditionalExpression());
        } else {
            this.setNormalizedWhereClause(expression.and(((ExpressionNormalizer)object).getAdditionalExpression()));
        }
        if (this.getWhereClause() != null) {
            ((Vector)serializable).addElement(this.getWhereClause());
        }
        if (classDescriptor != null) {
            ((Vector)serializable).addElement(expressionBuilder);
        }
        if (this.hasOuterJoinExpressions()) {
            for (Object object3 : this.getOuterJoinedMappingCriteria()) {
                if (object3 == null) continue;
                ((Vector)serializable).add(object3);
            }
            for (Object object3 : this.getOuterJoinedAdditionalJoinCriteria()) {
                if (object3 == null) continue;
                for (Expression expression2 : object3.values()) {
                    if (expression2 == null) continue;
                    ((Vector)serializable).add(expression2);
                }
            }
        }
        this.assignAliases((Vector)serializable);
        if (classDescriptor == null) {
            this.computeTablesFromTables();
        } else {
            this.computeTables();
        }
        if (((ExpressionNormalizer)object).encounteredSubSelectExpressions()) {
            ((ExpressionNormalizer)object).normalizeSubSelects(map);
        }
        Class clazz = null;
        if (classDescriptor != null) {
            clazz = classDescriptor.getJavaClass();
        }
        if (abstractSession.getPlatform(clazz).isInformix() || this.shouldDistinctBeUsed() && this.hasOrderByExpressions()) {
            this.addOrderByExpressionToSelectForDistinct();
        }
    }

    public void normalizeForView(AbstractSession abstractSession, ClassDescriptor classDescriptor, Map map) {
        ExpressionBuilder expressionBuilder;
        this.setRequiresAliases(true);
        if (this.getWhereClause() != null) {
            expressionBuilder = this.getWhereClause().getBuilder();
        } else {
            expressionBuilder = new ExpressionBuilder();
            this.setBuilder(expressionBuilder);
        }
        expressionBuilder.setViewTable((DatabaseTable)this.getTables().firstElement());
        this.normalize(abstractSession, classDescriptor, map);
    }

    public Vector printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        try {
            Vector vector = null;
            expressionSQLPrinter.setRequiresDistinct(this.shouldDistinctBeUsed());
            expressionSQLPrinter.printString("SELECT ");
            if (this.getHintString() != null) {
                expressionSQLPrinter.printString(this.getHintString());
                expressionSQLPrinter.printString(" ");
            }
            if (this.shouldDistinctBeUsed()) {
                expressionSQLPrinter.printString("DISTINCT ");
            }
            vector = this.writeFieldsIn(expressionSQLPrinter);
            this.setUseUniqueFieldAliases(false);
            this.appendFromClauseToWriter(expressionSQLPrinter);
            if (this.getWhereClause() != null) {
                expressionSQLPrinter.printString(" WHERE ");
                expressionSQLPrinter.printExpression(this.getWhereClause());
            }
            if (this.hasHierarchicalQueryExpressions()) {
                this.appendHierarchicalQueryClauseToWriter(expressionSQLPrinter);
            }
            if (this.hasGroupByExpressions()) {
                this.appendGroupByClauseToWriter(expressionSQLPrinter);
            }
            if (this.hasHavingExpression()) {
                expressionSQLPrinter.printString(" HAVING ");
                expressionSQLPrinter.printExpression(this.getHavingExpression());
            }
            if (this.hasOrderByExpressions()) {
                this.appendOrderClauseToWriter(expressionSQLPrinter);
            }
            if (expressionSQLPrinter.getPlatform().shouldPrintLockingClauseAfterWhereClause() && this.getForUpdateClause() != null) {
                this.getForUpdateClause().printSQL(expressionSQLPrinter, this);
            }
            return vector;
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void rebuildAndAddExpressions(Vector vector, Vector vector2, ExpressionBuilder expressionBuilder, Map map) {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof Expression)) continue;
            Expression expression = (Expression)e;
            ExpressionBuilder expressionBuilder2 = expression.getBuilder();
            if (expressionBuilder2 != expressionBuilder) {
                if (map.get(expressionBuilder2) != null) {
                    expression = expression.copiedVersionFrom(map);
                }
                if (expressionBuilder2.wasQueryClassSetInternally()) {
                    expression = expression.rebuildOn(expressionBuilder);
                }
                vector.setElementAt(expression, i);
            }
            vector2.addElement(expression);
        }
    }

    public void rebuildAndAddExpressions(Map map, Vector vector, ExpressionBuilder expressionBuilder, Map map2) {
        for (Map.Entry entry : map.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof Expression)) continue;
            Expression expression = (Expression)v;
            ExpressionBuilder expressionBuilder2 = expression.getBuilder();
            if (expressionBuilder2 != expressionBuilder) {
                if (map2.get(expressionBuilder2) != null) {
                    expression = expression.copiedVersionFrom(map2);
                }
                if (expressionBuilder2.wasQueryClassSetInternally()) {
                    expression = expression.rebuildOn(expressionBuilder);
                }
                entry.setValue(expression);
            }
            vector.addElement(expression);
        }
    }

    public void removeField(DatabaseField databaseField) {
        this.getFields().removeElement(databaseField);
    }

    public void removeTable(DatabaseTable databaseTable) {
        this.getTables().removeElement(databaseTable);
    }

    public boolean requiresAliases() {
        if (this.requiresAliases || this.hasOuterJoinExpressions()) {
            return true;
        }
        if (this.tableAliases != null) {
            return this.getTableAliases().size() > 1;
        }
        return false;
    }

    public void resetDistinct() {
        this.setDistinctState((short)0);
    }

    public void setCurrentAliasNumber(int n) {
        if (this.getParentStatement() != null) {
            this.getParentStatement().setCurrentAliasNumber(n);
        } else {
            this.currentAliasNumber = n;
        }
    }

    public void setNonSelectFields(Vector vector) {
        this.nonSelectFields = vector;
    }

    public void setNormalizedWhereClause(Expression expression) {
        this.whereClause = expression;
    }

    public void setDistinctState(short s) {
        this.distinctState = s;
    }

    public void setFields(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof FunctionExpression) || !((FunctionExpression)e).getOperator().isAggregateOperator()) continue;
            this.setIsAggregateSelect(true);
            break;
        }
        this.fields = vector;
    }

    public void setGroupByExpressions(Vector vector) {
        this.groupByExpressions = vector;
    }

    public void setHavingExpression(Expression expression) {
        this.havingExpression = expression;
    }

    public void setHierarchicalQueryExpressions(Expression expression, Expression expression2, Vector vector) {
        this.startWithExpression = expression;
        this.connectByExpression = expression2;
        this.orderSiblingsByExpressions = vector;
    }

    public void setIsAggregateSelect(boolean bl) {
        this.isAggregateSelect = bl;
    }

    protected void setForUpdateClause(ForUpdateClause forUpdateClause) {
        this.forUpdateClause = forUpdateClause;
    }

    public void setLockingClause(ForUpdateClause forUpdateClause) {
        this.forUpdateClause = forUpdateClause;
    }

    public void setOrderByExpressions(Vector vector) {
        this.orderByExpressions = vector;
    }

    public void setOuterJoinedAdditionalJoinCriteria(Vector vector) {
        this.outerJoinedAdditionalJoinCriteria = vector;
    }

    public void setOuterJoinedMappingCriteria(Vector vector) {
        this.outerJoinedMappingCriteria = vector;
    }

    public void setOuterJoinExpressions(Vector vector) {
        this.outerJoinedExpressions = vector;
    }

    public void setParentStatement(SQLSelectStatement sQLSelectStatement) {
        this.parentStatement = sQLSelectStatement;
    }

    public void setQuery(ReadQuery readQuery) {
        this.query = readQuery;
    }

    public void setRequiresAliases(boolean bl) {
        this.requiresAliases = bl;
    }

    protected void setTableAliases(Hashtable hashtable) {
        this.tableAliases = hashtable;
    }

    public void setTables(Vector vector) {
        this.tables = vector;
    }

    public void setUseUniqueFieldAliases(boolean bl) {
        this.useUniqueFieldAliases = bl;
    }

    public boolean shouldDistinctBeUsed() {
        return this.distinctState == 1;
    }

    public void useDistinct() {
        this.setDistinctState((short)1);
    }

    protected void writeField(ExpressionSQLPrinter expressionSQLPrinter, DatabaseField databaseField) {
        if (expressionSQLPrinter.isFirstElementPrinted()) {
            expressionSQLPrinter.printString(", ");
        } else {
            expressionSQLPrinter.setIsFirstElementPrinted(true);
        }
        if (expressionSQLPrinter.shouldPrintQualifiedNames()) {
            if (databaseField.getTable() != this.lastTable) {
                this.lastTable = databaseField.getTable();
                this.currentAlias = this.getBuilder().aliasForTable(this.lastTable);
                if (this.currentAlias == null) {
                    this.currentAlias = this.lastTable;
                }
            }
            expressionSQLPrinter.printString(this.currentAlias.getQualifiedName());
            expressionSQLPrinter.printString(".");
            expressionSQLPrinter.printString(databaseField.getName());
        } else {
            expressionSQLPrinter.printString(databaseField.getName());
        }
        if (this.getUseUniqueFieldAliases()) {
            expressionSQLPrinter.printString(" AS " + databaseField.getName() + this.getNextFieldCounterValue());
        }
    }

    protected void writeFieldsFromExpression(ExpressionSQLPrinter expressionSQLPrinter, Expression expression, Vector vector) {
        expression.writeFields(expressionSQLPrinter, vector, this);
    }

    protected Vector writeFieldsIn(ExpressionSQLPrinter expressionSQLPrinter) {
        this.lastTable = null;
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        Enumeration enumeration = this.getFields().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null) continue;
            if (e instanceof Expression) {
                this.writeFieldsFromExpression(expressionSQLPrinter, (Expression)e, nonSynchronizedVector);
                continue;
            }
            this.writeField(expressionSQLPrinter, (DatabaseField)e);
            ((Vector)nonSynchronizedVector).addElement(e);
        }
        return nonSynchronizedVector;
    }

    protected static SortedSet mapTableIndexToExpression(Expression expression, SortedMap sortedMap, Vector vector) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        if (expression instanceof DataExpression) {
            DataExpression dataExpression = (DataExpression)expression;
            if (dataExpression.getAliasedField() != null) {
                treeSet.add(new Integer(vector.indexOf(dataExpression.getAliasedField().getTable())));
            }
        } else if (expression instanceof CompoundExpression) {
            CompoundExpression compoundExpression = (CompoundExpression)expression;
            treeSet.addAll(SQLSelectStatement.mapTableIndexToExpression(compoundExpression.getFirstChild(), sortedMap, vector));
            treeSet.addAll(SQLSelectStatement.mapTableIndexToExpression(compoundExpression.getSecondChild(), sortedMap, vector));
        } else if (expression instanceof FunctionExpression) {
            FunctionExpression functionExpression = (FunctionExpression)expression;
            Iterator iterator = functionExpression.getChildren().iterator();
            while (iterator.hasNext()) {
                treeSet.addAll(SQLSelectStatement.mapTableIndexToExpression((Expression)iterator.next(), sortedMap, vector));
            }
        }
        if (treeSet.size() == 2) {
            sortedMap.put(treeSet.last(), expression);
        }
        return treeSet;
    }

    public static Map mapTableToExpression(Expression expression, Vector vector) {
        TreeMap treeMap = new TreeMap();
        SQLSelectStatement.mapTableIndexToExpression(expression, treeMap, vector);
        HashMap hashMap = new HashMap(treeMap.size());
        for (Map.Entry entry : treeMap.entrySet()) {
            int n = (Integer)entry.getKey();
            hashMap.put(vector.elementAt(n), entry.getValue());
        }
        return hashMap;
    }

    static class OuterJoinExpressionHolder {
        final QueryKeyExpression joinExpression;
        final int index;
        final DatabaseTable targetTable;
        final DatabaseTable sourceTable;
        final DatabaseTable targetAlias;
        final DatabaseTable sourceAlias;

        public OuterJoinExpressionHolder(QueryKeyExpression queryKeyExpression, int n, DatabaseTable databaseTable, DatabaseTable databaseTable2, DatabaseTable databaseTable3, DatabaseTable databaseTable4) {
            this.joinExpression = queryKeyExpression;
            this.index = n;
            this.targetTable = databaseTable;
            this.sourceTable = databaseTable2;
            this.targetAlias = databaseTable3;
            this.sourceAlias = databaseTable4;
        }
    }

    static class OuterJoinExpressionHolders {
        Map sourceAlias2HoldersMap = new HashMap();

        OuterJoinExpressionHolders() {
        }

        void add(OuterJoinExpressionHolder outerJoinExpressionHolder) {
            String string = outerJoinExpressionHolder.sourceAlias.getName();
            ArrayList<OuterJoinExpressionHolder> arrayList = (ArrayList<OuterJoinExpressionHolder>)this.sourceAlias2HoldersMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<OuterJoinExpressionHolder>();
                this.sourceAlias2HoldersMap.put(string, arrayList);
            }
            arrayList.add(outerJoinExpressionHolder);
        }

        List linearize(SQLSelectStatement sQLSelectStatement) {
            List list;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            DatabaseTable[] databaseTableArray = this.sourceAlias2HoldersMap.keySet().iterator();
            while (databaseTableArray.hasNext()) {
                arrayList2.add(databaseTableArray.next());
            }
            databaseTableArray = sQLSelectStatement.getBuilder().getTableAliases().keys();
            for (int i = 0; i < databaseTableArray.length; ++i) {
                String string;
                if (databaseTableArray[i] == null || (string = databaseTableArray[i].getName()) == null || string.equals("")) continue;
                list = (List)this.sourceAlias2HoldersMap.get(string);
                this.addHolders(arrayList, list, arrayList2);
            }
            for (String string : (List)arrayList2.clone()) {
                if (string == null || string.equals("")) continue;
                list = (List)this.sourceAlias2HoldersMap.get(string);
                this.addHolders(arrayList, list, arrayList2);
            }
            return arrayList;
        }

        void addHolders(List list, List list2, List list3) {
            if (list2 == null || list2.isEmpty()) {
                return;
            }
            for (OuterJoinExpressionHolder outerJoinExpressionHolder : list2) {
                list.add(outerJoinExpressionHolder);
                list3.remove(outerJoinExpressionHolder.sourceAlias.getName());
                if (outerJoinExpressionHolder.joinExpression == null || outerJoinExpressionHolder.joinExpression.getTableAliases() == null) continue;
                DatabaseTable[] databaseTableArray = outerJoinExpressionHolder.joinExpression.getTableAliases().keys();
                for (int i = 0; i < databaseTableArray.length; ++i) {
                    List list4;
                    String string;
                    if (databaseTableArray[i] == null || (string = databaseTableArray[i].getName()) == null || string.equals("") || (list4 = (List)this.sourceAlias2HoldersMap.get(string)) == null) continue;
                    this.addHolders(list, list4, list3);
                }
            }
        }
    }
}

