/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.Serializable;
import java.util.Hashtable;
import org.eclipse.persistence.internal.helper.DatabaseTable;

public class TableAliasLookup
implements Serializable {
    protected DatabaseTable[] keys;
    protected DatabaseTable[] values;
    protected int lastUsed;
    protected boolean haveBeenAddedToStatement;

    public TableAliasLookup() {
        this.keys = new DatabaseTable[5];
        this.values = new DatabaseTable[5];
        this.lastUsed = 0;
    }

    public TableAliasLookup(int n) {
        this.keys = new DatabaseTable[n];
        this.values = new DatabaseTable[n];
        this.lastUsed = 0;
    }

    public void addToHashtable(Hashtable hashtable) {
        for (int i = 0; i < this.lastUsed; ++i) {
            hashtable.put(this.keys[i], this.values[i]);
        }
    }

    public DatabaseTable get(DatabaseTable databaseTable) {
        int n = this.lookupIndexOf(databaseTable);
        if (n == -1) {
            return null;
        }
        return this.values[n];
    }

    private void grow() {
        DatabaseTable[] databaseTableArray = new DatabaseTable[this.lastUsed * 2];
        DatabaseTable[] databaseTableArray2 = new DatabaseTable[this.lastUsed * 2];
        for (int i = 0; i < this.lastUsed; ++i) {
            databaseTableArray[i] = this.keys[i];
            databaseTableArray2[i] = this.values[i];
        }
        this.keys = databaseTableArray;
        this.values = databaseTableArray2;
    }

    public boolean haveBeenAddedToStatement() {
        return this.haveBeenAddedToStatement;
    }

    public boolean isEmpty() {
        return this.keys[0] == null;
    }

    public DatabaseTable keyAtValue(DatabaseTable databaseTable) {
        int n = this.lookupValueIndexOf(databaseTable);
        if (n == -1) {
            return null;
        }
        return this.keys[n];
    }

    public DatabaseTable[] keys() {
        return this.keys;
    }

    private int lookupIndexOf(DatabaseTable databaseTable) {
        for (int i = 0; i < this.lastUsed; ++i) {
            if (!this.keys[i].equals(databaseTable)) continue;
            return i;
        }
        return -1;
    }

    private int lookupValueIndexOf(DatabaseTable databaseTable) {
        for (int i = 0; i < this.lastUsed; ++i) {
            if (!this.values[i].equals(databaseTable)) continue;
            return i;
        }
        return -1;
    }

    public DatabaseTable put(DatabaseTable databaseTable, DatabaseTable databaseTable2) {
        int n = this.lookupIndexOf(databaseTable);
        if (n == -1) {
            this.keys[this.lastUsed] = databaseTable;
            this.values[this.lastUsed++] = databaseTable2;
            if (this.lastUsed >= this.keys.length) {
                this.grow();
            }
        } else {
            this.values[n] = databaseTable2;
        }
        return databaseTable2;
    }

    public void setHaveBeenAddedToStatement(boolean bl) {
        this.haveBeenAddedToStatement = bl;
    }

    public int size() {
        return this.lastUsed;
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = this.keys[i].toString();
            String string2 = this.values[i].toString();
            stringBuffer.append(string + "=" + string2);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public DatabaseTable[] values() {
        return this.values;
    }
}

