/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;

public class BasicTypeHelperImpl {
    private static Set numericTypes = new HashSet();
    private static Set integralTypes = new HashSet();
    private static Set floatingPointTypes = new HashSet();
    private static Set dateClasses = new HashSet();
    private static Map primitiveToWrapper = new HashMap();
    private static Map wrapperToPrimitive = new HashMap();
    private static final BasicTypeHelperImpl singleton;

    public static BasicTypeHelperImpl getInstance() {
        return singleton;
    }

    public String getTypeName(Object object) {
        Class clazz = this.getJavaClass(object);
        return clazz == null ? null : clazz.getName();
    }

    public Class getJavaClass(Object object) {
        Class clazz = null;
        if (object instanceof Class) {
            clazz = (Class)object;
        } else if (object instanceof ClassDescriptor) {
            clazz = ((ClassDescriptor)object).getJavaClass();
        }
        return clazz;
    }

    public Object getObjectType() {
        return Object.class;
    }

    public Object getBooleanType() {
        return Boolean.TYPE;
    }

    public Object getBooleanClassType() {
        return Boolean.class;
    }

    public Object getCharType() {
        return Character.TYPE;
    }

    public Object getCharacterClassType() {
        return Character.class;
    }

    public Object getByteType() {
        return Byte.TYPE;
    }

    public Object getByteClassType() {
        return Byte.class;
    }

    public Object getShortType() {
        return Short.TYPE;
    }

    public Object getShortClassType() {
        return Short.class;
    }

    public Object getIntType() {
        return Integer.TYPE;
    }

    public Object getIntegerClassType() {
        return Integer.class;
    }

    public Object getLongType() {
        return Long.TYPE;
    }

    public Object getLongClassType() {
        return Long.class;
    }

    public Object getFloatType() {
        return Float.TYPE;
    }

    public Object getFloatClassType() {
        return Float.class;
    }

    public Object getDoubleType() {
        return Double.TYPE;
    }

    public Object getDoubleClassType() {
        return Double.class;
    }

    public Object getStringType() {
        return String.class;
    }

    public Object getBigIntegerType() {
        return BigInteger.class;
    }

    public Object getBigDecimalType() {
        return BigDecimal.class;
    }

    public Object getDateType() {
        return java.util.Date.class;
    }

    public boolean isEnumType(Object object) {
        Class clazz = this.getJavaClass(object);
        return clazz != null && clazz.isEnum();
    }

    public boolean isNumericType(Object object) {
        return numericTypes.contains(object);
    }

    public boolean isIntegralType(Object object) {
        return integralTypes.contains(object);
    }

    public boolean isFloatingPointType(Object object) {
        return floatingPointTypes.contains(object);
    }

    public boolean isWrapperClass(Object object) {
        return wrapperToPrimitive.containsKey(object);
    }

    public boolean isBooleanType(Object object) {
        return object == this.getBooleanType() || object == this.getBooleanClassType();
    }

    public boolean isCharacterType(Object object) {
        return object == this.getCharType() || object == this.getCharacterClassType();
    }

    public boolean isByteType(Object object) {
        return object == this.getByteType() || object == this.getByteClassType();
    }

    public boolean isShortType(Object object) {
        return object == this.getShortType() || object == this.getShortClassType();
    }

    public boolean isIntType(Object object) {
        return object == this.getIntType() || object == this.getIntegerClassType();
    }

    public boolean isLongType(Object object) {
        return object == this.getLongType() || object == this.getLongClassType();
    }

    public boolean isFloatType(Object object) {
        return object == this.getFloatType() || object == this.getFloatClassType();
    }

    public boolean isDoubleType(Object object) {
        return object == this.getDoubleType() || object == this.getDoubleClassType();
    }

    public boolean isStringType(Object object) {
        return object == this.getStringType();
    }

    public boolean isDateClass(Object object) {
        return dateClasses.contains(object);
    }

    public boolean isBigIntegerType(Object object) {
        return object == this.getBigIntegerType();
    }

    public boolean isBigDecimalType(Object object) {
        return object == this.getBigDecimalType();
    }

    public boolean isOrderableType(Object object) {
        return this.isNumericType(object) || this.isStringType(object) || this.isDateClass(object) || this.isEnumType(object);
    }

    public boolean isAssignableFrom(Object object, Object object2) {
        if (object == null || object2 == null) {
            return true;
        }
        if (object == object2) {
            return true;
        }
        if (object == ClassConstants.OBJECT || object2 == ClassConstants.OBJECT) {
            return true;
        }
        if (this.isNumericType(object) && this.isNumericType(object2)) {
            return true;
        }
        if (this.isDateClass(object) && this.isDateClass(object2)) {
            return true;
        }
        if (this.isBooleanType(object) && this.isBooleanType(object2)) {
            return true;
        }
        return this.getJavaClass(object).isAssignableFrom(this.getJavaClass(object2));
    }

    public Object extendedBinaryNumericPromotion(Object object, Object object2) {
        if (object == null || object2 == null || !this.isNumericType(object) || !this.isNumericType(object2)) {
            return null;
        }
        if (this.isBigDecimalType(object) || this.isBigDecimalType(object2)) {
            return this.getBigDecimalType();
        }
        if (this.isBigIntegerType(object)) {
            return this.isFloatingPointType(object2) ? object2 : this.getBigIntegerType();
        }
        if (this.isBigIntegerType(object2)) {
            return this.isFloatingPointType(object) ? object : this.getBigIntegerType();
        }
        boolean bl = false;
        if (this.isWrapperClass(object)) {
            bl = true;
            object = this.getPrimitiveType(object);
        }
        if (this.isWrapperClass(object2)) {
            bl = true;
            object2 = this.getPrimitiveType(object2);
        }
        Object object3 = this.binaryNumericPromotion(object, object2);
        if (bl && object3 != null) {
            object3 = this.getWrapperClass(object3);
        }
        return object3;
    }

    protected Object getPrimitiveType(Object object) {
        return wrapperToPrimitive.get(object);
    }

    protected Object getWrapperClass(Object object) {
        return primitiveToWrapper.get(object);
    }

    protected Object binaryNumericPromotion(Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        Object object3 = null;
        if (object == this.getDoubleType() || object2 == this.getDoubleType()) {
            object3 = this.getDoubleType();
        } else if (object == this.getFloatType() || object2 == this.getFloatType()) {
            object3 = this.getFloatType();
        } else if (object == this.getLongType() || object2 == this.getLongType()) {
            object3 = this.getLongType();
        } else if (this.isIntegralType(object) && this.isIntegralType(object2)) {
            object3 = this.getIntType();
        }
        return object3;
    }

    static {
        integralTypes.add(Byte.TYPE);
        integralTypes.add(Byte.class);
        integralTypes.add(Short.TYPE);
        integralTypes.add(Short.class);
        integralTypes.add(Character.TYPE);
        integralTypes.add(Character.class);
        integralTypes.add(Integer.TYPE);
        integralTypes.add(Integer.class);
        integralTypes.add(Long.TYPE);
        integralTypes.add(Long.class);
        floatingPointTypes.add(Float.TYPE);
        floatingPointTypes.add(Float.class);
        floatingPointTypes.add(Double.TYPE);
        floatingPointTypes.add(Double.class);
        dateClasses.add(java.util.Date.class);
        dateClasses.add(Calendar.class);
        dateClasses.add(Date.class);
        dateClasses.add(Time.class);
        dateClasses.add(Timestamp.class);
        numericTypes.addAll(integralTypes);
        numericTypes.addAll(floatingPointTypes);
        numericTypes.add(BigDecimal.class);
        numericTypes.add(BigInteger.class);
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Character.TYPE, Character.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        wrapperToPrimitive.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitive.put(Byte.class, Byte.TYPE);
        wrapperToPrimitive.put(Short.class, Short.TYPE);
        wrapperToPrimitive.put(Character.class, Character.TYPE);
        wrapperToPrimitive.put(Integer.class, Integer.TYPE);
        wrapperToPrimitive.put(Long.class, Long.TYPE);
        wrapperToPrimitive.put(Float.class, Float.TYPE);
        wrapperToPrimitive.put(Double.class, Double.TYPE);
        singleton = new BasicTypeHelperImpl();
    }
}

