/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLType;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComplexDatabaseType
implements DatabaseType,
Cloneable,
OraclePLSQLType {
    protected String typeName;
    protected String compatibleType;
    protected Class javaType;
    protected String javaTypeName;

    public boolean isRecord() {
        return false;
    }

    public boolean isCollection() {
        return false;
    }

    @Override
    public int getConversionCode() {
        return this.getSqlCode();
    }

    @Override
    public boolean isComplexDatabaseType() {
        return true;
    }

    @Override
    public boolean isJDBCType() {
        return false;
    }

    public boolean hasCompatibleType() {
        return this.compatibleType != null;
    }

    public String getCompatibleType() {
        return this.compatibleType;
    }

    public void setCompatibleType(String string) {
        this.compatibleType = string;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public void setJavaType(Class clazz) {
        this.javaType = clazz;
        if (clazz != null) {
            this.javaTypeName = clazz.getName();
        }
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public String getJavaTypeName() {
        if (this.javaType != null && this.javaTypeName == null) {
            this.javaTypeName = this.javaType.getName();
        }
        return this.javaTypeName;
    }

    public void setJavaTypeName(String string) {
        this.javaTypeName = string;
    }

    public ComplexDatabaseType clone() {
        try {
            ComplexDatabaseType complexDatabaseType = (ComplexDatabaseType)super.clone();
            return complexDatabaseType;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    @Override
    public void buildInDeclare(StringBuilder stringBuilder, PLSQLargument pLSQLargument) {
        if (!this.hasCompatibleType()) {
            throw QueryException.compatibleTypeNotSet(this);
        }
        if (this.getTypeName() == null || this.getTypeName().equals("")) {
            throw QueryException.typeNameNotSet(this);
        }
        stringBuilder.append("  ");
        stringBuilder.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(pLSQLargument));
        stringBuilder.append(" ");
        stringBuilder.append(this.getTypeName());
        stringBuilder.append(";");
        stringBuilder.append(Helper.NL);
        stringBuilder.append("  ");
        stringBuilder.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildCompatible(pLSQLargument));
        stringBuilder.append(" ");
        stringBuilder.append(this.getCompatibleType());
        stringBuilder.append(" := :");
        stringBuilder.append(pLSQLargument.inIndex);
        stringBuilder.append(";");
        stringBuilder.append(Helper.NL);
    }

    @Override
    public void buildOutDeclare(StringBuilder stringBuilder, PLSQLargument pLSQLargument) {
        if (!this.hasCompatibleType()) {
            throw QueryException.compatibleTypeNotSet(this);
        }
        if (this.getTypeName() == null || this.getTypeName().equals("")) {
            throw QueryException.typeNameNotSet(this);
        }
        stringBuilder.append("  ");
        stringBuilder.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(pLSQLargument));
        stringBuilder.append(" ");
        stringBuilder.append(this.getTypeName());
        stringBuilder.append(";");
        stringBuilder.append(Helper.NL);
    }

    @Override
    public void buildBeginBlock(StringBuilder stringBuilder, PLSQLargument pLSQLargument, PLSQLStoredProcedureCall pLSQLStoredProcedureCall) {
        String string = pLSQLStoredProcedureCall.getSQL2PlName(this);
        if (string == null) {
            throw new NullPointerException("no SQL2Pl conversion routine for " + this.typeName);
        }
        String string2 = DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(pLSQLargument);
        String string3 = DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildCompatible(pLSQLargument);
        stringBuilder.append("  ");
        stringBuilder.append(string2);
        stringBuilder.append(" := ");
        stringBuilder.append(string);
        stringBuilder.append("(");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        stringBuilder.append(Helper.NL);
    }

    @Override
    public void buildOutAssignment(StringBuilder stringBuilder, PLSQLargument pLSQLargument, PLSQLStoredProcedureCall pLSQLStoredProcedureCall) {
        String string = pLSQLStoredProcedureCall.getPl2SQLName(this);
        if (string == null) {
            throw new NullPointerException("no Pl2SQL conversion routine for " + this.typeName);
        }
        String string2 = DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(pLSQLargument);
        stringBuilder.append("  :");
        stringBuilder.append(pLSQLargument.outIndex);
        stringBuilder.append(" := ");
        stringBuilder.append(string);
        stringBuilder.append("(");
        stringBuilder.append(string2);
        stringBuilder.append(");");
        stringBuilder.append(Helper.NL);
    }

    @Override
    public void buildOutputRow(PLSQLargument pLSQLargument, AbstractRecord abstractRecord, DatabaseRecord databaseRecord, Vector vector, Vector vector2) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutputRow(pLSQLargument, abstractRecord, databaseRecord, vector, vector2);
    }

    @Override
    public int computeInIndex(PLSQLargument pLSQLargument, int n, ListIterator<PLSQLargument> listIterator) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeInIndex(pLSQLargument, n);
    }

    @Override
    public int computeOutIndex(PLSQLargument pLSQLargument, int n, ListIterator<PLSQLargument> listIterator) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeOutIndex(pLSQLargument, n);
    }

    @Override
    public void logParameter(StringBuilder stringBuilder, Integer n, PLSQLargument pLSQLargument, AbstractRecord abstractRecord, DatabasePlatform databasePlatform) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.logParameter(stringBuilder, n, pLSQLargument, abstractRecord, databasePlatform);
    }

    @Override
    public void translate(PLSQLargument pLSQLargument, AbstractRecord abstractRecord, AbstractRecord abstractRecord2, Vector vector, Vector vector2, Vector vector3, StoredProcedureCall storedProcedureCall) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.translate(pLSQLargument, abstractRecord, abstractRecord2, vector, vector2, vector3, storedProcedureCall);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getTypeName() + ")";
    }
}

