/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetField;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helper
implements Serializable {
    protected static boolean shouldOptimizeDates = false;
    protected static final Object nullWrapper = new Helper();
    protected static Queue<Calendar> calendarCache = Helper.initCalendarCache();
    protected static TimeZone defaultTimeZone = TimeZone.getDefault();
    protected static String CR = null;
    public static String INDENT = "  ";
    public static String NL = "\n";
    protected static String PATH_SEPARATOR = null;
    protected static String FILE_SEPARATOR = null;
    protected static String CURRENT_WORKING_DIRECTORY = null;
    protected static String TEMP_DIRECTORY = null;
    public static boolean isZeroValidPrimaryKey = false;

    public static boolean shouldOptimizeDates() {
        return shouldOptimizeDates;
    }

    public static void setShouldOptimizeDates(boolean bl) {
        shouldOptimizeDates = bl;
    }

    public static Queue<Calendar> getCalendarCache() {
        return calendarCache;
    }

    public static Queue initCalendarCache() {
        ConcurrentLinkedQueue<Calendar> concurrentLinkedQueue = new ConcurrentLinkedQueue<Calendar>();
        for (int i = 0; i < 10; ++i) {
            concurrentLinkedQueue.add(Calendar.getInstance());
        }
        return concurrentLinkedQueue;
    }

    public static Calendar allocateCalendar() {
        Calendar calendar = Helper.getCalendarCache().poll();
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        return calendar;
    }

    public static TimeZone getDefaultTimeZone() {
        return defaultTimeZone;
    }

    public static void releaseCalendar(Calendar calendar) {
        Helper.getCalendarCache().offer(calendar);
    }

    public static void addAllToVector(Vector vector, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
    }

    public static void addAllToVector(Vector vector, List list) {
        vector.addAll(list);
    }

    public static Vector addAllUniqueToVector(Vector vector, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (vector.contains(e)) continue;
            vector.addElement(e);
        }
        return vector;
    }

    public static Object[] arrayFromVector(Vector vector) {
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = vector.elementAt(i);
        }
        return objectArray;
    }

    public static byte[] buildBytesFromHexString(String string) {
        String string2 = string;
        if (string2.length() % 2 != 0) {
            throw ConversionException.couldNotConvertToByteArray(string);
        }
        byte[] byArray = new byte[string2.length() / 2];
        int n = byArray.length - 1;
        int n2 = string2.length() - 2;
        while (n >= 0) {
            byte by = (byte)Character.digit(string2.charAt(n2), 16);
            byte by2 = (byte)Character.digit(string2.charAt(n2 + 1), 16);
            if (by == -1 || by2 == -1) {
                throw ConversionException.couldNotBeConverted(string, ClassConstants.APBYTE);
            }
            byArray[n] = (byte)(by * 16 + by2);
            --n;
            n2 -= 2;
        }
        return byArray;
    }

    public static Hashtable buildHashtableFromVector(Vector vector) {
        Hashtable hashtable = new Hashtable(vector.size());
        for (Object e : vector) {
            hashtable.put(e, e);
        }
        return hashtable;
    }

    public static String buildHexStringFromBytes(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i];
            if (n < 0) {
                n += 256;
            }
            if ((n = (int)((byte)(n / 16))) > 16) {
                throw ConversionException.couldNotBeConverted(byArray, ClassConstants.STRING);
            }
            stringBuffer.append(cArray[n]);
            n = byArray[i];
            if (n < 0) {
                n += 256;
            }
            if ((n = (int)((byte)(n % 16))) > 16) {
                throw ConversionException.couldNotBeConverted(byArray, ClassConstants.STRING);
            }
            stringBuffer.append(cArray[n]);
        }
        return stringBuffer.toString();
    }

    public static Vector buildVectorFromHashtableElements(Hashtable hashtable) {
        Vector vector = new Vector(hashtable.size());
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public static Vector buildVectorFromMapElements(Map map) {
        Vector vector = new Vector(map.size());
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        return vector;
    }

    public static Vector buildVectorFromHashtableElements(Map map) {
        Vector vector = new Vector(map.size());
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        return vector;
    }

    public static Calendar calendarFromUtilDate(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (date instanceof Timestamp) {
            calendar.set(14, ((Timestamp)date).getNanos() / 1000000);
        }
        return calendar;
    }

    public static boolean classImplementsInterface(Class clazz, Class clazz2) {
        int n;
        if (clazz == clazz2) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (n = 0; n < classArray.length; ++n) {
            if (classArray[n] != clazz2) continue;
            return true;
        }
        for (n = 0; n < classArray.length; ++n) {
            if (!Helper.classImplementsInterface(classArray[n], clazz2)) continue;
            return true;
        }
        Class clazz3 = clazz.getSuperclass();
        if (clazz3 == null) {
            return false;
        }
        return Helper.classImplementsInterface(clazz3, clazz2);
    }

    public static boolean classIsSubclass(Class clazz, Class clazz2) {
        if (clazz2 == null) {
            return false;
        }
        for (Class clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            if (clazz3 != clazz2) continue;
            return true;
        }
        return false;
    }

    public static int compareVersions(String string, String string2) {
        return Helper.compareVersions(Helper.version(string), Helper.version(string2));
    }

    protected static List<Integer> version(String string) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(5);
        int n2 = -1;
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (48 <= n && n <= 57) {
                if (n2 != -1) continue;
                n2 = i;
                continue;
            }
            if (n2 == -1) break;
            String string2 = string.substring(n2, i);
            int n3 = Integer.parseInt(string2, 10);
            arrayList.add(n3);
            n2 = -1;
            if (n != 46) break;
        }
        if (n2 >= 0) {
            String string3 = string.substring(n2, string.length());
            n = Integer.parseInt(string3, 10);
            arrayList.add(n);
        }
        return arrayList;
    }

    protected static int compareVersions(List<Integer> list, List<Integer> list2) {
        int n = Math.max(list.size(), list2.size());
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            if (i < list.size()) {
                n3 = list.get(i);
            }
            int n4 = 0;
            if (i < list2.size()) {
                n4 = list2.get(i);
            }
            if (n3 < n4) {
                n2 = -1;
                break;
            }
            if (n3 <= n4) continue;
            n2 = 1;
            break;
        }
        return n2;
    }

    public static Class getClassFromClasseName(String string, ClassLoader classLoader) {
        Class clazz = null;
        if (string == null) {
            return null;
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(string, true, classLoader));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(string, privilegedActionException.getException());
                }
            } else {
                clazz = PrivilegedAccessHelper.getClassForName(string, true, classLoader);
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(string, classNotFoundException);
        }
    }

    public static String getComponentTypeNameFromArrayString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.length() > 3 && string.startsWith("[L") & string.endsWith(";")) {
            return string.substring(2, string.length() - 1);
        }
        if (string.startsWith("[")) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
            if (clazz != null) {
                return clazz.getComponentType().getName();
            }
        }
        return null;
    }

    public static boolean compareArrays(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].equals(objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean compareBigDecimals(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (bigDecimal.scale() != bigDecimal2.scale()) {
            double d = bigDecimal.doubleValue();
            double d2 = bigDecimal2.doubleValue();
            if (d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY && d2 != Double.POSITIVE_INFINITY && d2 != Double.NEGATIVE_INFINITY) {
                return d == d2;
            }
        }
        return bigDecimal.equals(bigDecimal2);
    }

    public static boolean compareByteArrays(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean compareCharArrays(char[] cArray, char[] cArray2) {
        if (cArray.length != cArray2.length) {
            return false;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areTypesAssignable(List list, List list2) {
        if (list == null || list2 == null) {
            return false;
        }
        if (list.size() == list2.size()) {
            for (int i = 0; i < list.size(); ++i) {
                Class clazz = (Class)list.get(i);
                Class clazz2 = (Class)list2.get(i);
                if (clazz == null || clazz2 == null || clazz.isAssignableFrom(clazz2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean compareHashtables(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable.size() != hashtable2.size()) {
            return false;
        }
        Hashtable hashtable3 = (Hashtable)hashtable2.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (hashtable3.remove(v) != null) continue;
            return false;
        }
        return hashtable3.isEmpty();
    }

    public static boolean compareOrderedVectors(Vector vector, Vector vector2) {
        if (vector == vector2) {
            return true;
        }
        if (vector.size() != vector2.size()) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            Object e2 = vector2.elementAt(i);
            if (!(e == null ? e2 != null : !e.equals(e2))) continue;
            return false;
        }
        return true;
    }

    public static boolean compareUnorderedVectors(Vector vector, Vector vector2) {
        if (vector == vector2) {
            return true;
        }
        if (vector.size() != vector2.size()) {
            return false;
        }
        Vector vector3 = (Vector)vector2.clone();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e == null ? !Helper.removeNullElement(vector3) : !vector3.removeElement(e))) continue;
            return false;
        }
        return true;
    }

    public static Map concatenateMaps(Map map, Map map2) {
        Object v;
        HashMap hashMap = new HashMap(map.size() + map2.size() + 4);
        for (Object k : map.keySet()) {
            v = map.get(k);
            hashMap.put(k, v);
        }
        for (Object k : map2.keySet()) {
            v = map2.get(k);
            hashMap.put(k, v);
        }
        return hashMap;
    }

    public static Vector concatenateUniqueVectors(Vector vector, Vector vector2) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(enumeration.nextElement());
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (nonSynchronizedVector.contains(e)) continue;
            ((Vector)nonSynchronizedVector).addElement(e);
        }
        return nonSynchronizedVector;
    }

    public static Vector concatenateVectors(Vector vector, Vector vector2) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(enumeration.nextElement());
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(enumeration.nextElement());
        }
        return nonSynchronizedVector;
    }

    public static Vector copyVector(Vector vector, int n, int n2) throws ValidationException {
        if (n2 < n) {
            return NonSynchronizedVector.newInstance();
        }
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(n2 - n);
        for (int i = n; i < n2; ++i) {
            ((Vector)nonSynchronizedVector).add(vector.get(i));
        }
        return nonSynchronizedVector;
    }

    public static String cr() {
        if (CR == null) {
            CR = System.getProperty("line.separator");
        }
        return CR;
    }

    public static String currentWorkingDirectory() {
        if (CURRENT_WORKING_DIRECTORY == null) {
            CURRENT_WORKING_DIRECTORY = System.getProperty("user.dir");
        }
        return CURRENT_WORKING_DIRECTORY;
    }

    public static String tempDirectory() {
        if (TEMP_DIRECTORY == null) {
            TEMP_DIRECTORY = System.getProperty("java.io.tmpdir");
        }
        return TEMP_DIRECTORY;
    }

    public static Date dateFromLong(Long l) {
        return new Date(l);
    }

    public static Date dateFromYearMonthDate(int n, int n2, int n3) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.clear();
        calendar.set(n, n2, n3, 0, 0, 0);
        long l = calendar.getTimeInMillis();
        Date date = new Date(l);
        Helper.releaseCalendar(calendar);
        return date;
    }

    public static Date dateFromString(String string) throws ConversionException {
        int n;
        int n2;
        int n3;
        StringTokenizer stringTokenizer;
        if (string.indexOf(47) != -1) {
            stringTokenizer = new StringTokenizer(string, "/");
        } else if (string.indexOf(45) != -1) {
            stringTokenizer = new StringTokenizer(string, "- ");
        } else {
            throw ConversionException.incorrectDateFormat(string);
        }
        try {
            n3 = Integer.parseInt(stringTokenizer.nextToken());
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.incorrectDateFormat(string);
        }
        return Helper.dateFromYearMonthDate(n3, --n2, n);
    }

    public static Date dateFromTimestamp(Timestamp timestamp) {
        return Helper.sqlDateFromUtilDate(timestamp);
    }

    public static boolean doesFileExist(String string) {
        try {
            new FileReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        return true;
    }

    public static String doubleSlashes(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            if (c != '\\') continue;
            stringBuffer.append('\\');
        }
        return stringBuffer.toString();
    }

    public static String extractJarNameFromURL(URL uRL) {
        String string = uRL.getFile();
        int n = string.indexOf("file:") + 5;
        int n2 = string.indexOf("!/");
        return string.substring(n, n2);
    }

    public static String fileSeparator() {
        if (FILE_SEPARATOR == null) {
            FILE_SEPARATOR = System.getProperty("file.separator");
        }
        return FILE_SEPARATOR;
    }

    public static Field getField(Class clazz, String string) throws NoSuchFieldException {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Field)AccessController.doPrivileged(new PrivilegedGetField(clazz, string, true));
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NoSuchFieldException)privilegedActionException.getException();
            }
        }
        return PrivilegedAccessHelper.getField(clazz, string, true);
    }

    public static Method getDeclaredMethod(Class clazz, String string) throws NoSuchMethodException {
        return Helper.getDeclaredMethod(clazz, string, null);
    }

    public static Method getDeclaredMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return AccessController.doPrivileged(new PrivilegedGetMethod(clazz, string, classArray, true));
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getCause() instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)privilegedActionException.getCause();
                }
                throw (RuntimeException)privilegedActionException.getCause();
            }
        }
        return PrivilegedAccessHelper.getMethod(clazz, string, classArray, true);
    }

    public static Object getInstanceFromClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (exception instanceof InstantiationException) {
                        ValidationException validationException = new ValidationException();
                        validationException.setInternalException(exception);
                        throw validationException;
                    }
                    ValidationException validationException = new ValidationException();
                    validationException.setInternalException(exception);
                    throw validationException;
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(clazz);
        }
        catch (InstantiationException instantiationException) {
            ValidationException validationException = new ValidationException();
            validationException.setInternalException(instantiationException);
            throw validationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            ValidationException validationException = new ValidationException();
            validationException.setInternalException(illegalAccessException);
            throw validationException;
        }
    }

    public static Object getNullWrapper() {
        return nullWrapper;
    }

    public static Class getObjectClass(Class clazz) {
        return ConversionManager.getObjectClass(clazz);
    }

    public static String getShortClassName(Class clazz) {
        return Helper.getShortClassName(clazz.getName());
    }

    public static String getShortClassName(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static String getShortClassName(Object object) {
        return Helper.getShortClassName(object.getClass());
    }

    public static String getPackageName(Class clazz) {
        String string = Helper.getShortClassName(clazz);
        return clazz.getName().substring(0, clazz.getName().length() - (string.length() + 1));
    }

    public static String getTabs(int n) {
        StringWriter stringWriter = new StringWriter();
        for (int i = 0; i < n; ++i) {
            stringWriter.write("\t");
        }
        return stringWriter.toString();
    }

    public static int indexOfNullElement(Vector vector, int n) {
        int n2 = vector.size();
        for (int i = n; i < n2; ++i) {
            if (vector.elementAt(i) != null) continue;
            return i;
        }
        return -1;
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        return clazz.equals(Character.class) || clazz.equals(Boolean.class) || clazz.equals(Byte.class) || clazz.equals(Short.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Float.class) || clazz.equals(Double.class);
    }

    public static boolean isUpperCaseString(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isLowerCase(cArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isVowel(char c) {
        return c == 'A' || c == 'a' || c == 'e' || c == 'E' || c == 'i' || c == 'I' || c == 'o' || c == 'O' || c == 'u' || c == 'U';
    }

    public static File[] listFilesIn(File file) {
        if (file.isDirectory()) {
            return file.listFiles();
        }
        return new File[0];
    }

    public static Vector makeVectorFromObject(Object object) {
        if (object instanceof Vector) {
            return (Vector)object;
        }
        if (object instanceof Collection) {
            Vector vector = new Vector(((Collection)object).size());
            Iterator iterator = ((Collection)object).iterator();
            while (iterator.hasNext()) {
                vector.add(iterator.next());
            }
            return vector;
        }
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        return vector;
    }

    public static String pathSeparator() {
        if (PATH_SEPARATOR == null) {
            PATH_SEPARATOR = System.getProperty("path.separator");
        }
        return PATH_SEPARATOR;
    }

    public static String printStackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public static String printTimeFromMilliseconds(long l) {
        if (l > 1000L && l < 60000L) {
            return l / 1000L + "s";
        }
        if (l > 60000L) {
            return l / 60000L + "min " + Helper.printTimeFromMilliseconds(l % 60000L);
        }
        return l + "ms";
    }

    public static String printVector(Vector vector) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("[");
        Enumeration enumeration = vector.elements();
        stringWriter.write(String.valueOf(enumeration.nextElement()));
        while (enumeration.hasMoreElements()) {
            stringWriter.write(" ");
            stringWriter.write(String.valueOf(enumeration.nextElement()));
        }
        stringWriter.write("]");
        return stringWriter.toString();
    }

    public static Hashtable rehashHashtable(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable(hashtable.size() + 2);
        Enumeration enumeration = hashtable.elements();
        Enumeration enumeration2 = hashtable.keys();
        while (enumeration2.hasMoreElements()) {
            Object k = enumeration2.nextElement();
            Object v = enumeration.nextElement();
            hashtable2.put(k, v);
        }
        return hashtable2;
    }

    public static Map rehashMap(Map map) {
        HashMap hashMap = new HashMap(map.size() + 2);
        Iterator iterator = map.values().iterator();
        for (Object k : map.keySet()) {
            Object v = iterator.next();
            hashMap.put(k, v);
        }
        return hashMap;
    }

    public static String removeAllButAlphaNumericToFit(String string, int n) {
        int n2;
        int n3 = string.length();
        if (n3 <= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = string.length() - n;
        for (n2 = 0; n4 > 0 && n2 < n3; ++n2) {
            char c = string.charAt(n2);
            if (Character.isLetterOrDigit(c)) {
                stringBuffer.append(c);
                continue;
            }
            --n4;
        }
        while (n2 < n3) {
            stringBuffer.append(string.charAt(n2));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String removeCharacterToFit(String string, char c, int n) {
        int n2;
        int n3 = string.length();
        if (n3 <= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = string.length() - n;
        for (n2 = 0; n4 > 0 && n2 < n3; ++n2) {
            char c2 = string.charAt(n2);
            if (c2 == c) {
                --n4;
                continue;
            }
            stringBuffer.append(c2);
        }
        while (n2 < n3) {
            stringBuffer.append(string.charAt(n2));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static boolean removeNullElement(Vector vector) {
        int n = Helper.indexOfNullElement(vector, 0);
        if (n != -1) {
            vector.removeElementAt(n);
            return true;
        }
        return false;
    }

    public static String removeVowels(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Helper.isVowel(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String replaceFirstSubString(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n >= 0) {
            return string.substring(0, n) + string3 + string.substring(n + string2.length());
        }
        return null;
    }

    public static Vector reverseVector(Vector vector) {
        Vector vector2 = new Vector(vector.size());
        for (int i = vector.size() - 1; i > -1; --i) {
            Object e = vector.elementAt(i);
            vector2.addElement(e);
        }
        return vector2;
    }

    public static String rightTrimString(String string) {
        int n;
        for (n = string.length(); n > 0 && string.charAt(n - 1) <= ' '; --n) {
        }
        return string.substring(0, n);
    }

    public static String shortenStringsByRemovingVowelsToFit(String string, String string2, int n) {
        int n2 = string.length() + string2.length();
        if (n2 <= n) {
            return string + string2;
        }
        int n3 = string.length();
        int n4 = string2.length();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n5 = n2 - n;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n5 > 0 && (n6 < n3 || n7 < n4)) {
            if (n8 % 2 == 0) {
                if (n6 < n3) {
                    if (Helper.isVowel(string.charAt(n6))) {
                        --n5;
                    } else {
                        stringBuffer.append(string.charAt(n6));
                    }
                    ++n6;
                }
            } else if (n7 < n4) {
                if (Helper.isVowel(string2.charAt(n7))) {
                    --n5;
                } else {
                    stringBuffer2.append(string2.charAt(n7));
                }
                ++n7;
            }
            ++n8;
        }
        while (n6 < n3) {
            stringBuffer.append(string.charAt(n6));
            ++n6;
        }
        while (n7 < n4) {
            stringBuffer2.append(string2.charAt(n7));
            ++n7;
        }
        return stringBuffer.toString() + stringBuffer2.toString();
    }

    public static Date sqlDateFromUtilDate(java.util.Date date) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(date);
        Date date2 = Helper.dateFromCalendar(calendar);
        Helper.releaseCalendar(calendar);
        return date2;
    }

    public static String printDate(Date date) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(date);
        String string = Helper.printDate(calendar);
        Helper.releaseCalendar(calendar);
        return string;
    }

    public static String printDate(Calendar calendar) {
        return Helper.printDate(calendar, true);
    }

    public static String printDate(Calendar calendar, boolean bl) {
        int n;
        int n2;
        int n3;
        Object object;
        if (bl && !defaultTimeZone.equals(calendar.getTimeZone())) {
            object = Helper.allocateCalendar();
            ((Calendar)object).setTimeInMillis(calendar.getTimeInMillis());
            n3 = ((Calendar)object).get(1);
            n2 = ((Calendar)object).get(2) + 1;
            n = ((Calendar)object).get(5);
            Helper.releaseCalendar((Calendar)object);
        } else {
            n3 = calendar.get(1);
            n2 = calendar.get(2) + 1;
            n = calendar.get(5);
        }
        object = "2000-00-00".toCharArray();
        object[0] = Character.forDigit(n3 / 1000, 10);
        object[1] = Character.forDigit(n3 / 100 % 10, 10);
        object[2] = Character.forDigit(n3 / 10 % 10, 10);
        object[3] = Character.forDigit(n3 % 10, 10);
        object[5] = Character.forDigit(n2 / 10, 10);
        object[6] = Character.forDigit(n2 % 10, 10);
        object[8] = Character.forDigit(n / 10, 10);
        object[9] = Character.forDigit(n % 10, 10);
        return new String((char[])object);
    }

    public static String printTime(Time time) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(time);
        String string = Helper.printTime(calendar);
        Helper.releaseCalendar(calendar);
        return string;
    }

    public static String printTime(Calendar calendar) {
        return Helper.printTime(calendar, true);
    }

    public static String printTime(Calendar calendar, boolean bl) {
        int n;
        int n2;
        int n3;
        Object object;
        if (bl && !defaultTimeZone.equals(calendar.getTimeZone())) {
            object = Helper.allocateCalendar();
            ((Calendar)object).setTimeInMillis(calendar.getTimeInMillis());
            n3 = ((Calendar)object).get(11);
            n2 = ((Calendar)object).get(12);
            n = ((Calendar)object).get(13);
            Helper.releaseCalendar((Calendar)object);
        } else {
            n3 = calendar.get(11);
            n2 = calendar.get(12);
            n = calendar.get(13);
        }
        object = n3 < 10 ? "0" + n3 : Integer.toString(n3);
        String string = n2 < 10 ? "0" + n2 : Integer.toString(n2);
        String string2 = n < 10 ? "0" + n : Integer.toString(n);
        return (String)object + ":" + string + ":" + string2;
    }

    public static String printCalendar(Calendar calendar) {
        return Helper.printCalendar(calendar, true);
    }

    public static String printCalendar(Calendar calendar, boolean bl) {
        String string = calendar.get(14) == 0 ? "0" : Helper.buildZeroPrefixAndTruncTrailZeros(calendar.get(14), 3);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Helper.printDate(calendar, bl));
        stringBuffer.append(" ");
        stringBuffer.append(Helper.printTime(calendar, bl));
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String printTimestamp(Timestamp timestamp) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(timestamp);
        String string = timestamp.getNanos() == 0 ? "0" : Helper.buildZeroPrefixAndTruncTrailZeros(timestamp.getNanos(), 9);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Helper.printDate(calendar));
        stringBuffer.append(" ");
        stringBuffer.append(Helper.printTime(calendar));
        stringBuffer.append(".");
        stringBuffer.append(string);
        Helper.releaseCalendar(calendar);
        return stringBuffer.toString();
    }

    public static String buildZeroPrefix(int n, int n2) {
        String string = Helper.buildZeroPrefixWithoutSign(n, n2);
        string = n < 0 ? "-" + string : "+" + string;
        return string;
    }

    public static String buildZeroPrefixWithoutSign(int n, int n2) {
        String string = "000000000";
        int n3 = n < 0 ? -n : n;
        String string2 = Integer.toString(n3);
        string2 = string.substring(0, n2 - string2.length()) + string2;
        return string2;
    }

    public static String buildZeroPrefixAndTruncTrailZeros(int n, int n2) {
        String string = "000000000";
        String string2 = Integer.toString(n);
        string2 = string.substring(0, n2 - string2.length()) + string2;
        char[] cArray = new char[string2.length()];
        string2.getChars(0, string2.length(), cArray, 0);
        int n3 = n2 - 1;
        while (cArray[n3] == '0') {
            --n3;
        }
        return new String(cArray, 0, n3 + 1);
    }

    public static String printTimestampWithoutNanos(Timestamp timestamp) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(timestamp);
        String string = Helper.printCalendarWithoutNanos(calendar);
        Helper.releaseCalendar(calendar);
        return string;
    }

    public static String printCalendarWithoutNanos(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Helper.printDate(calendar));
        stringBuffer.append(" ");
        stringBuffer.append(Helper.printTime(calendar));
        return stringBuffer.toString();
    }

    public static Date dateFromCalendar(Calendar calendar) {
        if (!defaultTimeZone.equals(calendar.getTimeZone())) {
            Calendar calendar2 = Helper.allocateCalendar();
            calendar2.setTimeInMillis(calendar.getTimeInMillis());
            Date date = Helper.dateFromYearMonthDate(calendar2.get(1), calendar2.get(2), calendar2.get(5));
            Helper.releaseCalendar(calendar2);
            return date;
        }
        if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0 && calendar.get(14) == 0) {
            return new Date(calendar.getTimeInMillis());
        }
        return Helper.dateFromYearMonthDate(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    public static void systemBug(String string) {
    }

    public static Time timeFromDate(java.util.Date date) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(date);
        Time time = Helper.timeFromCalendar(calendar);
        Helper.releaseCalendar(calendar);
        return time;
    }

    public static Time timeFromLong(Long l) {
        return new Time(l);
    }

    public static Time timeFromHourMinuteSecond(int n, int n2, int n3) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.clear();
        calendar.set(1970, 0, 1, n, n2, n3);
        long l = calendar.getTimeInMillis();
        Time time = new Time(l);
        Helper.releaseCalendar(calendar);
        return time;
    }

    public static Time timeFromString(String string) throws ConversionException {
        int n;
        int n2;
        int n3;
        String string2 = string;
        if (string.length() > 12) {
            string2 = string.substring(11, 19);
        }
        if (string2.indexOf(45) == -1 && string2.indexOf(47) == -1 && string2.indexOf(46) == -1 && string2.indexOf(58) == -1) {
            throw ConversionException.incorrectTimeFormat(string2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " /:.-");
        try {
            n3 = Integer.parseInt(stringTokenizer.nextToken());
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.incorrectTimeFormat(string);
        }
        return Helper.timeFromHourMinuteSecond(n3, n2, n);
    }

    public static Time timeFromTimestamp(Timestamp timestamp) {
        return Helper.timeFromDate(timestamp);
    }

    public static Time timeFromCalendar(Calendar calendar) {
        if (!defaultTimeZone.equals(calendar.getTimeZone())) {
            Calendar calendar2 = Helper.allocateCalendar();
            calendar2.setTimeInMillis(calendar.getTimeInMillis());
            Time time = Helper.timeFromHourMinuteSecond(calendar2.get(11), calendar2.get(12), calendar2.get(13));
            Helper.releaseCalendar(calendar2);
            return time;
        }
        return Helper.timeFromHourMinuteSecond(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static Timestamp timestampFromCalendar(Calendar calendar) {
        return Helper.timestampFromLong(calendar.getTimeInMillis());
    }

    public static Timestamp timestampFromDate(java.util.Date date) {
        return Helper.timestampFromLong(date.getTime());
    }

    public static Timestamp timestampFromLong(Long l) {
        return Helper.timestampFromLong((long)l);
    }

    public static Timestamp timestampFromLong(long l) {
        Timestamp timestamp = new Timestamp(l);
        if (l % 1000L > 0L) {
            timestamp.setNanos((int)(l % 1000L) * 1000000);
        } else if (l % 1000L < 0L) {
            timestamp.setNanos((int)(1000000000L - Math.abs(l % 1000L * 1000000L)));
        }
        return timestamp;
    }

    public static Timestamp timestampFromString(String string) throws ConversionException {
        int n;
        Object object;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (string.indexOf(45) == -1 && string.indexOf(47) == -1 && string.indexOf(46) == -1 && string.indexOf(58) == -1) {
            throw ConversionException.incorrectTimestampFormat(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " /:.-");
        try {
            int n7 = Integer.parseInt(stringTokenizer.nextToken());
            n6 = Integer.parseInt(stringTokenizer.nextToken());
            n5 = Integer.parseInt(stringTokenizer.nextToken());
            try {
                n4 = Integer.parseInt(stringTokenizer.nextToken());
                n3 = Integer.parseInt(stringTokenizer.nextToken());
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NoSuchElementException noSuchElementException) {
                n4 = 0;
                n3 = 0;
                n2 = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.incorrectTimestampFormat(string);
        }
        try {
            object = stringTokenizer.nextToken();
            n = Integer.parseInt((String)object);
            for (int i = 0; i < 9 - ((String)object).length(); ++i) {
                n *= 10;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            n = 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.incorrectTimestampFormat(string);
        }
        object = new Timestamp(n7 -= 1900, --n6, n5, n4, n3, n2, n);
        return object;
    }

    public static Timestamp timestampFromYearMonthDateHourMinuteSecondNanos(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new Timestamp(n - 1900, n2, n3, n4, n5, n6, n7);
    }

    public static void toDo(String string) {
    }

    public static String toSlashedClassName(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(46) >= 0) {
            return string.replace('.', '/');
        }
        return string;
    }

    public static String truncate(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        String string2 = "AaEeIiOoUu";
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = string.length() - n;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string2.indexOf(string.charAt(i)) == -1) {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (--n2 != 0) continue;
            StringBuffer stringBuffer2 = new StringBuffer(n);
            stringBuffer2.append(string.substring(0, i));
            stringBuffer2.append(stringBuffer.reverse().toString());
            return stringBuffer2.toString();
        }
        return stringBuffer.reverse().toString().substring(0, n);
    }

    public static java.util.Date utilDateFromLong(Long l) {
        return new java.util.Date(l);
    }

    public static java.util.Date utilDateFromSQLDate(Date date) {
        return new java.util.Date(date.getTime());
    }

    public static java.util.Date utilDateFromTime(Time time) {
        return new java.util.Date(time.getTime());
    }

    public static java.util.Date utilDateFromTimestamp(Timestamp timestamp) {
        boolean bl;
        long l = timestamp.getTime();
        boolean bl2 = bl = l % 1000L == 0L;
        if (bl) {
            return new java.util.Date(l + (long)(timestamp.getNanos() / 1000000));
        }
        return new java.util.Date(l);
    }

    public static Vector vectorFromArray(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
        return vector;
    }

    public static void writeHexString(byte[] byArray, Writer writer) throws IOException {
        writer.write(Helper.buildHexStringFromBytes(byArray));
    }

    public static boolean isEquivalentToNull(Object object) {
        return object == null || !isZeroValidPrimaryKey && (object.getClass() == ClassConstants.LONG && (Long)object <= 0L || object.getClass() == ClassConstants.INTEGER && (Integer)object <= 0);
    }

    public static int countOccurrencesOf(Object object, List list) {
        boolean bl;
        int n = 0;
        boolean bl2 = bl = object == null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (!(bl & e == null) && (bl || !object.equals(e))) continue;
                ++n;
            }
        }
        return n;
    }

    public static URI toURI(URL uRL) throws URISyntaxException {
        try {
            return uRL.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            return new URI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), uRL.getPath(), uRL.getQuery(), null);
        }
    }
}

