/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashSet
extends AbstractCollection
implements Set,
Cloneable,
Serializable {
    static final long serialVersionUID = 1619330892277906704L;
    static final int DEFAULT_INITIAL_CAPACITY = 32;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient Entry[] entries;
    protected transient int count = 0;
    protected int threshold = 0;
    protected float loadFactor = 0.0f;

    public IdentityHashSet(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initialCapacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal loadFactor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.entries = new Entry[n2];
    }

    public IdentityHashSet(int n) {
        this(n, 0.75f);
    }

    public IdentityHashSet() {
        this.loadFactor = 0.75f;
        this.threshold = 24;
        this.entries = new Entry[32];
    }

    public IdentityHashSet(Collection collection) {
        this(Math.max((int)((float)collection.size() / 0.75f) + 1, 32), 0.75f);
        this.addAll(collection);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        Entry[] entryArray = this.entries;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && object == entry.value) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    private void rehash() {
        int n = this.entries.length;
        Entry[] entryArray = this.entries;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.entries = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public boolean add(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.entries;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && object == entry.value) {
                return false;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.entries;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry(n, object, entryArray[n2]);
        ++this.count;
        return true;
    }

    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        Entry[] entryArray = this.entries;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n && object == entry.value) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                return true;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException("IdentityHashSet removeAll");
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException("IdentityHashSet retainAll");
    }

    public void clear() {
        if (this.count > 0) {
            Entry[] entryArray = this.entries;
            int n = entryArray.length;
            while (--n >= 0) {
                entryArray[n] = null;
            }
            this.count = 0;
        }
    }

    public Object clone() {
        try {
            Entry[] entryArray = this.entries;
            IdentityHashSet identityHashSet = (IdentityHashSet)super.clone();
            identityHashSet.entries = new Entry[entryArray.length];
            int n = entryArray.length;
            while (n-- > 0) {
                identityHashSet.entries[n] = entryArray[n] != null ? (Entry)entryArray[n].clone() : null;
            }
            return identityHashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Iterator iterator() {
        return new IdentityHashSetIterator();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.entries.length);
        objectOutputStream.writeInt(this.count);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.entries = new Entry[n];
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            this.add(objectInputStream.readObject());
        }
    }

    class IdentityHashSetIterator
    implements Iterator {
        Entry[] copyOfEntries;
        int index;
        Entry entry;
        Entry lastReturned;

        IdentityHashSetIterator() {
            this.copyOfEntries = IdentityHashSet.this.entries;
            this.index = this.copyOfEntries.length;
            this.entry = null;
            this.lastReturned = null;
        }

        public boolean hasNext() {
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = this.copyOfEntries;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            return entry != null;
        }

        public Object next() {
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = this.copyOfEntries;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            if (entry != null) {
                Entry entry2 = this.lastReturned = this.entry;
                this.entry = entry2.next;
                return entry2.value;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Entry[] entryArray = IdentityHashSet.this.entries;
            int n = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n];
            Entry entry2 = null;
            while (entry != null) {
                if (entry == this.lastReturned) {
                    if (entry2 == null) {
                        entryArray[n] = entry.next;
                    } else {
                        entry2.next = entry.next;
                    }
                    --IdentityHashSet.this.count;
                    this.lastReturned = null;
                    return;
                }
                entry2 = entry;
                entry = entry.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    static class Entry {
        int hash;
        Object value;
        Entry next;

        Entry(int n, Object object, Entry entry) {
            this.hash = n;
            this.value = object;
            this.next = entry;
        }

        protected Object clone() {
            Entry entry;
            Entry entry2 = this;
            Entry entry3 = entry = new Entry(this.hash, this.value, null);
            while (entry2.next != null) {
                entry3.next = new Entry(entry2.next.hash, entry2.next.value, null);
                entry2 = entry2.next;
                entry3 = entry3.next;
            }
            return entry;
        }
    }
}

