/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;

public abstract class AbstractIdentityMap
implements IdentityMap,
Serializable,
Cloneable {
    protected int maxSize;
    protected ClassDescriptor descriptor;

    public AbstractIdentityMap() {
    }

    public AbstractIdentityMap(int n) {
        this.maxSize = n;
    }

    public AbstractIdentityMap(int n, ClassDescriptor classDescriptor) {
        this(n);
        this.descriptor = classDescriptor;
    }

    public CacheKey acquireDeferredLock(Vector vector) {
        CacheKey cacheKey = this.createCacheKey(vector, null, null);
        cacheKey.acquireDeferredLock();
        CacheKey cacheKey2 = this.getCacheKeyIfAbsentPut(cacheKey);
        if (cacheKey2 == null) {
            return cacheKey;
        }
        cacheKey.releaseDeferredLock();
        cacheKey2.acquireDeferredLock();
        return cacheKey2;
    }

    public CacheKey acquireLock(Vector vector, boolean bl) {
        CacheKey cacheKey = this.createCacheKey(vector, null, null);
        cacheKey.acquire(bl);
        CacheKey cacheKey2 = this.getCacheKeyIfAbsentPut(cacheKey);
        if (cacheKey2 == null) {
            return cacheKey;
        }
        cacheKey.release();
        cacheKey2.acquire();
        return cacheKey2;
    }

    public CacheKey acquireLockNoWait(Vector vector, boolean bl) {
        CacheKey cacheKey = this.createCacheKey(vector, null, null);
        cacheKey.acquire(bl);
        CacheKey cacheKey2 = this.getCacheKeyIfAbsentPut(cacheKey);
        if (cacheKey2 == null) {
            return cacheKey;
        }
        cacheKey.release();
        if (!cacheKey2.acquireNoWait(bl)) {
            return null;
        }
        return cacheKey2;
    }

    public CacheKey acquireLockWithWait(Vector vector, boolean bl, int n) {
        CacheKey cacheKey = this.createCacheKey(vector, null, null);
        cacheKey.acquire(bl);
        CacheKey cacheKey2 = this.getCacheKeyIfAbsentPut(cacheKey);
        if (cacheKey2 == null) {
            return cacheKey;
        }
        cacheKey.release();
        if (!cacheKey2.acquireWithWait(bl, n)) {
            return null;
        }
        return cacheKey2;
    }

    public CacheKey acquireReadLockOnCacheKey(Vector vector) {
        CacheKey cacheKey = this.createCacheKey(vector, null, null);
        CacheKey cacheKey2 = this.getCacheKey(cacheKey);
        if (cacheKey2 == null) {
            cacheKey.acquireReadLock();
            return cacheKey;
        }
        cacheKey2.acquireReadLock();
        return cacheKey2;
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector vector) {
        CacheKey cacheKey = this.createCacheKey(vector, null, null);
        CacheKey cacheKey2 = this.getCacheKey(cacheKey);
        if (cacheKey2 == null) {
            cacheKey.acquireReadLock();
            return cacheKey;
        }
        if (!cacheKey2.acquireReadLockNoWait()) {
            return null;
        }
        return cacheKey2;
    }

    public abstract void collectLocks(HashMap var1);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public boolean containsKey(Vector vector) {
        return this.getCacheKeyWithReadLock(vector) != null;
    }

    public CacheKey createCacheKey(Vector vector, Object object, Object object2) {
        return this.createCacheKey(vector, object, object2, 0L);
    }

    public CacheKey createCacheKey(Vector vector, Object object, Object object2, long l) {
        return new CacheKey(vector, object, object2, l);
    }

    public abstract Enumeration elements();

    public Object get(Vector vector) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(vector);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getObject();
    }

    public CacheKey getCacheKey(Vector vector) {
        CacheKey cacheKey = new CacheKey(vector);
        return this.getCacheKey(cacheKey);
    }

    public CacheKey getCacheKeyForLock(Vector vector) {
        return this.getCacheKey(vector);
    }

    protected abstract CacheKey getCacheKey(CacheKey var1);

    protected abstract CacheKey getCacheKeyIfAbsentPut(CacheKey var1);

    protected CacheKey getCacheKeyWithReadLock(Vector vector) {
        CacheKey cacheKey = this.getCacheKey(vector);
        if (cacheKey != null) {
            cacheKey.checkReadLock();
        }
        return cacheKey;
    }

    public static Class getDefaultIdentityMapClass() {
        return ClassConstants.SoftCacheWeakIdentityMap_Class;
    }

    public int getMaxSize() {
        if (this.maxSize == -1) {
            this.maxSize = 100;
        }
        return this.maxSize;
    }

    public abstract int getSize();

    public abstract int getSize(Class var1, boolean var2);

    public Object getWrapper(Vector vector) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(vector);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getWrapper();
    }

    public Object getWriteLockValue(Vector vector) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(vector);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getWriteLockValue();
    }

    public abstract Enumeration keys();

    public abstract CacheKey put(Vector var1, Object var2, Object var3, long var4);

    public void release() {
    }

    public Object remove(Vector vector, Object object) {
        CacheKey cacheKey = this.getCacheKeyForLock(vector);
        return this.remove(cacheKey);
    }

    public abstract Object remove(CacheKey var1);

    protected synchronized void setMaxSize(int n) {
        this.maxSize = n;
    }

    public void updateMaxSize(int n) {
        this.setMaxSize(n);
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Class getDescriptorClass() {
        return this.descriptor.getJavaClass();
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    public void setWrapper(Vector vector, Object object) {
        CacheKey cacheKey = this.getCacheKeyForLock(vector);
        if (cacheKey != null) {
            cacheKey.setWrapper(object);
        }
    }

    public void setWriteLockValue(Vector vector, Object object) {
        CacheKey cacheKey = this.getCacheKeyForLock(vector);
        if (cacheKey != null) {
            cacheKey.acquire();
            cacheKey.setWriteLockValue(object);
            cacheKey.release();
        }
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "[" + this.getSize() + "]";
    }
}

