/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.AbstractIdentityMap;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMapEnumeration;
import org.eclipse.persistence.internal.identitymaps.IdentityMapKeyEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullIdentityMap
extends AbstractIdentityMap {
    protected Map<CacheKey, CacheKey> cacheKeys;

    public FullIdentityMap() {
    }

    public FullIdentityMap(int n) {
        super(n);
        this.cacheKeys = new ConcurrentHashMap<CacheKey, CacheKey>(n);
    }

    public FullIdentityMap(int n, ClassDescriptor classDescriptor) {
        super(n, classDescriptor);
        this.cacheKeys = new ConcurrentHashMap<CacheKey, CacheKey>(n);
    }

    @Override
    public Object clone() {
        FullIdentityMap fullIdentityMap = (FullIdentityMap)super.clone();
        fullIdentityMap.setCacheKeys(new ConcurrentHashMap<CacheKey, CacheKey>(this.getCacheKeys().size()));
        Iterator<CacheKey> iterator = this.getCacheKeys().values().iterator();
        while (iterator.hasNext()) {
            CacheKey cacheKey = (CacheKey)iterator.next().clone();
            fullIdentityMap.getCacheKeys().put(cacheKey, cacheKey);
        }
        return fullIdentityMap;
    }

    @Override
    public void collectLocks(HashMap hashMap) {
        for (CacheKey cacheKey : this.getCacheKeys().values()) {
            if (!cacheKey.isAcquired()) continue;
            Thread thread = cacheKey.getMutex().getActiveThread();
            HashSet<CacheKey> hashSet = (HashSet<CacheKey>)hashMap.get(thread);
            if (hashSet == null) {
                hashSet = new HashSet<CacheKey>();
                hashMap.put(thread, hashSet);
            }
            hashSet.add(cacheKey);
        }
    }

    @Override
    public Enumeration elements() {
        return new IdentityMapEnumeration(this);
    }

    @Override
    protected CacheKey getCacheKey(CacheKey cacheKey) {
        return this.getCacheKeys().get(cacheKey);
    }

    @Override
    protected CacheKey getCacheKeyIfAbsentPut(CacheKey cacheKey) {
        CacheKey cacheKey2 = this.getCacheKeys().get(cacheKey);
        if (cacheKey2 == null) {
            cacheKey.setOwningMap(this);
            cacheKey2 = ((ConcurrentMap)this.getCacheKeys()).putIfAbsent(cacheKey, cacheKey);
        }
        return cacheKey2;
    }

    public Map<CacheKey, CacheKey> getCacheKeys() {
        return this.cacheKeys;
    }

    @Override
    public int getSize() {
        return this.cacheKeys.size();
    }

    @Override
    public int getSize(Class clazz, boolean bl) {
        int n = 0;
        for (CacheKey cacheKey : this.getCacheKeys().values()) {
            Object object = cacheKey.getObject();
            if (object == null) continue;
            if (bl && clazz.isInstance(object)) {
                ++n;
                continue;
            }
            if (!object.getClass().equals(clazz)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Enumeration keys() {
        return new IdentityMapKeyEnumeration(this);
    }

    @Override
    public CacheKey put(Vector vector, Object object, Object object2, long l) {
        CacheKey cacheKey = this.createCacheKey(vector, object, object2, l);
        CacheKey cacheKey2 = this.getCacheKeyIfAbsentPut(cacheKey);
        if (cacheKey2 == null) {
            return cacheKey;
        }
        this.resetCacheKey(cacheKey2, object, object2, l);
        return cacheKey2;
    }

    @Override
    public Object remove(CacheKey cacheKey) {
        if (cacheKey != null) {
            cacheKey.acquire();
            this.getCacheKeys().remove(cacheKey);
            cacheKey.release();
            return cacheKey.getObject();
        }
        return null;
    }

    public void resetCacheKey(CacheKey cacheKey, Object object, Object object2, long l) {
        cacheKey.acquire();
        cacheKey.setObject(object);
        cacheKey.setWriteLockValue(object2);
        cacheKey.setReadTime(l);
        cacheKey.release();
    }

    protected void setCacheKeys(Map<CacheKey, CacheKey> map) {
        this.cacheKeys = map;
    }
}

