/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.LogicalOperatorNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.jpa.parsing.VariableNode;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class DotNode
extends LogicalOperatorNode {
    private Object enumConstant;

    public void applyToQuery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        if (objectLevelReadQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)objectLevelReadQuery;
            reportQuery.addAttribute(this.resolveAttribute(), this.generateExpression(generationContext));
            reportQuery.dontRetrievePrimaryKeys();
        }
    }

    public Node qualifyAttributeAccess(ParseTreeContext parseTreeContext) {
        if (this.getLeft() != null) {
            this.setLeft(this.getLeft().qualifyAttributeAccess(parseTreeContext));
        }
        return this;
    }

    public void validate(ParseTreeContext parseTreeContext) {
        TypeHelper typeHelper = parseTreeContext.getTypeHelper();
        String string = ((AttributeNode)this.right).getAttributeName();
        Node node = this.getLeftMostNode();
        if (this.isDeclaredVariable(node, parseTreeContext)) {
            this.left.validate(parseTreeContext);
            this.checkNavigation(this.left, parseTreeContext);
            Object object = typeHelper.resolveAttribute(this.left.getType(), string);
            if (object == null) {
                throw JPQLException.unknownAttribute(parseTreeContext.getQueryInfo(), this.right.getLine(), this.right.getColumn(), string, typeHelper.getTypeName(this.left.getType()));
            }
            this.setType(object);
            this.right.setType(object);
        } else {
            String string2 = this.left.getAsString();
            Object object = this.resolveEnumTypeName(string2, typeHelper);
            if (object != null && typeHelper.isEnumType(object)) {
                this.enumConstant = typeHelper.resolveEnumConstant(object, string);
                if (this.enumConstant == null) {
                    throw JPQLException.invalidEnumLiteral(parseTreeContext.getQueryInfo(), this.right.getLine(), this.right.getColumn(), string2, string);
                }
            } else {
                throw JPQLException.aliasResolutionException(parseTreeContext.getQueryInfo(), node.getLine(), node.getColumn(), node.getAsString());
            }
            this.setType(object);
            this.right.setType(object);
        }
    }

    private void checkNavigation(Node node, ParseTreeContext parseTreeContext) {
        Object object;
        TypeHelper typeHelper = parseTreeContext.getTypeHelper();
        if (!(typeHelper.isEntityClass(object = node.getType()) || typeHelper.isEmbeddable(object) || typeHelper.isEnumType(object))) {
            throw JPQLException.invalidNavigation(parseTreeContext.getQueryInfo(), node.getLine(), node.getColumn(), this.getAsString(), node.getAsString(), typeHelper.getTypeName(object));
        }
        if (node.isDotNode()) {
            Node node2 = node.getLeft();
            AttributeNode attributeNode = (AttributeNode)node.getRight();
            if (typeHelper.isCollectionValuedRelationship(node2.getType(), attributeNode.getAttributeName())) {
                throw JPQLException.invalidCollectionNavigation(parseTreeContext.getQueryInfo(), attributeNode.getLine(), attributeNode.getColumn(), this.getAsString(), attributeNode.getAttributeName());
            }
        }
    }

    private boolean isDeclaredVariable(Node node, ParseTreeContext parseTreeContext) {
        if (node.isVariableNode()) {
            String string = ((VariableNode)node).getCanonicalVariableName();
            return parseTreeContext.isVariable(string);
        }
        return false;
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Node node = this.getLeft();
        Node node2 = this.getRight();
        if (this.enumConstant != null) {
            return new ConstantExpression(this.enumConstant, new ExpressionBuilder());
        }
        Expression expression = this.getLeft().generateExpression(generationContext);
        if (node2.isAttributeNode()) {
            ((AttributeNode)node2).setMapping(this.resolveMapping(generationContext));
        }
        expression = node2.addToExpression(expression, generationContext);
        return expression;
    }

    public boolean isDotNode() {
        return true;
    }

    public boolean endsWithDirectToField(GenerationContext generationContext) {
        DatabaseMapping databaseMapping = this.resolveMapping(generationContext);
        return databaseMapping != null && databaseMapping.isDirectToFieldMapping();
    }

    public Class getTypeOfDirectToField(GenerationContext generationContext) {
        DatabaseMapping databaseMapping = this.resolveMapping(generationContext);
        if (databaseMapping != null && databaseMapping.isDirectToFieldMapping()) {
            return ((DirectToFieldMapping)databaseMapping).getAttributeClassification();
        }
        return null;
    }

    public boolean endsWithCollectionField(GenerationContext generationContext) {
        DatabaseMapping databaseMapping = this.resolveMapping(generationContext);
        return databaseMapping != null && databaseMapping.isCollectionMapping();
    }

    public String resolveAttribute() {
        return ((AttributeNode)this.getRight()).getAttributeName();
    }

    public DatabaseMapping resolveMapping(GenerationContext generationContext) {
        Class clazz = this.getLeft().resolveClass(generationContext);
        return this.getRight().resolveMapping(generationContext, clazz);
    }

    public Class resolveClass(GenerationContext generationContext) {
        Class clazz = this.getLeft().resolveClass(generationContext);
        return this.getRight().resolveClass(generationContext, clazz);
    }

    public String getAsString() {
        return this.left.getAsString() + "." + this.right.getAsString();
    }

    private Node getLeftMostNode() {
        return this.left.isDotNode() ? ((DotNode)this.left).getLeftMostNode() : this.left;
    }

    private Object resolveEnumTypeName(String string, TypeHelper typeHelper) {
        int n;
        Object object = typeHelper.resolveTypeName(string);
        if (object == null && (n = string.lastIndexOf(46)) != -1) {
            string = string.substring(0, n) + '$' + string.substring(n + 1);
            object = typeHelper.resolveTypeName(string);
        }
        return object;
    }
}

