/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.BinaryOperatorNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class EqualsNode
extends BinaryOperatorNode {
    public void validate(ParseTreeContext parseTreeContext) {
        super.validate(parseTreeContext);
        TypeHelper typeHelper = parseTreeContext.getTypeHelper();
        Object object = this.left.getType();
        Object object2 = this.right.getType();
        if (typeHelper.isEnumType(object) && !typeHelper.isEnumType(object2)) {
            throw JPQLException.invalidEnumEqualExpression(parseTreeContext.getQueryInfo(), this.getLine(), this.getColumn(), typeHelper.getTypeName(object), typeHelper.getTypeName(object2));
        }
        if (typeHelper.isEnumType(object2) && !typeHelper.isEnumType(object)) {
            throw JPQLException.invalidEnumEqualExpression(parseTreeContext.getQueryInfo(), this.getLine(), this.getColumn(), typeHelper.getTypeName(object2), typeHelper.getTypeName(object));
        }
        this.setType(typeHelper.getBooleanType());
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression expression = this.getLeft().generateExpression(generationContext);
        expression = expression.equal(this.getRight().generateExpression(generationContext));
        return expression;
    }

    public String getAsString() {
        return this.left.getAsString() + " = " + this.right.getAsString();
    }
}

