/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.internal.jpa.parsing.ConstructorNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.MajorNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SelectNode;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class GroupByNode
extends MajorNode {
    List groupByItems = null;

    public void validate(ParseTreeContext parseTreeContext, SelectNode selectNode) {
        Object object2;
        for (Object object2 : this.groupByItems) {
            ((Node)object2).validate(parseTreeContext);
        }
        List list = selectNode.getSelectExpressions();
        object2 = list.iterator();
        while (object2.hasNext()) {
            Node node = (Node)object2.next();
            if (this.isValidSelectExpr(node)) continue;
            throw JPQLException.invalidSelectForGroupByQuery(parseTreeContext.getQueryInfo(), node.getLine(), node.getColumn(), node.getAsString(), this.getAsString());
        }
    }

    private void addGroupByItem(Object object) {
        this.getGroupByItems().add(object);
    }

    public void addGroupingToQuery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        if (objectLevelReadQuery.isReportQuery()) {
            for (Node node : this.getGroupByItems()) {
                ((ReportQuery)objectLevelReadQuery).addGrouping(node.generateExpression(generationContext));
            }
        }
    }

    public boolean isValidHavingExpr(Node node) {
        if (node.isDotNode() || node.isVariableNode()) {
            return this.isGroupbyItem(node);
        }
        Node node2 = node.getLeft();
        Node node3 = node.getRight();
        return !(node2 != null && !this.isValidHavingExpr(node2) || node3 != null && !this.isValidHavingExpr(node3));
    }

    private boolean isValidSelectExpr(Node node) {
        if (node.isAggregateNode()) {
            return true;
        }
        if (node.isConstructorNode()) {
            List list = ((ConstructorNode)node).getConstructorItems();
            for (Node node2 : list) {
                if (this.isValidSelectExpr(node2)) continue;
                return false;
            }
            return true;
        }
        return this.isGroupbyItem(node);
    }

    private boolean isGroupbyItem(Node node) {
        if (node.isDotNode() || node.isVariableNode()) {
            String string = node.getAsString();
            for (Node node2 : this.groupByItems) {
                String string2 = node2.getAsString();
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public List getGroupByItems() {
        if (this.groupByItems == null) {
            this.setGroupByItems(new Vector());
        }
        return this.groupByItems;
    }

    public void setGroupByItems(List list) {
        this.groupByItems = list;
    }

    public String getAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Node node : this.groupByItems) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(node.getAsString());
        }
        return "GROUP BY " + stringBuffer.toString();
    }
}

