/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.jpa.parsing.ArithmeticFunctionNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class ModNode
extends ArithmeticFunctionNode {
    private Node denominator = null;

    public Node qualifyAttributeAccess(ParseTreeContext parseTreeContext) {
        if (this.left != null) {
            this.left = this.left.qualifyAttributeAccess(parseTreeContext);
        }
        if (this.denominator != null) {
            this.denominator = this.denominator.qualifyAttributeAccess(parseTreeContext);
        }
        return this;
    }

    public void validate(ParseTreeContext parseTreeContext) {
        Object object;
        TypeHelper typeHelper = parseTreeContext.getTypeHelper();
        if (this.left != null) {
            this.left.validate(parseTreeContext);
            this.left.validateParameter(parseTreeContext, typeHelper.getIntType());
            object = this.left.getType();
            if (!typeHelper.isIntegralType(object)) {
                throw JPQLException.invalidFunctionArgument(parseTreeContext.getQueryInfo(), this.left.getLine(), this.left.getColumn(), "MOD", this.left.getAsString(), "integral type");
            }
        }
        if (this.denominator != null) {
            this.denominator.validate(parseTreeContext);
            this.denominator.validateParameter(parseTreeContext, typeHelper.getIntType());
            object = this.denominator.getType();
            if (!typeHelper.isIntegralType(object)) {
                throw JPQLException.invalidFunctionArgument(parseTreeContext.getQueryInfo(), this.denominator.getLine(), this.denominator.getColumn(), "MOD", this.denominator.getAsString(), "integral type");
            }
        }
        this.setType(typeHelper.getIntType());
    }

    public Expression generateExpression(GenerationContext generationContext) {
        return ExpressionMath.mod(this.getLeft().generateExpression(generationContext), this.getDenominator().generateExpression(generationContext));
    }

    public Node getDenominator() {
        return this.denominator;
    }

    public void setDenominator(Node node) {
        this.denominator = node;
    }
}

