/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.ConstructorNode;
import org.eclipse.persistence.internal.jpa.parsing.DotNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.QueryNode;
import org.eclipse.persistence.internal.jpa.parsing.SelectGenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.jpa.parsing.VariableNode;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class SelectNode
extends QueryNode {
    private List selectExpressions = new ArrayList();
    private boolean distinct = false;

    public List getSelectExpressions() {
        return this.selectExpressions;
    }

    public void setSelectExpressions(List list) {
        this.selectExpressions = list;
    }

    public boolean usesDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public DatabaseQuery createDatabaseQuery(ParseTreeContext parseTreeContext) {
        ReadAllQuery readAllQuery = this.isReadAllQuery(parseTreeContext) ? new ReadAllQuery() : new ReportQuery();
        readAllQuery.dontUseDistinct();
        return readAllQuery;
    }

    private boolean isReadAllQuery(ParseTreeContext parseTreeContext) {
        if (!this.isSingleSelectExpression()) {
            return false;
        }
        Node node = this.getFirstSelectExpressionNode();
        if (!node.isVariableNode()) {
            return false;
        }
        String string = ((VariableNode)node).getCanonicalVariableName();
        String string2 = this.getParseTree().getFromNode().getFirstVariable();
        if (!parseTreeContext.isRangeVariable(string2)) {
            return false;
        }
        return string2.equals(string);
    }

    public void applyToQuery(DatabaseQuery databaseQuery, GenerationContext generationContext) {
        Object object;
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)databaseQuery;
        if (this.selectExpressions.isEmpty()) {
            return;
        }
        if (!(this.isSingleSelectExpression() && this.getFirstSelectExpressionNode().isCountNode() || !this.usesDistinct())) {
            this.getParseTree().setDistinctState((short)1);
            objectLevelReadQuery.setDistinctState((short)1);
        }
        if (objectLevelReadQuery instanceof ReportQuery) {
            object = (ReportQuery)objectLevelReadQuery;
            ((ReportQuery)object).returnWithoutReportQueryResult();
            if (this.isSingleSelectExpression()) {
                ((ReportQuery)object).returnSingleAttribute();
            }
        }
        object = (SelectGenerationContext)generationContext;
        for (Node node : this.selectExpressions) {
            if (this.selectingRelationshipField(node, generationContext)) {
                ((SelectGenerationContext)object).useOuterJoins();
            }
            node.applyToQuery(objectLevelReadQuery, generationContext);
            ((SelectGenerationContext)object).dontUseOuterJoins();
        }
        objectLevelReadQuery.setShouldBuildNullForNullPk(this.hasOneToOneSelected(generationContext));
    }

    public boolean hasOneToOneSelected(GenerationContext generationContext) {
        for (Node node : this.selectExpressions) {
            if (!this.hasOneToOneSelected(node, generationContext)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOneToOneSelected(Node node, GenerationContext generationContext) {
        if (node.isCountNode()) {
            return false;
        }
        if (node.isAggregateNode()) {
            return this.hasOneToOneSelected(node.getLeft(), generationContext);
        }
        if (node.isVariableNode()) {
            return !this.nodeRefersToObject(node, generationContext);
        }
        if (node.isConstructorNode()) {
            List list = ((ConstructorNode)node).getConstructorItems();
            for (Node node2 : list) {
                if (!this.hasOneToOneSelected(node2, generationContext)) continue;
                return true;
            }
            return false;
        }
        return !this.selectingDirectToField(node, generationContext);
    }

    public void verifySelectedAlias(GenerationContext generationContext) {
        for (Node node : this.selectExpressions) {
            if (node.isDotNode()) {
                return;
            }
            node.resolveClass(generationContext);
        }
    }

    public boolean isSelected(String string) {
        for (Node node : this.selectExpressions) {
            if (!node.isVariableNode() || !((VariableNode)node).getCanonicalVariableName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isSelectNode() {
        return true;
    }

    public Node qualifyAttributeAccess(ParseTreeContext parseTreeContext) {
        for (int i = 0; i < this.selectExpressions.size(); ++i) {
            Node node = (Node)this.selectExpressions.get(i);
            this.selectExpressions.set(i, node.qualifyAttributeAccess(parseTreeContext));
        }
        return this;
    }

    public void validate(ParseTreeContext parseTreeContext) {
        for (Node node : this.selectExpressions) {
            node.validate(parseTreeContext);
        }
    }

    public Class resolveClass(GenerationContext generationContext) {
        return this.getReferenceClass(generationContext);
    }

    public Expression generateExpression(GenerationContext generationContext) {
        return null;
    }

    public Class getReferenceClass(GenerationContext generationContext) {
        return this.getClassOfFirstVariable(generationContext);
    }

    private Class getClassOfFirstVariable(GenerationContext generationContext) {
        Class clazz = null;
        String string = this.getParseTree().getFromNode().getFirstVariable();
        ParseTreeContext parseTreeContext = generationContext.getParseTreeContext();
        if (parseTreeContext.isRangeVariable(string)) {
            String string2 = parseTreeContext.schemaForVariable(string);
            clazz = parseTreeContext.classForSchemaName(string2, generationContext);
        } else {
            Node node = parseTreeContext.pathForVariable(string);
            clazz = node.resolveClass(generationContext);
        }
        return clazz;
    }

    public boolean isVariableInINClauseSelected(GenerationContext generationContext) {
        for (Node node : this.selectExpressions) {
            if (!node.isVariableNode()) continue;
            String string = ((VariableNode)node).getCanonicalVariableName();
            if (generationContext.getParseTreeContext().isRangeVariable(string)) continue;
            return true;
        }
        return false;
    }

    public boolean nodeRefersToObject(Node node, GenerationContext generationContext) {
        ClassDescriptor classDescriptor;
        if (!node.isVariableNode()) {
            return false;
        }
        String string = ((VariableNode)node).getCanonicalVariableName();
        String string2 = generationContext.getParseTreeContext().schemaForVariable(string);
        return string2 != null && (classDescriptor = generationContext.getSession().getDescriptorForAlias(string2)) != null;
    }

    private boolean selectingRelationshipField(Node node, GenerationContext generationContext) {
        if (node == null || !node.isDotNode()) {
            return false;
        }
        TypeHelper typeHelper = generationContext.getParseTreeContext().getTypeHelper();
        Node node2 = node.getLeft();
        AttributeNode attributeNode = (AttributeNode)node.getRight();
        return typeHelper.isRelationship(node2.getType(), attributeNode.getAttributeName());
    }

    private boolean selectingDirectToField(Node node, GenerationContext generationContext) {
        if (node == null || !node.isDotNode()) {
            return false;
        }
        return ((DotNode)node).endsWithDirectToField(generationContext);
    }

    private Node getFirstSelectExpressionNode() {
        return this.selectExpressions.size() > 0 ? (Node)this.selectExpressions.get(0) : null;
    }

    private boolean isSingleSelectExpression() {
        return this.selectExpressions.size() == 1;
    }
}

