/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLNodeList;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnmarshalXPathEngine {
    private static UnmarshalXPathEngine instance = null;
    private XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();

    public static UnmarshalXPathEngine getInstance() {
        if (instance == null) {
            instance = new UnmarshalXPathEngine();
        }
        return instance;
    }

    public Object selectSingleNode(Node node, XMLField xMLField, XMLNamespaceResolver xMLNamespaceResolver) throws XMLMarshalException {
        try {
            if (node == null) {
                return null;
            }
            XPathFragment xPathFragment = xMLField.getXPathFragment();
            if (xPathFragment.shouldExecuteSelectNodes()) {
                return this.xmlPlatform.selectSingleNodeAdvanced(node, xMLField.getXPath(), xMLNamespaceResolver);
            }
            Object object = this.selectSingleNode(node, xPathFragment, xMLNamespaceResolver);
            if (object == XMLRecord.noEntry) {
                if (xMLField.getLastXPathFragment().nameIsText() || xMLField.getLastXPathFragment().isAttribute()) {
                    return object;
                }
                return null;
            }
            return object;
        }
        catch (Exception exception) {
            throw XMLMarshalException.invalidXPathString(xMLField.getXPath(), exception);
        }
    }

    private Object selectSingleNode(Node node, XPathFragment xPathFragment, XMLNamespaceResolver xMLNamespaceResolver) {
        Node node2 = this.getSingleNode(node, xPathFragment, xMLNamespaceResolver);
        if (node2 == null) {
            if (!xPathFragment.nameIsText()) {
                return XMLRecord.noEntry;
            }
            return null;
        }
        if (xPathFragment.getNextFragment() == null) {
            return node2;
        }
        return this.selectSingleNode(node2, xPathFragment.getNextFragment(), xMLNamespaceResolver);
    }

    public NodeList selectNodes(Node node, XMLField xMLField, XMLNamespaceResolver xMLNamespaceResolver) throws XMLMarshalException {
        try {
            if (node == null) {
                return null;
            }
            XPathFragment xPathFragment = xMLField.getXPathFragment();
            if (xPathFragment.shouldExecuteSelectNodes()) {
                return this.xmlPlatform.selectNodesAdvanced(node, xMLField.getXPath(), xMLNamespaceResolver);
            }
            return this.selectNodes(node, xPathFragment, xMLNamespaceResolver);
        }
        catch (Exception exception) {
            throw XMLMarshalException.invalidXPathString(xMLField.getXPath(), exception);
        }
    }

    private NodeList selectNodes(Node node, XPathFragment xPathFragment, XMLNamespaceResolver xMLNamespaceResolver) {
        NodeList nodeList = this.getNodes(node, xPathFragment, xMLNamespaceResolver);
        if (xPathFragment.getNextFragment() != null) {
            XMLNodeList xMLNodeList = new XMLNodeList();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                xMLNodeList.addAll(this.selectNodes(node2, xPathFragment.getNextFragment(), xMLNamespaceResolver));
            }
            return xMLNodeList;
        }
        return nodeList;
    }

    private Node getSingleNode(Node node, XPathFragment xPathFragment, XMLNamespaceResolver xMLNamespaceResolver) {
        if (xPathFragment.isAttribute()) {
            return this.selectSingleAttribute(node, xPathFragment, xMLNamespaceResolver);
        }
        if (xPathFragment.nameIsText()) {
            return this.selectSingleText(node);
        }
        if (xPathFragment.isSelfFragment()) {
            return node;
        }
        if (xPathFragment.containsIndex()) {
            return this.selectSingleElement(node, xPathFragment, xMLNamespaceResolver, xPathFragment.getIndexValue());
        }
        return this.selectSingleElement(node, xPathFragment, xMLNamespaceResolver);
    }

    private NodeList getNodes(Node node, XPathFragment xPathFragment, XMLNamespaceResolver xMLNamespaceResolver) {
        if (xPathFragment.isAttribute()) {
            return this.selectAttributeNodes(node, xPathFragment, xMLNamespaceResolver);
        }
        if (xPathFragment.nameIsText()) {
            return this.selectTextNodes(node);
        }
        if (xPathFragment.isSelfFragment()) {
            XMLNodeList xMLNodeList = new XMLNodeList(1);
            xMLNodeList.add(node);
            return xMLNodeList;
        }
        if (xPathFragment.containsIndex()) {
            return this.selectElementNodes(node, xPathFragment, xMLNamespaceResolver, xPathFragment.getIndexValue());
        }
        return this.selectElementNodes(node, xPathFragment, xMLNamespaceResolver);
    }

    private Node selectSingleAttribute(Node node, XPathFragment xPathFragment, XMLNamespaceResolver xMLNamespaceResolver) {
        if (xPathFragment.hasNamespace()) {
            Element element = (Element)node;
            String string = xMLNamespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
            return element.getAttributeNodeNS(string, xPathFragment.getLocalName());
        }
        Element element = (Element)node;
        return element.getAttributeNode(xPathFragment.getShortName());
    }

    private NodeList selectAttributeNodes(Node node, XPathFragment xPathFragment, XMLNamespaceResolver xMLNamespaceResolver) {
        XMLNodeList xMLNodeList = new XMLNodeList();
        Node node2 = this.selectSingleAttribute(node, xPathFragment, xMLNamespaceResolver);
        if (null != node2) {
            xMLNodeList.add(node2);
        }
        return xMLNodeList;
    }

    private Node selectSingleElement(Node node, XPathFragment xPathFragment, XMLNamespaceResolver xMLNamespaceResolver) {
        for (Node node2 = node.getFirstChild(); null != node2; node2 = node2.getNextSibling()) {
            String string = null;
            if (xMLNamespaceResolver != null) {
                string = xMLNamespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
            }
            if (node2.getNodeType() != 1 || !this.sameName(node2, xPathFragment.getLocalName()) || !this.sameNamespaceURI(node2, string)) continue;
            return node2;
        }
        return null;
    }

    public NodeList selectElementNodes(Node node, XPathFragment xPathFragment, XMLNamespaceResolver xMLNamespaceResolver) {
        XMLNodeList xMLNodeList = new XMLNodeList();
        for (Node node2 = node.getFirstChild(); null != node2; node2 = node2.getNextSibling()) {
            String string = null;
            if (xMLNamespaceResolver != null) {
                string = xMLNamespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
            }
            if (node2.getNodeType() != 1 || !this.sameName(node2, xPathFragment.getLocalName()) || !this.sameNamespaceURI(node2, string)) continue;
            xMLNodeList.add(node2);
        }
        return xMLNodeList;
    }

    private Node selectSingleElement(Node node, XPathFragment xPathFragment, XMLNamespaceResolver xMLNamespaceResolver, int n) {
        for (Node node2 = node.getFirstChild(); null != node2; node2 = node2.getNextSibling()) {
            String string = null;
            if (xMLNamespaceResolver != null) {
                string = xMLNamespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
            }
            if (node2.getNodeType() != 1 || !this.sameName(node2, xPathFragment.getShortName()) || !this.sameNamespaceURI(node2, string) || 0 != --n) continue;
            return node2;
        }
        return null;
    }

    private NodeList selectElementNodes(Node node, XPathFragment xPathFragment, XMLNamespaceResolver xMLNamespaceResolver, int n) {
        XMLNodeList xMLNodeList = new XMLNodeList();
        Node node2 = this.selectSingleElement(node, xPathFragment, xMLNamespaceResolver, n);
        if (null != node2) {
            xMLNodeList.add(node2);
        }
        return xMLNodeList;
    }

    private Node selectSingleText(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            Node node2 = nodeList.item(0);
            if (node2.getNodeType() == 3 || node2.getNodeType() == 4) {
                return node2;
            }
            return null;
        }
        String string = null;
        for (int i = 0; i < n; ++i) {
            String string2;
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 3 && node3.getNodeType() != 4 || (string2 = node3.getNodeValue()) == null) continue;
            if (string == null) {
                string = new String();
            }
            if (node3.getNodeType() == 4) {
                string2 = string2.trim();
            }
            string = string + string2;
        }
        if (string != null) {
            return node.getOwnerDocument().createTextNode(string);
        }
        return null;
    }

    private NodeList selectTextNodes(Node node) {
        Node node2 = this.selectSingleText(node);
        XMLNodeList xMLNodeList = new XMLNodeList();
        if (node2 != null) {
            xMLNodeList.add(node2);
        }
        return xMLNodeList;
    }

    private boolean sameNamespaceURI(Node node, String string) {
        String string2 = node.getNamespaceURI();
        if (string2 == string) {
            return true;
        }
        if (string2 == null && string.equals("")) {
            return true;
        }
        if (string == null && string2.equals("")) {
            return true;
        }
        return null != string2 && string2.equals(string);
    }

    private boolean sameName(Node node, String string) {
        return string.equals(node.getLocalName()) || string.equals(node.getNodeName());
    }
}

